'use strict';

var _classCallCheck = function (instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } };

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

Object.defineProperty(exports, '__esModule', {
  value: true
});
// ASCII ESCAPE SEQUENCE http://www5c.biglobe.ne.jp/~ecb/assembler2/b_2.html
var levelToColor = {
  v: '\u001b[35m[V]', // purple
  d: '\u001b[34m[D]', // blue
  i: '\u001b[32m[I]', // green
  w: '\u001b[33m[W]', // yellow
  e: '\u001b[31m[E]' // red
};

/**
 * display colorful log. now, not support browser.
 *
 * format:
 * ``[LogLevel] [Time] [File] log text``
 *
 * format with tag:
 * ``[LogLevel] [Time] [File] [Tag] log text``
 *
 * log level and color:
 * - verbose: purple
 * - debug: blue
 * - info: green
 * - warning: yellow
 * - error: red
 *
 * @example
 * import Logger from 'color-logger'
 *
 * // simple usage
 * Logger.v('verbose log');
 *
 * // tag usage
 * let logger = new Logger('MyTag');
 * logger.d('debug log');
 */

var ColorLogger = (function () {

  /**
   * create instance.
   * @param {string} tag - tag text.
   */

  function ColorLogger(tag) {
    _classCallCheck(this, ColorLogger);

    this._tag = tag;
  }

  _createClass(ColorLogger, [{
    key: 'v',

    /**
     * display verbose(purple) log and tag.
     * @param {...*} msg - log message.
     * @returns {string} formatted log message.
     */
    value: function v() {
      var _constructor;

      for (var _len = arguments.length, msg = Array(_len), _key = 0; _key < _len; _key++) {
        msg[_key] = arguments[_key];
      }

      return (_constructor = this.constructor)._output.apply(_constructor, ['v', '[' + this._tag + ']'].concat(msg));
    }
  }, {
    key: 'd',

    /**
     * display debug(blue) log and tag.
     * @param {...*} msg - log message.
     * @returns {string} formatted log message.
     */
    value: function d() {
      var _constructor2;

      for (var _len2 = arguments.length, msg = Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
        msg[_key2] = arguments[_key2];
      }

      return (_constructor2 = this.constructor)._output.apply(_constructor2, ['d', '[' + this._tag + ']'].concat(msg));
    }
  }, {
    key: 'i',

    /**
     * display info(green) log and tag.
     * @param {...*} msg - log message.
     * @returns {string} formatted log message.
     */
    value: function i() {
      var _constructor3;

      for (var _len3 = arguments.length, msg = Array(_len3), _key3 = 0; _key3 < _len3; _key3++) {
        msg[_key3] = arguments[_key3];
      }

      return (_constructor3 = this.constructor)._output.apply(_constructor3, ['i', '[' + this._tag + ']'].concat(msg));
    }
  }, {
    key: 'w',

    /**
     * display warning(yellow) log and tag.
     * @param {...*} msg - log message.
     * @returns {string} formatted log message.
     */
    value: function w() {
      var _constructor4;

      for (var _len4 = arguments.length, msg = Array(_len4), _key4 = 0; _key4 < _len4; _key4++) {
        msg[_key4] = arguments[_key4];
      }

      return (_constructor4 = this.constructor)._output.apply(_constructor4, ['w', '[' + this._tag + ']'].concat(msg));
    }
  }, {
    key: 'e',

    /**
     * display error(red) log and tag.
     * @param {...*} msg - log message.
     * @returns {string} formatted log message.
     */
    value: function e() {
      var _constructor5;

      for (var _len5 = arguments.length, msg = Array(_len5), _key5 = 0; _key5 < _len5; _key5++) {
        msg[_key5] = arguments[_key5];
      }

      return (_constructor5 = this.constructor)._output.apply(_constructor5, ['e', '[' + this._tag + ']'].concat(msg));
    }
  }], [{
    key: '_getInfo',

    /**
     * log information.
     * @return {string} - file name and line number.
     * @private
     */
    value: function _getInfo() {
      var info = undefined;
      try {
        throw new Error();
      } catch (e) {
        var lines = e.stack.split('\n');
        var line = lines[4];
        var matched = line.match(/\/([^/]*?:\d+:\d+)/);
        info = matched[1];
      }

      return info;
    }
  }, {
    key: 'debug',

    /**
     * if false, not display log. default is true.
     */
    set: function (v) {
      this._debug = v;
    }
  }, {
    key: '_output',

    /**
     * display log.
     * @param {string} level - log level. v, d, i, w, e.
     * @param {...*} msg - log message.
     * @returns {string} - formatted log message.
     * @private
     */
    value: function _output(level) {
      for (var _len6 = arguments.length, msg = Array(_len6 > 1 ? _len6 - 1 : 0), _key6 = 1; _key6 < _len6; _key6++) {
        msg[_key6 - 1] = arguments[_key6];
      }

      if (!this._debug) {
        return '';
      }var text = [];
      var _iteratorNormalCompletion = true;
      var _didIteratorError = false;
      var _iteratorError = undefined;

      try {
        for (var _iterator = msg[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
          var m = _step.value;

          if (typeof m === 'object') {
            text.push(JSON.stringify(m, null, 2));
          } else {
            text.push(m);
          }
        }
      } catch (err) {
        _didIteratorError = true;
        _iteratorError = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion && _iterator['return']) {
            _iterator['return']();
          }
        } finally {
          if (_didIteratorError) {
            throw _iteratorError;
          }
        }
      }

      var color = levelToColor[level];
      var info = this._getInfo();
      var d = new Date();
      var now = '' + d.getHours() + ':' + d.getMinutes() + ':' + d.getSeconds() + '.' + d.getMilliseconds();
      var log = '' + color + ' [' + now + '] [' + info + '] ' + text.join(' ') + '\u001b[0m';
      console.log(log);
      return log;
    }
  }, {
    key: 'v',

    /**
     * display verbose(purple) log.
     * @param {...*} msg - log message.
     * @returns {string} formatted log message.
     */
    value: function v() {
      for (var _len7 = arguments.length, msg = Array(_len7), _key7 = 0; _key7 < _len7; _key7++) {
        msg[_key7] = arguments[_key7];
      }

      return this._output.apply(this, ['v'].concat(msg));
    }
  }, {
    key: 'd',

    /**
     * display debug(blue) log.
     * @param {...*} msg - log message.
     * @returns {string} formatted log message.
     */
    value: function d() {
      for (var _len8 = arguments.length, msg = Array(_len8), _key8 = 0; _key8 < _len8; _key8++) {
        msg[_key8] = arguments[_key8];
      }

      return this._output.apply(this, ['d'].concat(msg));
    }
  }, {
    key: 'i',

    /**
     * display info(green) log.
     * @param {...*} msg - log message.
     * @returns {string} formatted log message.
     */
    value: function i() {
      for (var _len9 = arguments.length, msg = Array(_len9), _key9 = 0; _key9 < _len9; _key9++) {
        msg[_key9] = arguments[_key9];
      }

      return this._output.apply(this, ['i'].concat(msg));
    }
  }, {
    key: 'w',

    /**
     * display warning(yellow) log.
     * @param {...*} msg - log message.
     * @returns {string} formatted log message.
     */
    value: function w() {
      for (var _len10 = arguments.length, msg = Array(_len10), _key10 = 0; _key10 < _len10; _key10++) {
        msg[_key10] = arguments[_key10];
      }

      return this._output.apply(this, ['w'].concat(msg));
    }
  }, {
    key: 'e',

    /**
     * display warning(red) log.
     * @param {...*} msg - log message.
     * @returns {string} formatted log message.
     */
    value: function e() {
      for (var _len11 = arguments.length, msg = Array(_len11), _key11 = 0; _key11 < _len11; _key11++) {
        msg[_key11] = arguments[_key11];
      }

      return this._output.apply(this, ['e'].concat(msg));
    }
  }]);

  return ColorLogger;
})();

exports['default'] = ColorLogger;

ColorLogger.debug = true;
module.exports = exports['default'];