/**
 * workerpool.js
 * https://github.com/josdejong/workerpool
 *
 * Offload tasks to a pool of workers on node.js and in the browser.
 *
 * @version 6.0.0
 * @date    2020-05-13
 *
 * @license
 * Copyright (C) 2014-2020 Jos de Jong <wjosdejong@gmail.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
!function(e,r){"object"==typeof exports&&"object"==typeof module?module.exports=r():"function"==typeof define&&define.amd?define("workerpool",[],r):"object"==typeof exports?exports.workerpool=r():e.workerpool=r()}("undefined"!=typeof self?self:this,(function(){return function(e){var r={};function t(o){if(r[o])return r[o].exports;var n=r[o]={i:o,l:!1,exports:{}};return e[o].call(n.exports,n,n.exports,t),n.l=!0,n.exports}return t.m=e,t.c=r,t.d=function(e,r,o){t.o(e,r)||Object.defineProperty(e,r,{enumerable:!0,get:o})},t.r=function(e){"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(e,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(e,"__esModule",{value:!0})},t.t=function(e,r){if(1&r&&(e=t(e)),8&r)return e;if(4&r&&"object"==typeof e&&e&&e.__esModule)return e;var o=Object.create(null);if(t.r(o),Object.defineProperty(o,"default",{enumerable:!0,value:e}),2&r&&"string"!=typeof e)for(var n in e)t.d(o,n,function(r){return e[r]}.bind(null,n));return o},t.n=function(e){var r=e&&e.__esModule?function(){return e.default}:function(){return e};return t.d(r,"a",r),r},t.o=function(e,r){return Object.prototype.hasOwnProperty.call(e,r)},t.p="",t(t.s=3)}([function(e,r,t){var o=t(2),n=function(e){return void 0!==e&&null!=e.versions&&null!=e.versions.node};e.exports.isNode=n,e.exports.platform="undefined"!=typeof process&&n(process)?"node":"browser";var i=function(e){try{return o(e)}catch(e){return null}}("worker_threads");e.exports.isMainThread="node"===e.exports.platform?(!i||i.isMainThread)&&!process.connected:"undefined"!=typeof Window,e.exports.cpus="browser"===e.exports.platform?self.navigator.hardwareConcurrency:o("os").cpus().length},function(e,r,t){"use strict";function o(e,r){var t=this;if(!(this instanceof o))throw new SyntaxError("Constructor must be called with the new operator");if("function"!=typeof e)throw new SyntaxError("Function parameter handler(resolve, reject) missing");var u=[],a=[];this.resolved=!1,this.rejected=!1,this.pending=!0;var c=function(e,r){u.push(e),a.push(r)};this.then=function(e,r){return new o((function(t,o){var i=e?n(e,t,o):t,s=r?n(r,t,o):o;c(i,s)}),t)};var f=function(e){return t.resolved=!0,t.rejected=!1,t.pending=!1,u.forEach((function(r){r(e)})),c=function(r,t){r(e)},f=p=function(){},t},p=function(e){return t.resolved=!1,t.rejected=!0,t.pending=!1,a.forEach((function(r){r(e)})),c=function(r,t){t(e)},f=p=function(){},t};this.cancel=function(){return r?r.cancel():p(new i),t},this.timeout=function(e){if(r)r.timeout(e);else{var o=setTimeout((function(){p(new s("Promise timed out after "+e+" ms"))}),e);t.always((function(){clearTimeout(o)}))}return t},e((function(e){f(e)}),(function(e){p(e)}))}function n(e,r,t){return function(o){try{var n=e(o);n&&"function"==typeof n.then&&"function"==typeof n.catch?n.then(r,t):r(n)}catch(e){t(e)}}}function i(e){this.message=e||"promise cancelled",this.stack=(new Error).stack}function s(e){this.message=e||"timeout exceeded",this.stack=(new Error).stack}o.prototype.catch=function(e){return this.then(null,e)},o.prototype.always=function(e){return this.then(e,e)},o.all=function(e){return new o((function(r,t){var o=e.length,n=[];o?e.forEach((function(e,i){e.then((function(e){n[i]=e,0==--o&&r(n)}),(function(e){o=0,t(e)}))})):r(n)}))},o.defer=function(){var e={};return e.promise=new o((function(r,t){e.resolve=r,e.reject=t})),e},i.prototype=new Error,i.prototype.constructor=Error,i.prototype.name="CancellationError",o.CancellationError=i,s.prototype=new Error,s.prototype.constructor=Error,s.prototype.name="TimeoutError",o.TimeoutError=s,e.exports=o},function(module,exports){var requireFoolWebpack=eval("typeof require !== 'undefined' ? require : function (module) { throw new Error('Module \" + module + \" not found.') }");module.exports=requireFoolWebpack},function(e,r,t){var o=t(0);r.pool=function(e,r){return new(t(4))(e,r)},r.worker=function(e){var r=t(8);r.add(e)},r.Promise=t(1),r.platform=o.platform,r.isMainThread=o.isMainThread,r.cpus=o.cpus},function(e,r,t){var o=t(1),n=t(5),i=t(0),s=new(t(7));function u(e,r){"string"==typeof e?this.script=e||null:(this.script=null,r=e),this.workers=[],this.tasks=[],r=r||{},this.forkArgs=r.forkArgs||[],this.forkOpts=r.forkOpts||{},this.debugPortStart=r.debugPortStart||43210,this.nodeWorker=r.nodeWorker,this.workerType=r.workerType||r.nodeWorker||"auto",this.maxQueueSize=r.maxQueueSize||1/0,r&&"maxWorkers"in r?(!function(e){if(!a(e)||!c(e)||e<1)throw new TypeError("Option maxWorkers must be an integer number >= 1")}(r.maxWorkers),this.maxWorkers=r.maxWorkers):this.maxWorkers=Math.max((i.cpus||4)-1,1),r&&"minWorkers"in r&&("max"===r.minWorkers?this.minWorkers=this.maxWorkers:(!function(e){if(!a(e)||!c(e)||e<0)throw new TypeError("Option minWorkers must be an integer number >= 0")}(r.minWorkers),this.minWorkers=r.minWorkers,this.maxWorkers=Math.max(this.minWorkers,this.maxWorkers)),this._ensureMinWorkers()),this._boundNext=this._next.bind(this),"thread"===this.workerType&&n.ensureWorkerThreads()}function a(e){return"number"==typeof e}function c(e){return Math.round(e)==e}u.prototype.exec=function(e,r){if(r&&!Array.isArray(r))throw new TypeError('Array expected as argument "params"');if("string"==typeof e){var t=o.defer();if(this.tasks.length>=this.maxQueueSize)throw new Error("Max queue size of "+this.maxQueueSize+" reached");var n=this.tasks,i={method:e,params:r,resolver:t,timeout:null};n.push(i);var s=t.promise.timeout;return t.promise.timeout=function(e){return-1!==n.indexOf(i)?(i.timeout=e,t.promise):s.call(t.promise,e)},this._next(),t.promise}if("function"==typeof e)return this.exec("run",[String(e),r]);throw new TypeError('Function or string expected as argument "method"')},u.prototype.proxy=function(){if(arguments.length>0)throw new Error("No arguments expected");var e=this;return this.exec("methods").then((function(r){var t={};return r.forEach((function(r){t[r]=function(){return e.exec(r,Array.prototype.slice.call(arguments))}})),t}))},u.prototype._next=function(){if(this.tasks.length>0){var e=this._getWorker();if(e){var r=this,t=this.tasks.shift();if(t.resolver.promise.pending){var o=e.exec(t.method,t.params,t.resolver).then(r._boundNext).catch((function(){e.terminated&&(r._removeWorker(e),r._ensureMinWorkers()),r._next()}));"number"==typeof t.timeout&&o.timeout(t.timeout)}else r._next()}}},u.prototype._getWorker=function(){for(var e=this.workers,r=0;r<e.length;r++){var t=e[r];if(!1===t.busy())return t}return e.length<this.maxWorkers?(t=this._createWorkerHandler(),e.push(t),t):null},u.prototype._removeWorker=function(e){s.releasePort(e.debugPort),e.terminate(),this._removeWorkerFromList(e)},u.prototype._removeWorkerFromList=function(e){var r=this.workers.indexOf(e);-1!==r&&this.workers.splice(r,1)},u.prototype.terminate=function(e,r){this.tasks.forEach((function(e){e.resolver.reject(new Error("Pool terminated"))})),this.tasks.length=0;var t=function(e){this._removeWorkerFromList(e)}.bind(this),n=[];return this.workers.slice().forEach((function(o){var i=o.terminateAndNotify(e,r).then(t);n.push(i)})),o.all(n)},u.prototype.stats=function(){var e=this.workers.length,r=this.workers.filter((function(e){return e.busy()})).length;return{totalWorkers:e,busyWorkers:r,idleWorkers:e-r,pendingTasks:this.tasks.length,activeTasks:r}},u.prototype._ensureMinWorkers=function(){if(this.minWorkers)for(var e=this.workers.length;e<this.minWorkers;e++)this.workers.push(this._createWorkerHandler())},u.prototype._createWorkerHandler=function(){return new n(this.script,{forkArgs:this.forkArgs,forkOpts:this.forkOpts,debugPort:s.nextAvailableStartingAt(this.debugPortStart),workerType:this.workerType})},e.exports=u},function(e,r,t){"use strict";var o=t(1),n=t(0),i=t(2);function s(){var e=a();if(!e)throw new Error("WorkerPool: workerType = 'thread' is not supported, Node >= 11.7.0 required");return e}function u(){if("function"!=typeof Worker&&("object"!=typeof Worker||"function"!=typeof Worker.prototype.constructor))throw new Error("WorkerPool: Web Workers not supported")}function a(){try{return i("worker_threads")}catch(e){if("object"==typeof e&&null!==e&&"MODULE_NOT_FOUND"===e.code)return null;throw e}}function c(e,r){var t=new r(e);return t.isBrowserWorker=!0,t.on=function(e,r){this.addEventListener(e,(function(e){r(e.data)}))},t.send=function(e){this.postMessage(e)},t}function f(e,r){var t=new r.Worker(e,{stdout:!1,stderr:!1});return t.isWorkerThread=!0,t.send=function(e){this.postMessage(e)},t.kill=function(){this.terminate()},t.disconnect=function(){this.terminate()},t}function p(e,r,t){var o=t.fork(e,r.forkArgs,r.forkOpts);return o.isChildProcess=!0,o}function d(e){e=e||{};var r=process.execArgv.join(" "),t=-1!==r.indexOf("--inspect"),o=-1!==r.indexOf("--debug-brk"),n=[];return t&&(n.push("--inspect="+e.debugPort),o&&n.push("--debug-brk")),process.execArgv.forEach((function(e){e.indexOf("--max-old-space-size")>-1&&n.push(e)})),Object.assign({},e,{forkArgs:e.forkArgs,forkOpts:Object.assign({},e.forkOpts,{execArgv:(e.forkOpts&&e.forkOpts.execArgv||[]).concat(n)})})}function h(e,r){var o=this,h=r||{};function l(e){for(var r in o.terminated=!0,o.terminating&&o.terminationHandler&&o.terminationHandler(o),o.terminating=!1,o.processing)void 0!==o.processing[r]&&o.processing[r].resolver.reject(e);o.processing=Object.create(null)}this.script=e||function(){if("browser"===n.platform){if("undefined"==typeof Blob)throw new Error("Blob not supported by the browser");if(!window.URL||"function"!=typeof window.URL.createObjectURL)throw new Error("URL.createObjectURL not supported by the browser");var e=new Blob([t(6)],{type:"text/javascript"});return window.URL.createObjectURL(e)}return __dirname+"/worker.js"}(),this.worker=function(e,r){if("web"===r.workerType)return u(),c(e,Worker);if("thread"===r.workerType)return f(e,t=s());if("process"!==r.workerType&&r.workerType){if("browser"===n.platform)return u(),c(e,Worker);var t=a();return t?f(e,t):p(e,d(r),i("child_process"))}return p(e,d(r),i("child_process"))}(this.script,h),this.debugPort=h.debugPort,e||(this.worker.ready=!0),this.requestQueue=[],this.worker.on("message",(function(e){if("string"==typeof e&&"ready"===e)o.worker.ready=!0,o.requestQueue.forEach(o.worker.send.bind(o.worker)),o.requestQueue=[];else{var r=e.id,t=o.processing[r];void 0!==t&&(delete o.processing[r],!0===o.terminating&&o.terminate(),e.error?t.resolver.reject(function(e){for(var r=new Error(""),t=Object.keys(e),o=0;o<t.length;o++)r[t[o]]=e[t[o]];return r}(e.error)):t.resolver.resolve(e.result))}}));var k=this.worker;this.worker.on("error",l),this.worker.on("exit",(function(e,r){var t="Workerpool Worker terminated Unexpectedly\n";t+="    exitCode: `"+e+"`\n",t+="    signalCode: `"+r+"`\n",t+="    workerpool.script: `"+o.script+"`\n",t+="    spawnArgs: `"+k.spawnargs+"`\n",t+="    spawnfile: `"+k.spawnfile+"`\n",t+="    stdout: `"+k.stdout+"`\n",t+="    stderr: `"+k.stderr+"`\n",l(new Error(t))})),this.processing=Object.create(null),this.terminating=!1,this.terminated=!1,this.terminationHandler=null,this.lastId=0}h.prototype.methods=function(){return this.exec("methods")},h.prototype.exec=function(e,r,t){t||(t=o.defer());var n=++this.lastId;this.processing[n]={id:n,resolver:t};var i={id:n,method:e,params:r};this.terminated?t.reject(new Error("Worker is terminated")):this.worker.ready?this.worker.send(i):this.requestQueue.push(i);var s=this;return t.promise.catch((function(e){if(!(e instanceof o.CancellationError||e instanceof o.TimeoutError))throw e;delete s.processing[n],s.terminate(!0)})),t.promise},h.prototype.busy=function(){return Object.keys(this.processing).length>0},h.prototype.terminate=function(e,r){if(e){for(var t in this.processing)void 0!==this.processing[t]&&this.processing[t].resolver.reject(new Error("Worker terminated"));this.processing=Object.create(null)}if("function"==typeof r&&(this.terminationHandler=r),this.busy())this.terminating=!0;else{if(this.worker){if("function"==typeof this.worker.kill)this.worker.kill();else{if("function"!=typeof this.worker.terminate)throw new Error("Failed to terminate worker");this.worker.terminate()}this.worker=null}this.terminating=!1,this.terminated=!0,this.terminationHandler&&this.terminationHandler(this)}},h.prototype.terminateAndNotify=function(e,r){var t=o.defer();return r&&(t.promise.timeout=r),this.terminate(e,(function(e){t.resolve(e)})),t.promise},e.exports=h,e.exports._tryRequireWorkerThreads=a,e.exports._setupProcessWorker=p,e.exports._setupBrowserWorker=c,e.exports._setupWorkerThreadWorker=f,e.exports.ensureWorkerThreads=s},function(e,r){e.exports='!function(o){var n={};function t(e){if(n[e])return n[e].exports;var r=n[e]={i:e,l:!1,exports:{}};return o[e].call(r.exports,r,r.exports,t),r.l=!0,r.exports}t.m=o,t.c=n,t.d=function(e,r,o){t.o(e,r)||Object.defineProperty(e,r,{enumerable:!0,get:o})},t.r=function(e){"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(e,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(e,"__esModule",{value:!0})},t.t=function(r,e){if(1&e&&(r=t(r)),8&e)return r;if(4&e&&"object"==typeof r&&r&&r.__esModule)return r;var o=Object.create(null);if(t.r(o),Object.defineProperty(o,"default",{enumerable:!0,value:r}),2&e&&"string"!=typeof r)for(var n in r)t.d(o,n,function(e){return r[e]}.bind(null,n));return o},t.n=function(e){var r=e&&e.__esModule?function(){return e.default}:function(){return e};return t.d(r,"a",r),r},t.o=function(e,r){return Object.prototype.hasOwnProperty.call(e,r)},t.p="",t(t.s=0)}([function(module,exports,__webpack_require__){var requireFoolWebpack=eval("typeof require !== \'undefined\' ? require : function (module) { throw new Error(\'Module \\" + module + \\" not found.\') }"),worker={},WorkerThreads,parentPort;if("undefined"!=typeof self&&"function"==typeof postMessage&&"function"==typeof addEventListener)worker.on=function(e,r){addEventListener(e,function(e){r(e.data)})},worker.send=function(e){postMessage(e)};else{if("undefined"==typeof process)throw new Error("Script must be executed as a worker");try{WorkerThreads=requireFoolWebpack("worker_threads")}catch(e){if("object"!=typeof e||null===e||"MODULE_NOT_FOUND"!==e.code)throw e}WorkerThreads&&null!==WorkerThreads.parentPort?(parentPort=WorkerThreads.parentPort,worker.send=parentPort.postMessage.bind(parentPort),worker.on=parentPort.on.bind(parentPort)):(worker.on=process.on.bind(process),worker.send=process.send.bind(process),worker.on("disconnect",function(){process.exit(1)}))}function convertError(o){return Object.getOwnPropertyNames(o).reduce(function(e,r){return Object.defineProperty(e,r,{value:o[r],enumerable:!0})},{})}function isPromise(e){return e&&"function"==typeof e.then&&"function"==typeof e.catch}worker.methods={},worker.methods.run=function run(fn,args){var f=eval("("+fn+")");return f.apply(f,args)},worker.methods.methods=function(){return Object.keys(worker.methods)},worker.on("message",function(r){try{var e=worker.methods[r.method];if(!e)throw new Error(\'Unknown method "\'+r.method+\'"\');var o=e.apply(e,r.params);isPromise(o)?o.then(function(e){worker.send({id:r.id,result:e,error:null})}).catch(function(e){worker.send({id:r.id,result:null,error:convertError(e)})}):worker.send({id:r.id,result:o,error:null})}catch(e){worker.send({id:r.id,result:null,error:convertError(e)})}}),worker.register=function(e){if(e)for(var r in e)e.hasOwnProperty(r)&&(worker.methods[r]=e[r]);worker.send("ready")},exports.add=worker.register}]);'},function(e,r,t){"use strict";function o(){this.ports=Object.create(null),this.length=0}e.exports=o,o.prototype.nextAvailableStartingAt=function(e){for(;!0===this.ports[e];)e++;if(e>=65535)throw new Error("WorkerPool debug port limit reached: "+e+">= 65535");return this.ports[e]=!0,this.length++,e},o.prototype.releasePort=function(e){delete this.ports[e],this.length--}},function(module,exports,__webpack_require__){var requireFoolWebpack=eval("typeof require !== 'undefined' ? require : function (module) { throw new Error('Module \" + module + \" not found.') }"),worker={};if("undefined"!=typeof self&&"function"==typeof postMessage&&"function"==typeof addEventListener)worker.on=function(e,r){addEventListener(e,(function(e){r(e.data)}))},worker.send=function(e){postMessage(e)};else{if("undefined"==typeof process)throw new Error("Script must be executed as a worker");var WorkerThreads;try{WorkerThreads=requireFoolWebpack("worker_threads")}catch(e){if("object"!=typeof e||null===e||"MODULE_NOT_FOUND"!==e.code)throw e}if(WorkerThreads&&null!==WorkerThreads.parentPort){var parentPort=WorkerThreads.parentPort;worker.send=parentPort.postMessage.bind(parentPort),worker.on=parentPort.on.bind(parentPort)}else worker.on=process.on.bind(process),worker.send=process.send.bind(process),worker.on("disconnect",(function(){process.exit(1)}))}function convertError(e){return Object.getOwnPropertyNames(e).reduce((function(r,t){return Object.defineProperty(r,t,{value:e[t],enumerable:!0})}),{})}function isPromise(e){return e&&"function"==typeof e.then&&"function"==typeof e.catch}worker.methods={},worker.methods.run=function run(fn,args){var f=eval("("+fn+")");return f.apply(f,args)},worker.methods.methods=function(){return Object.keys(worker.methods)},worker.on("message",(function(e){try{var r=worker.methods[e.method];if(!r)throw new Error('Unknown method "'+e.method+'"');var t=r.apply(r,e.params);isPromise(t)?t.then((function(r){worker.send({id:e.id,result:r,error:null})})).catch((function(r){worker.send({id:e.id,result:null,error:convertError(r)})})):worker.send({id:e.id,result:t,error:null})}catch(r){worker.send({id:e.id,result:null,error:convertError(r)})}})),worker.register=function(e){if(e)for(var r in e)e.hasOwnProperty(r)&&(worker.methods[r]=e[r]);worker.send("ready")},exports.add=worker.register}])}));
//# sourceMappingURL=workerpool.min.js.map