/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.metadata.web;

import java.io.IOException;
import java.security.AccessControlException;
import java.util.HashMap;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Session;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.app.ThreadLocalSessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.wcm.core.WCMConfigurationService;
import org.exoplatform.services.wcm.metadata.PageMetadataService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageMetadataRequestFilter
implements Filter {
    public static final String PCV_PARAMETER_REGX = "(.*)/(.*)/(.*)";

    public void init(FilterConfig config) throws ServletException {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)servletRequest;
        try {
            boolean check = this.checkAndSetMetadataIfRequestToPCVPortlet(req);
            if (!check) {
                this.setPortalMetadata(req);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        chain.doFilter(servletRequest, servletResponse);
    }

    private void setPortalMetadata(HttpServletRequest req) throws Exception {
        ThreadLocalSessionProviderService localSessionProviderService;
        String pathInfo = req.getPathInfo();
        PageMetadataService metadataRegistry = this.getService(PageMetadataService.class);
        HashMap<String, String> metadata = metadataRegistry.getPortalMetadata(pathInfo, (localSessionProviderService = this.getService(ThreadLocalSessionProviderService.class)).getSessionProvider(null));
        if (metadata != null) {
            req.setAttribute(PortalRequestContext.REQUEST_METADATA, metadata);
        }
    }

    private boolean checkAndSetMetadataIfRequestToPCVPortlet(HttpServletRequest req) throws Exception {
        String pathInfo = req.getPathInfo();
        if (pathInfo == null) {
            return false;
        }
        WCMConfigurationService configurationService = this.getService(WCMConfigurationService.class);
        String parameterizedPageURI = configurationService.getParameterizedPageURI();
        int index = pathInfo.indexOf(parameterizedPageURI);
        if (index < 1) {
            return false;
        }
        String parameter = pathInfo.substring(index);
        if (!parameter.matches(PCV_PARAMETER_REGX)) {
            return false;
        }
        String repository = parameter.split("/", 4)[2];
        String workspace = parameter.split("/", 5)[3];
        String nodeIdentifier = "/" + parameter.split("/", 5)[4];
        RepositoryService repositoryService = this.getService(RepositoryService.class);
        ThreadLocalSessionProviderService localSessionProviderService = this.getService(ThreadLocalSessionProviderService.class);
        SessionProvider sessionProvider = localSessionProviderService.getSessionProvider(null);
        Node node = null;
        Session session = null;
        try {
            session = sessionProvider.getSession(workspace, repositoryService.getRepository(repository));
            node = session.getNodeByUUID(nodeIdentifier);
        }
        catch (ItemNotFoundException e) {
            node = (Node)session.getItem(nodeIdentifier);
        }
        catch (PathNotFoundException e) {
            req.setAttribute("ParameterizedContentViewerPortlet.data.object", (Object)new ItemNotFoundException());
        }
        catch (AccessControlException e) {
            req.setAttribute("ParameterizedContentViewerPortlet.data.object", (Object)e);
        }
        catch (Exception e) {
            req.setAttribute("ParameterizedContentViewerPortlet.data.object", (Object)new ItemNotFoundException());
        }
        if (node != null) {
            req.setAttribute("ParameterizedContentViewerPortlet.data.object", (Object)node);
            PageMetadataService pageMetadataService = this.getService(PageMetadataService.class);
            HashMap<String, String> pageMetadata = pageMetadataService.extractMetadata(node);
            String title = (String)pageMetadata.get("pageTitle");
            if (title != null) {
                req.setAttribute(PortalRequestContext.REQUEST_TITLE, (Object)title);
            }
            req.setAttribute(PortalRequestContext.REQUEST_METADATA, pageMetadata);
            if (node.hasProperty("exo:title")) {
                req.setAttribute("WCM.Content.Title", (Object)node.getProperty("exo:title").getValue().getString());
            }
            req.setAttribute("WCM.Content.Title", (Object)node.getName());
            return true;
        }
        return false;
    }

    private <T> T getService(Class<T> clazz) {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        return clazz.cast(container.getComponentInstanceOfType(clazz));
    }

    public void destroy() {
    }
}

