/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.publication.defaultlifecycle;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.portal.application.PortletPreferences;
import org.exoplatform.portal.application.Preference;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.model.Application;
import org.exoplatform.portal.config.model.Container;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.PageNavigation;
import org.exoplatform.portal.config.model.PageNode;
import org.exoplatform.portal.webui.util.SessionProviderFactory;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.portletcontainer.pci.ExoWindowID;
import org.exoplatform.services.portletcontainer.pci.WindowID;
import org.exoplatform.services.wcm.core.WCMConfigurationService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Util {
    public static final String HISTORY_SEPARATOR = "; ";
    public static final String APPLICATION_SEPARATOR = "@";
    public static final String URI_SEPARATOR = "/";

    public static List<PageNode> findPageNodeByPageId(PageNavigation nav, String pageId) throws Exception {
        ArrayList<PageNode> list = new ArrayList<PageNode>();
        if (nav.getOwnerType().equals("portal")) {
            for (PageNode node : nav.getNodes()) {
                Util.findPageNodeByPageId(node, pageId, list);
            }
        }
        return list;
    }

    public static void findPageNodeByPageId(PageNode node, String pageId, List<PageNode> allPageNode) throws Exception {
        List children;
        if (pageId.equals(node.getPageReference())) {
            allPageNode.add(node.clone());
        }
        if ((children = node.getChildren()) == null) {
            return;
        }
        for (PageNode child : children) {
            Util.findPageNodeByPageId(child, pageId, allPageNode);
        }
    }

    public static List<String> findAppInstancesByName(Page page, String applicationName) {
        ArrayList<String> results = new ArrayList<String>();
        Util.findAppInstancesByContainerAndName((Container)page, applicationName, results);
        return results;
    }

    private static void findAppInstancesByContainerAndName(Container container, String applicationName, List<String> results) {
        ArrayList chidren = container.getChildren();
        if (chidren == null) {
            return;
        }
        for (Object object : chidren) {
            if (object instanceof Application) {
                Application application = (Application)Application.class.cast(object);
                if (!application.getInstanceId().contains(applicationName)) continue;
                results.add(application.getInstanceId());
                continue;
            }
            if (!(object instanceof Container)) continue;
            Container child = (Container)Container.class.cast(object);
            Util.findAppInstancesByContainerAndName(child, applicationName, results);
        }
    }

    private static void removedAppInstancesInContainerByNames(Container container, List<String> removingApplicationIds) {
        ArrayList chidren = container.getChildren();
        ArrayList chidrenTmp = new ArrayList();
        if (chidren == null) {
            return;
        }
        for (Object object : chidren) {
            if (object instanceof Application) {
                Application application = (Application)Application.class.cast(object);
                if (removingApplicationIds.contains(application.getInstanceId())) continue;
                chidrenTmp.add(object);
                continue;
            }
            if (!(object instanceof Container)) continue;
            Container child = (Container)Container.class.cast(object);
            Util.removedAppInstancesInContainerByNames(child, removingApplicationIds);
        }
        container.setChildren(chidrenTmp);
    }

    public static List<String> getValuesAsString(Node node, String propName) throws Exception {
        if (!node.hasProperty(propName)) {
            return new ArrayList<String>();
        }
        ArrayList<String> results = new ArrayList<String>();
        for (Value value : node.getProperty(propName).getValues()) {
            results.add(value.getString());
        }
        return results;
    }

    public static Value[] toValues(ValueFactory factory, List<String> values) {
        ArrayList<Value> list = new ArrayList<Value>();
        for (String value : values) {
            list.add(factory.createValue(value));
        }
        return list.toArray(new Value[list.size()]);
    }

    public static Node getNodeByApplicationId(String applicationId) throws Exception {
        SessionProvider sessionProvider = SessionProviderFactory.createSessionProvider();
        DataStorage dataStorage = Util.getServices(DataStorage.class);
        RepositoryService repositoryService = Util.getServices(RepositoryService.class);
        PortletPreferences portletPreferences = dataStorage.getPortletPreferences((WindowID)new ExoWindowID(applicationId));
        if (portletPreferences == null) {
            return null;
        }
        String repositoryName = null;
        String workspaceName = null;
        String nodeIdentifier = null;
        for (Object object : portletPreferences.getPreferences()) {
            Preference preference = (Preference)object;
            if (preference.getName().equals("repository")) {
                repositoryName = preference.getValues().get(0).toString();
                continue;
            }
            if (preference.getName().equals("workspace")) {
                workspaceName = preference.getValues().get(0).toString();
                continue;
            }
            if (!preference.getName().equals("nodeIdentifier")) continue;
            nodeIdentifier = preference.getValues().get(0).toString();
        }
        if (repositoryName != null && workspaceName != null && nodeIdentifier != null) {
            Session session = sessionProvider.getSession(workspaceName, repositoryService.getRepository(repositoryName));
            Node content = null;
            try {
                content = session.getNodeByUUID(nodeIdentifier);
            }
            catch (ItemNotFoundException e) {
                content = (Node)session.getItem(nodeIdentifier);
            }
            return content;
        }
        return null;
    }

    public static void removeApplicationFromPage(Page page, List<String> removedApplicationIds) {
        Util.removedAppInstancesInContainerByNames((Container)page, removedApplicationIds);
    }

    public static List<String> getListApplicationIdByPage(Page page) {
        WCMConfigurationService configurationService = Util.getServices(WCMConfigurationService.class);
        return Util.findAppInstancesByName(page, configurationService.getPublishingPortletName());
    }

    public static String setMixedNavigationUri(String portalName, String pageNodeUri) {
        return URI_SEPARATOR + portalName + URI_SEPARATOR + pageNodeUri;
    }

    public static String[] parseMixedNavigationUri(String mixedNavigationUri) {
        String[] mixedNavigationUris = new String[2];
        int first = 1;
        int second = mixedNavigationUri.indexOf(URI_SEPARATOR, first);
        mixedNavigationUris[0] = mixedNavigationUri.substring(first, second);
        mixedNavigationUris[1] = mixedNavigationUri.substring(second + URI_SEPARATOR.length(), mixedNavigationUri.length());
        return mixedNavigationUris;
    }

    public static String setMixedApplicationId(String pageId, String applicationId) {
        return pageId + APPLICATION_SEPARATOR + applicationId;
    }

    public static String[] parseMixedApplicationId(String mixedApplicationId) {
        return mixedApplicationId.split(APPLICATION_SEPARATOR);
    }

    public static <T> T getServices(Class<T> clazz) {
        ExoContainer exoContainer = ExoContainerContext.getCurrentContainer();
        return clazz.cast(exoContainer.getComponentInstanceOfType(clazz));
    }
}

