/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.javascript;

import java.util.concurrent.CopyOnWriteArrayList;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Repository;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.servlet.ServletContext;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.exoplatform.services.deployment.ContentInitializerService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.services.wcm.core.WCMConfigurationService;
import org.exoplatform.web.application.javascript.JavascriptConfigService;
import org.picocontainer.Startable;

public class XJavascriptService
implements Startable {
    private static String SHARED_JS_QUERY = "select * from exo:jsFile where jcr:path like '{path}' and exo:active='true' and exo:sharedJS='true' order by exo:priority DESC ";
    private final String MODULE_NAME = "eXo.WCM.Live".intern();
    private final String PATH = "/javascript/eXo/wcm/live".intern();
    private RepositoryService repositoryService;
    private JavascriptConfigService jsConfigService;
    private WCMConfigurationService configurationService;
    private ServletContext sContext;
    private CopyOnWriteArrayList<String> javascriptMimeTypes = new CopyOnWriteArrayList();
    private Log log = ExoLogger.getLogger((String)"wcm:XJavascriptService");

    public XJavascriptService(RepositoryService repositoryService, JavascriptConfigService jsConfigService, ServletContext servletContext, WCMConfigurationService configurationService, ContentInitializerService contentInitializerService) {
        this.repositoryService = repositoryService;
        this.jsConfigService = jsConfigService;
        this.sContext = servletContext;
        this.configurationService = configurationService;
        this.javascriptMimeTypes.addIfAbsent("text/javascript");
        this.javascriptMimeTypes.addIfAbsent("application/x-javascript");
        this.javascriptMimeTypes.addIfAbsent("text/ecmascript");
    }

    public String getActiveJavaScript(Node home) throws Exception {
        String jsQuery = "select * from exo:jsFile where jcr:path like '" + home.getPath() + "/%' and exo:active='true'order by exo:priority DESC ";
        return this.getJSDataBySQLQuery(home.getSession(), jsQuery, null);
    }

    public void updatePortalJSOnModify(Node jsFile, SessionProvider sessionProvider) throws Exception {
        String javascript = this.getJavascriptOfAllPortals(sessionProvider, jsFile.getPath());
        String modifiedJS = jsFile.getNode("jcr:content").getProperty("jcr:data").getString();
        javascript = javascript.concat(modifiedJS);
        this.addJavascript(javascript);
    }

    public void updatePortalJSOnRemove(Node jsFile, SessionProvider sessionProvider) throws Exception {
        String javascript = this.getJavascriptOfAllPortals(sessionProvider, jsFile.getPath());
        this.addJavascript(javascript);
    }

    private void addJavascript(String jsData) {
        if (this.jsConfigService.isModuleLoaded((CharSequence)this.MODULE_NAME)) {
            this.jsConfigService.removeExtendedJavascript(this.MODULE_NAME, this.PATH, this.sContext);
        }
        this.jsConfigService.addExtendedJavascript(this.MODULE_NAME, this.PATH, this.sContext, jsData);
    }

    private String getJavascriptOfAllPortals(SessionProvider sessionProvider, String exceptPath) throws Exception {
        ManageableRepository manageableRepository = this.repositoryService.getCurrentRepository();
        NodeLocation livePortalsLocation = this.configurationService.getLivePortalsLocation(manageableRepository.getConfiguration().getName());
        String statement = StringUtils.replaceOnce((String)SHARED_JS_QUERY, (String)"{path}", (String)livePortalsLocation.getPath());
        Session session = sessionProvider.getSession(livePortalsLocation.getWorkspace(), manageableRepository);
        return this.getJSDataBySQLQuery(session, statement, exceptPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getJSDataBySQLQuery(Session session, String queryStatement, String exceptPath) throws Exception {
        Session querySession = null;
        QueryManager queryManager = null;
        try {
            if (session.isLive()) {
                queryManager = session.getWorkspace().getQueryManager();
            } else {
                Repository repository = session.getRepository();
                querySession = repository.login(session.getWorkspace().getName());
                queryManager = querySession.getWorkspace().getQueryManager();
            }
            Query query = queryManager.createQuery(queryStatement, "sql");
            QueryResult queryResult = query.execute();
            StringBuffer buffer = new StringBuffer();
            NodeIterator iterator = queryResult.getNodes();
            while (iterator.hasNext()) {
                Node jsFile = iterator.nextNode();
                Node jcrContent = jsFile.getNode("jcr:content");
                String mimeType = jcrContent.getProperty("jcr:mimeType").getString();
                if (!this.javascriptMimeTypes.contains(mimeType) || jsFile.getPath().equalsIgnoreCase(exceptPath)) continue;
                buffer.append(jcrContent.getProperty("jcr:data").getString());
            }
            String string = buffer.toString();
            return string;
        }
        finally {
            if (querySession != null) {
                querySession.logout();
            }
        }
    }

    public void start() {
        this.log.info((Object)"Start WCM Javascript service...");
        SessionProvider sessionProvider = SessionProvider.createSystemProvider();
        try {
            String sharedJS = this.getJavascriptOfAllPortals(sessionProvider, null);
            if (sharedJS != null && sharedJS.length() != 0) {
                this.addJavascript(sharedJS);
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Error when start XJavaScriptService", (Throwable)e);
        }
        sessionProvider.close();
    }

    public void stop() {
    }
}

