/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.navigation;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.PageNavigation;
import org.exoplatform.portal.config.model.PageNode;
import org.exoplatform.ws.frameworks.json.impl.JsonGeneratorImpl;
import org.exoplatform.ws.frameworks.json.value.JsonValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NavigationService {
    private UserPortalConfigService portalConfigService;

    public NavigationService(UserPortalConfigService userPortalConfigService) {
        this.portalConfigService = userPortalConfigService;
    }

    public String getNavigationsAsJSON(List<PageNavigation> navigations, String userId) throws Exception {
        CopyOnWriteArrayList<PageNavigation> copyList = new CopyOnWriteArrayList<PageNavigation>();
        for (PageNavigation nav : navigations) {
            copyList.add(this.filter(nav, userId));
        }
        PortalNavigation portalNavigation = new PortalNavigation(copyList);
        JsonValue jsonValue = new JsonGeneratorImpl().createJsonObject((Object)portalNavigation);
        String JSONnavigation = jsonValue.toString();
        JSONnavigation = JSONnavigation.substring(1, JSONnavigation.length() - 1);
        JSONnavigation = JSONnavigation.replaceFirst("\"navigations\":", "");
        return JSONnavigation;
    }

    private PageNavigation filter(PageNavigation nav, String userName) throws Exception {
        PageNavigation filter = nav.clone();
        filter.setNodes(new ArrayList());
        for (PageNode node : nav.getNodes()) {
            PageNode newNode = this.filter(node, userName);
            if (newNode == null) continue;
            filter.addNode(newNode);
        }
        return filter;
    }

    private PageNode filter(PageNode node, String userName) throws Exception {
        if (!node.isDisplay()) {
            return null;
        }
        if (node.getPageReference() == null) {
            return null;
        }
        if (this.portalConfigService.getPage(node.getPageReference(), userName) == null) {
            return null;
        }
        PageNode copyNode = node.clone();
        copyNode.setChildren(new ArrayList());
        List children = node.getChildren();
        if (children == null || children.size() == 0) {
            return copyNode;
        }
        for (PageNode child : children) {
            PageNode newNode = this.filter(child, userName);
            if (newNode == null) continue;
            copyNode.getChildren().add(newNode);
        }
        if (copyNode.getChildren().size() == 0 && copyNode.getPageReference() == null) {
            return null;
        }
        return copyNode;
    }

    public String getNavigationsAsJSON(List<PageNavigation> navigations) throws Exception {
        PortalNavigation portalNavigation = new PortalNavigation(navigations);
        JsonValue jsonValue = new JsonGeneratorImpl().createJsonObject((Object)portalNavigation);
        String JSONnavigation = jsonValue.toString();
        JSONnavigation = JSONnavigation.substring(1, JSONnavigation.length() - 1);
        JSONnavigation = JSONnavigation.replaceFirst("\"navigations\":", "");
        return JSONnavigation;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PortalNavigation {
        private List<PageNavigation> navigations = new ArrayList<PageNavigation>();

        public PortalNavigation(List<PageNavigation> list) {
            this.navigations = list;
        }

        public List<PageNavigation> getNavigations() {
            return this.navigations;
        }

        public void setNavigations(List<PageNavigation> list) {
            this.navigations = list;
        }
    }
}

