/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.utils;

import java.util.Calendar;
import org.exoplatform.commons.utils.ISO8601;
import org.exoplatform.services.wcm.utils.AbstractQueryBuilder;

public class SQLQueryBuilder
extends AbstractQueryBuilder {
    public void isNull(String propertyName, AbstractQueryBuilder.LOGICAL condition) {
        if (condition == AbstractQueryBuilder.LOGICAL.AND) {
            this.propertiesClause.append(" AND").append(propertyName).append("IS NULL ");
        } else if (condition == AbstractQueryBuilder.LOGICAL.OR) {
            this.propertiesClause.append(" OR").append(propertyName).append("IS NULL ");
        } else {
            this.propertiesClause.append(propertyName).append("IS NULL ");
        }
    }

    public void isNotNull(String propertyName, AbstractQueryBuilder.LOGICAL condition) {
        if (condition == AbstractQueryBuilder.LOGICAL.AND) {
            this.propertiesClause.append("AND ").append(propertyName).append(" IS NOT NULL ");
        } else if (condition == AbstractQueryBuilder.LOGICAL.OR) {
            this.propertiesClause.append("OR ").append(propertyName).append(" IS NOT NULL ");
        } else {
            this.propertiesClause.append(propertyName).append(" IS NOT NULL ");
        }
    }

    public void lessThan(String propertyName, String value, AbstractQueryBuilder.LOGICAL condition) {
        this.comparison(propertyName, value, condition, "<");
    }

    public void greaterThan(String propName, String value, AbstractQueryBuilder.LOGICAL condition) {
        this.comparison(propName, value, condition, ">");
    }

    public void lessThanOrEqual(String propName, String value, AbstractQueryBuilder.LOGICAL condition) {
        this.comparison(propName, value, condition, "<=");
    }

    public void greaterOrEqual(String propName, String value, AbstractQueryBuilder.LOGICAL condition) {
        this.comparison(propName, value, condition, ">=");
    }

    public void equal(String propName, String value, AbstractQueryBuilder.LOGICAL condition) {
        this.comparison(propName, value, condition, "=");
    }

    public void notEqual(String propName, String value, AbstractQueryBuilder.LOGICAL condition) {
        if (condition == AbstractQueryBuilder.LOGICAL.AND) {
            this.propertiesClause.append("AND ").append(propName).append(" <> '").append(value).append("' ");
        } else if (condition == AbstractQueryBuilder.LOGICAL.OR) {
            this.propertiesClause.append("OR ").append(propName).append(" <> '").append(value).append("' ");
        } else {
            this.propertiesClause.append(propName).append(" <> '").append(value).append("' ");
        }
    }

    private void comparison(String propName, String value, AbstractQueryBuilder.LOGICAL condition, String symbol) {
        if (condition == AbstractQueryBuilder.LOGICAL.AND) {
            this.propertiesClause.append("AND ").append(propName).append(" ").append(symbol).append(" '").append(value).append("' ");
        } else if (condition == AbstractQueryBuilder.LOGICAL.OR) {
            this.propertiesClause.append("OR ").append(propName).append(" ").append(symbol).append(" '").append(value).append("' ");
        } else {
            this.propertiesClause.append(propName).append(" ").append(symbol).append(" '").append(value).append("' ");
        }
    }

    public void like(String propName, String value, AbstractQueryBuilder.LOGICAL condition) {
        if (condition == AbstractQueryBuilder.LOGICAL.AND) {
            this.propertiesClause.append("AND ").append(propName).append(" LIKE '").append(value).append("%' ");
        } else if (condition == AbstractQueryBuilder.LOGICAL.OR) {
            this.propertiesClause.append("OR ").append(propName).append(" LIKE '").append(value).append("%' ");
        } else {
            this.propertiesClause.append(propName).append(" LIKE '").append(value).append("%' ");
        }
    }

    public void reference(String propName, String value, AbstractQueryBuilder.LOGICAL condition) {
    }

    public void beforeDate(String propName, String comparedDate, AbstractQueryBuilder.LOGICAL condition) {
        Calendar calendar = ISO8601.parse((String)comparedDate);
        String time = calendar.getTime().toString();
        if (condition == AbstractQueryBuilder.LOGICAL.AND) {
            this.propertiesClause.append("AND ").append(propName).append(" <= '").append(time).append("' ");
        } else if (condition == AbstractQueryBuilder.LOGICAL.OR) {
            this.propertiesClause.append("OR ").append(propName).append(" <= '").append(time).append("' ");
        } else {
            this.propertiesClause.append(propName).append(" <= '").append(time).append("' ");
        }
    }

    public void afterDate(String propName, String comparedDate, AbstractQueryBuilder.LOGICAL condition) {
        Calendar calendar = ISO8601.parse((String)comparedDate);
        String time = calendar.getTime().toString();
        if (condition == AbstractQueryBuilder.LOGICAL.AND) {
            this.propertiesClause.append("AND ").append(propName).append(" >= '").append(time).append("' ");
        } else if (condition == AbstractQueryBuilder.LOGICAL.OR) {
            this.propertiesClause.append("OR ").append(propName).append(" >= '").append(time).append("' ");
        } else {
            this.propertiesClause.append(propName).append(" >= '").append(time).append("' ");
        }
    }

    public void betweenDates(String propName, String startDate, String endDate, AbstractQueryBuilder.LOGICAL condition) {
        String startTime = ISO8601.parse((String)startDate).getTime().toString();
        String endTime = ISO8601.parse((String)endDate).getTime().toString();
        if (condition == AbstractQueryBuilder.LOGICAL.AND) {
            this.propertiesClause.append("AND ").append(propName).append(" between '").append(startTime).append("' and '").append(endTime).append("' ");
        } else if (condition == AbstractQueryBuilder.LOGICAL.OR) {
            this.propertiesClause.append("OR ").append(propName).append(" between '").append(startTime).append("' and '").append(endTime).append("' ");
        } else {
            this.propertiesClause.append(propName).append(" between '").append(startTime).append("' and '").append(endTime).append("' ");
        }
    }

    public void setQueryPath(String path, AbstractQueryBuilder.PATH_TYPE pathtype) {
        if (AbstractQueryBuilder.PATH_TYPE.EXACT == pathtype) {
            this.pathClause = path.indexOf("[%]") > 0 ? new StringBuilder().append("jcr:path LIKE '").append(path).append("' ") : new StringBuilder().append("jcr:path = '").append(path).append("' ");
        } else if (AbstractQueryBuilder.PATH_TYPE.CHILDNODES == pathtype) {
            this.pathClause = new StringBuilder().append("jcr:path LIKE '").append(path).append("/%'").append("AND NOT jcr:path like '").append(path).append("/%/%' ");
        } else if (AbstractQueryBuilder.PATH_TYPE.DECENDANTS == pathtype) {
            this.pathClause = new StringBuilder().append("jcr:path LIKE '").append(path).append("/%' ");
        } else if (AbstractQueryBuilder.PATH_TYPE.DECENDANTS_OR_SELFT == pathtype) {
            this.pathClause = new StringBuilder().append("jcr:path LIKE '").append(path).append("'").append("OR jcr:path LIKE '").append(path).append("/%' ");
        }
    }

    public void contains(String scope, String term, AbstractQueryBuilder.LOGICAL condition) {
        if (scope == null) {
            scope = ".";
        }
        if (AbstractQueryBuilder.LOGICAL.AND == condition) {
            this.containsClause.append("AND CONTAINS(").append(scope).append(",'").append(term).append("') ");
        } else if (AbstractQueryBuilder.LOGICAL.AND == condition) {
            this.containsClause.append("OR CONTAINS(").append(scope).append(",'").append(term).append("') ");
        } else {
            this.containsClause.append("CONTAINS(").append(scope).append(",'").append(term).append("') ");
        }
    }

    public void notContains(String scope, String term, AbstractQueryBuilder.LOGICAL condition) {
        if (scope == null) {
            scope = ".";
        }
        if (AbstractQueryBuilder.LOGICAL.AND == condition) {
            this.containsClause.append("AND NOT CONTAINS(").append(scope).append(",'").append(term).append("') ");
        } else if (AbstractQueryBuilder.LOGICAL.OR == condition) {
            this.containsClause.append("OR NOT CONTAINS(").append(scope).append(",'").append(term).append("') ");
        } else {
            this.containsClause.append("NOT CONTAINS(").append(scope).append(",'").append(term).append("') ");
        }
    }

    public void fromNodeTypes(String[] nodetypes) {
        if (nodetypes == null) {
            this.fromClause = new StringBuilder("FROM nt:base");
            return;
        }
        this.fromClause = new StringBuilder("FROM ");
        for (int i = 0; i < nodetypes.length; ++i) {
            this.fromClause.append(nodetypes[i]);
            if (i >= nodetypes.length - 1) continue;
            this.fromClause.append(",");
        }
    }

    public void selectTypes(String[] returnTypes) {
        if (returnTypes == null) {
            this.selectClause = new StringBuilder("SELECT * ");
            return;
        }
        this.selectClause = new StringBuilder("SELECT ");
        for (int i = 0; i < returnTypes.length; ++i) {
            this.selectClause.append(returnTypes[i]);
            if (i < returnTypes.length - 1) {
                this.selectClause.append(",");
            }
            this.selectClause.append(" ");
        }
    }

    public void orderBy(String properyName, AbstractQueryBuilder.ORDERBY orderby) {
        if (this.orderByClause.length() > 0) {
            this.orderByClause = this.orderByClause.append(", ");
        }
        if (AbstractQueryBuilder.ORDERBY.ASC == orderby) {
            this.orderByClause.append(properyName).append(" ASC");
        } else {
            this.orderByClause.append(properyName).append(" DESC");
        }
    }

    public void excerpt(boolean enable) {
        if (enable) {
            this.excerptClause = new StringBuilder("excerpt(.)");
        }
    }

    public void spellCheck(String value) {
    }

    public void openGroup(AbstractQueryBuilder.LOGICAL logical) {
        this.propertiesClause = AbstractQueryBuilder.LOGICAL.AND == logical ? this.propertiesClause.append("AND( ") : (AbstractQueryBuilder.LOGICAL.OR == logical ? this.propertiesClause.append("OR( ") : (AbstractQueryBuilder.LOGICAL.AND_NOT == logical ? this.propertiesClause.append("AND NOT(") : (AbstractQueryBuilder.LOGICAL.OR_NOT == logical ? this.propertiesClause.append("OR NOT(") : this.propertiesClause.append("( "))));
    }

    public void closeGroup() {
        this.propertiesClause = this.propertiesClause.append(")");
    }

    public String createQueryStatement() {
        StringBuffer statement = new StringBuffer();
        statement = statement.append(this.selectClause.toString()).append(this.fromClause.toString()).append(" WHERE ");
        if (this.containsClause.length() > 0) {
            statement = statement.append(this.containsClause.toString());
            if (this.pathClause.length() > 0) {
                statement = statement.append("AND ").append(this.pathClause.toString());
            }
        } else if (this.pathClause.length() > 0) {
            statement = statement.append(this.pathClause.toString());
        }
        if (this.propertiesClause.length() > 0) {
            statement = statement.append(this.propertiesClause.toString());
        }
        if (this.orderByClause.length() > 0) {
            statement = statement.append("ORDER BY ").append(this.orderByClause.toString());
        }
        return statement.toString();
    }

    public void merge(AbstractQueryBuilder other) {
    }
}

