/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.webcontent;

import java.util.List;
import javax.jcr.Node;
import javax.jcr.Session;
import org.exoplatform.services.html.HTMLDocument;
import org.exoplatform.services.html.parser.HTMLParser;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.wcm.core.BaseWebSchemaHandler;
import org.exoplatform.services.wcm.core.WebSchemaConfigService;
import org.exoplatform.services.wcm.webcontent.LinkExtractor;
import org.exoplatform.services.wcm.webcontent.WebContentSchemaHandler;

public class HTMLFileSchemaHandler
extends BaseWebSchemaHandler {
    private LinkExtractor linkExtractor = new LinkExtractor();

    protected String getHandlerNodeType() {
        return "nt:file";
    }

    protected String getParentNodeType() {
        return "exo:webFolder";
    }

    public boolean matchHandler(Node node, SessionProvider sessionProvider) throws Exception {
        if (!this.matchNodeType(node)) {
            return false;
        }
        if (!this.matchMimeType(node)) {
            return false;
        }
        return this.matchParentNodeType(node) || this.isInWebContent(node);
    }

    private boolean matchNodeType(Node node) throws Exception {
        return node.getPrimaryNodeType().getName().equals("nt:file");
    }

    private boolean matchMimeType(Node node) throws Exception {
        String mimeType = this.getFileMimeType(node);
        if ("text/html".equals(mimeType)) {
            return true;
        }
        return "text/plain".equals(mimeType);
    }

    public boolean isInWebContent(Node file) throws Exception {
        if (file.getParent().isNodeType("exo:webContent")) {
            return file.isNodeType("exo:htmlFile");
        }
        return false;
    }

    private boolean matchParentNodeType(Node file) throws Exception {
        return file.getParent().isNodeType("exo:webFolder");
    }

    public void onCreateNode(Node file, SessionProvider sessionProvider) throws Exception {
        Session session = file.getSession();
        Node webFolder = file.getParent();
        String fileName = file.getName();
        this.addMixin(file, "exo:htmlFile");
        file.setProperty("exo:presentationType", "exo:htmlFile");
        String tempFolderName = fileName + this.hashCode();
        Node tempFolder = webFolder.addNode(tempFolderName, this.NT_UNSTRUCTURED);
        String tempPath = tempFolder.getPath() + "/" + file.getName();
        session.move(file.getPath(), tempPath);
        session.save();
        Node webContent = webFolder.addNode(fileName, "exo:webContent");
        this.addMixin(webContent, "exo:privilegeable");
        this.addMixin(webContent, "exo:owneable");
        WebSchemaConfigService schemaConfigService = this.getService(WebSchemaConfigService.class);
        WebContentSchemaHandler contentSchemaHandler = schemaConfigService.getWebSchemaHandlerByType(WebContentSchemaHandler.class);
        contentSchemaHandler.createSchema(webContent);
        session.save();
        String htmlFilePath = webContent.getPath() + "/default.html";
        session.move(tempPath, htmlFilePath);
        tempFolder.remove();
        session.save();
    }

    public void onModifyNode(Node node, SessionProvider sessionProvider) throws Exception {
        Node parent = node.getParent();
        if (!parent.isNodeType("exo:webContent")) {
            return;
        }
        if (!parent.isCheckedOut() || parent.isLocked() || !node.isCheckedOut() || node.isLocked()) {
            return;
        }
        String htmlData = node.getNode("jcr:content").getProperty("jcr:data").getString();
        HTMLDocument document = HTMLParser.createDocument((String)htmlData);
        List<String> newLinks = this.linkExtractor.extractLink(document);
        this.linkExtractor.updateLinks(parent, newLinks);
    }
}

