/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.clv;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.Session;
import javax.portlet.PortletPreferences;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.ecm.webui.utils.Utils;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.webui.container.UIContainer;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.resolver.ResourceResolver;
import org.exoplatform.services.cms.thumbnail.ThumbnailService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.UserProfile;
import org.exoplatform.services.organization.UserProfileHandler;
import org.exoplatform.services.wcm.core.WCMConfigurationService;
import org.exoplatform.services.wcm.core.WebSchemaConfigService;
import org.exoplatform.services.wcm.webcontent.WebContentSchemaHandler;
import org.exoplatform.wcm.webui.clv.UIContentListPresentation;
import org.exoplatform.wcm.webui.clv.UIFolderViewer;
import org.exoplatform.wcm.webui.paginator.UICustomizeablePaginator;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.ComponentConfigs;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIPageIterator;
import org.exoplatform.webui.core.lifecycle.Lifecycle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfigs(value={@ComponentConfig(lifecycle=Lifecycle.class, events={@EventConfig(listeners={RefreshActionListener.class})}), @ComponentConfig(type=UICustomizeablePaginator.class, events={@EventConfig(listeners={UICustomizeablePaginator.ShowPageActionListener.class})})})
public class UIContentListPresentation
extends UIContainer {
    private String templatePath;
    private ResourceResolver resourceResolver;
    private UICustomizeablePaginator uiPaginator;
    private String contentColumn;
    private boolean showHeader;
    private String header;
    private SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");

    public void init(String templatePath, ResourceResolver resourceResolver, PageList dataPageList) throws Exception {
        PortletPreferences portletPreferences = ((UIFolderViewer)this.getParent()).getPortletPreference();
        String paginatorTemplatePath = portletPreferences.getValue("paginatorTemplatePath", null);
        this.templatePath = templatePath;
        this.resourceResolver = resourceResolver;
        this.uiPaginator = (UICustomizeablePaginator)this.addChild(UICustomizeablePaginator.class, null, null);
        this.uiPaginator.setTemplatePath(paginatorTemplatePath);
        this.uiPaginator.setResourceResolver(resourceResolver);
        this.uiPaginator.setPageList(dataPageList);
    }

    public boolean showRefreshButton() {
        PortletPreferences portletPreferences = ((UIFolderViewer)this.getParent()).getPortletPreference();
        String isShow = portletPreferences.getValue("showRefreshButton", null);
        return isShow != null ? Boolean.parseBoolean(isShow) : false;
    }

    public boolean isShowField(String field) {
        PortletPreferences portletPreferences = ((UIFolderViewer)this.getParent()).getPortletPreference();
        String showAble = portletPreferences.getValue(field, null);
        return showAble != null ? Boolean.parseBoolean(showAble) : false;
    }

    public boolean showPaginator() throws Exception {
        PortletPreferences portletPreferences = ((UIFolderViewer)this.getParent()).getPortletPreference();
        String itemsPerPage = portletPreferences.getValue("itemsPerPage", null);
        int totalItems = this.uiPaginator.getTotalItems();
        return totalItems > Integer.parseInt(itemsPerPage);
    }

    public String getTemplate() {
        return this.templatePath;
    }

    public SimpleDateFormat getDatetimeFommatter() {
        return this.dateFormatter;
    }

    public void setDateTimeFormat(String format) {
        this.dateFormatter.applyPattern(format);
    }

    public String getContentColumn() {
        return this.contentColumn;
    }

    public void setContentColumn(String column) {
        this.contentColumn = column;
    }

    public UIPageIterator getUIPageIterator() {
        return this.uiPaginator;
    }

    public ResourceResolver getTemplateResourceResolver(WebuiRequestContext context, String template) {
        return this.resourceResolver;
    }

    public List getCurrentPageData() throws Exception {
        return this.uiPaginator.getCurrentPageData();
    }

    public String getTitle(Node node) throws Exception {
        return node.hasProperty("exo:title") ? node.getProperty("exo:title").getValue().getString() : node.getName();
    }

    public String getSummary(Node node) throws Exception {
        return node.hasProperty("exo:summary") ? node.getProperty("exo:summary").getValue().getString() : null;
    }

    public String getURL(Node node) throws Exception {
        String link = null;
        PortalRequestContext portalRequestContext = Util.getPortalRequestContext();
        WCMConfigurationService wcmConfigurationService = (WCMConfigurationService)this.getApplicationComponent(WCMConfigurationService.class);
        PortletRequestContext portletRequestContext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        String portalURI = portalRequestContext.getPortalURI();
        PortletPreferences portletPreferences = ((UIFolderViewer)this.getParent()).getPortletPreference();
        String repository = portletPreferences.getValue("repository", null);
        String workspace = portletPreferences.getValue("workspace", null);
        String baseURI = portletRequestContext.getRequest().getScheme() + "://" + portletRequestContext.getRequest().getServerName() + ":" + String.format("%s", portletRequestContext.getRequest().getServerPort());
        String parameterizedPageURI = wcmConfigurationService.getParameterizedPageURI();
        link = baseURI + portalURI + parameterizedPageURI.substring(1, parameterizedPageURI.length()) + "/" + repository + "/" + workspace + node.getPath();
        return link;
    }

    public String getAuthor(Node node) throws Exception {
        if (node.hasProperty("exo:owner")) {
            String ownerId = node.getProperty("exo:owner").getValue().getString();
            OrganizationService organizationService = (OrganizationService)this.getApplicationComponent(OrganizationService.class);
            UserProfileHandler handler = organizationService.getUserProfileHandler();
            UserProfile userProfile = handler.findUserProfileByName(ownerId);
            return (String)userProfile.getUserInfoMap().get("user.name.given");
        }
        return null;
    }

    public String getCreatedDate(Node node) throws Exception {
        if (node.hasProperty("exo:dateCreated")) {
            Calendar calendar = node.getProperty("exo:dateCreated").getValue().getDate();
            return this.dateFormatter.format(calendar.getTime());
        }
        return null;
    }

    public String getModifiedDate(Node node) throws Exception {
        if (node.hasProperty("exo:dateModified")) {
            Calendar calendar = node.getProperty("exo:dateModified").getValue().getDate();
            return this.dateFormatter.format(calendar.getTime());
        }
        return null;
    }

    public String getContentType(Node node) {
        return null;
    }

    public String getContentIcon(Node node) {
        return null;
    }

    public String getContentSize(Node node) {
        return null;
    }

    public String getIllustrativeImage(Node node) throws Exception {
        String imagePath = null;
        if (node.isNodeType("exo:webContent")) {
            WebSchemaConfigService schemaConfigService = (WebSchemaConfigService)this.getApplicationComponent(WebSchemaConfigService.class);
            WebContentSchemaHandler contentSchemaHandler = (WebContentSchemaHandler)schemaConfigService.getWebSchemaHandlerByType(WebContentSchemaHandler.class);
            Node illustrativeImage = null;
            try {
                illustrativeImage = contentSchemaHandler.getIllustrationImage(node);
                imagePath = Utils.getThumbnailImage((Node)illustrativeImage, (String)ThumbnailService.MEDIUM_SIZE);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (imagePath == null && illustrativeImage != null) {
                Session session = illustrativeImage.getSession();
                String repository = ((ManageableRepository)session.getRepository()).getConfiguration().getName();
                String workspace = session.getWorkspace().getName();
                imagePath = "/portal/rest/jcr/" + repository + "/" + workspace + illustrativeImage.getPath();
            }
            return imagePath;
        }
        PortletRequestContext requestContext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        String showThumbnailPref = requestContext.getRequest().getPreferences().getValue("showThumbnailsView", "false");
        boolean isShowThumbnail = Boolean.parseBoolean(showThumbnailPref);
        if (isShowThumbnail) {
            return Utils.getThumbnailImage((Node)node, (String)ThumbnailService.MEDIUM_SIZE);
        }
        return null;
    }

    public List<String> getCategories(Node node) {
        return null;
    }

    public List<String> getTags(Node node) {
        return null;
    }

    public float getVotingRate(Node node) {
        return 0.0f;
    }

    public int getNumberOfComments(Node node) {
        return 0;
    }

    public List<Node> getRelatedContents(Node node) {
        return null;
    }

    public boolean isShowHeader() {
        return this.showHeader;
    }

    public void setShowHeader(boolean showHeader) {
        this.showHeader = showHeader;
    }

    public void setHeader(String header) {
        this.header = header;
    }

    public String getHeader() {
        return this.header;
    }
}

