/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.clv;

import java.util.List;
import javax.jcr.AccessDeniedException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.portlet.PortletPreferences;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.ecm.resolver.JCRResourceResolver;
import org.exoplatform.portal.webui.container.UIContainer;
import org.exoplatform.portal.webui.util.SessionProviderFactory;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.resolver.ResourceResolver;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.wcm.utils.PaginatedNodeIterator;
import org.exoplatform.wcm.webui.clv.RefreshDelegateActionListener;
import org.exoplatform.wcm.webui.clv.UIContentListPresentation;
import org.exoplatform.wcm.webui.clv.UIContentListViewerPortlet;
import org.exoplatform.wcm.webui.clv.UIFolderViewer;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.Lifecycle;
import org.exoplatform.webui.event.Event;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=Lifecycle.class, template="app:/groovy/ContentListViewer/UIFolderListViewer.gtmpl", events={@EventConfig(listeners={QuickEditActionListener.class})})
public class UIFolderViewer
extends UIContainer
implements RefreshDelegateActionListener {
    private boolean canViewListContent;
    private String messageKey;

    public void init() throws Exception {
        NodeIterator nodeIterator = null;
        this.canViewListContent = true;
        this.messageKey = null;
        try {
            nodeIterator = this.getRenderedContentNodes();
        }
        catch (ItemNotFoundException e) {
            this.messageKey = "UIMessageBoard.msg.folder-not-found";
            this.canViewListContent = false;
            return;
        }
        catch (AccessDeniedException e) {
            this.messageKey = "UIMessageBoard.msg.no-permission";
            this.canViewListContent = false;
            return;
        }
        catch (Exception e) {
            this.messageKey = "UIMessageBoard.msg.error-nodetype";
            this.canViewListContent = false;
            return;
        }
        if (nodeIterator.getSize() == 0L) {
            this.messageKey = "UIMessageBoard.msg.folder-empty";
        }
        PortletPreferences portletPreferences = this.getPortletPreference();
        int itemsPerPage = Integer.parseInt(portletPreferences.getValue("itemsPerPage", null));
        PaginatedNodeIterator paginatedNodeIterator = new PaginatedNodeIterator(nodeIterator, itemsPerPage);
        UIContentListPresentation contentListPresentation = (UIContentListPresentation)this.addChild(UIContentListPresentation.class, null, null);
        String templatePath = this.getFormViewTemplatePath();
        ResourceResolver resourceResolver = this.getTemplateResourceResolver();
        contentListPresentation.init(templatePath, resourceResolver, (PageList)paginatedNodeIterator);
        contentListPresentation.setContentColumn(portletPreferences.getValue("header", null));
        contentListPresentation.setShowHeader(Boolean.parseBoolean(portletPreferences.getValue("showHeader", null)));
        contentListPresentation.setHeader(portletPreferences.getValue("header", null));
    }

    public String getMessage() throws Exception {
        WebuiRequestContext requestContext = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        return requestContext.getApplicationResourceBundle().getString(this.messageKey);
    }

    public boolean canViewListContent() {
        return this.canViewListContent;
    }

    protected PortletPreferences getPortletPreference() {
        PortletRequestContext portletRequestContext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        return portletRequestContext.getRequest().getPreferences();
    }

    protected String getRepository() {
        return this.getPortletPreference().getValue("repository", null);
    }

    protected String getFormViewTemplatePath() {
        return this.getPortletPreference().getValue("formViewTemplatePath", null);
    }

    public NodeIterator getRenderedContentNodes() throws Exception {
        PortletRequestContext portletRequestContext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletPreferences preferences = portletRequestContext.getRequest().getPreferences();
        String repository = preferences.getValue("repository", null);
        String worksapce = preferences.getValue("workspace", null);
        String folderPath = preferences.getValue("folderPath", null);
        if (repository == null || worksapce == null || folderPath == null) {
            throw new ItemNotFoundException();
        }
        RepositoryService repositoryService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        ManageableRepository manageableRepository = repositoryService.getRepository(repository);
        repositoryService.getCurrentRepository();
        String userId = Util.getPortalRequestContext().getRemoteUser();
        SessionProvider sessionProvider = null;
        sessionProvider = userId == null ? SessionProviderFactory.createAnonimProvider() : SessionProviderFactory.createSessionProvider();
        Session session = sessionProvider.getSession(worksapce, manageableRepository);
        TemplateService templateService = (TemplateService)this.getApplicationComponent(TemplateService.class);
        List listDocumentTypes = templateService.getDocumentTemplates(repository);
        StringBuffer documentTypeClause = new StringBuffer();
        for (int i = 0; i < listDocumentTypes.size(); ++i) {
            String documentType = (String)listDocumentTypes.get(i);
            documentTypeClause.append("jcr:primaryType = '" + documentType + "'");
            if (i == listDocumentTypes.size() - 1) continue;
            documentTypeClause.append(" OR ");
        }
        QueryManager manager = session.getWorkspace().getQueryManager();
        String statement = "select * from nt:base where jcr:path like '" + folderPath + "/%' AND NOT jcr:path like'" + folderPath + "/%/%'" + " AND( " + documentTypeClause.toString() + ")";
        Query query = manager.createQuery(statement, "sql");
        return query.execute().getNodes();
    }

    private ResourceResolver getTemplateResourceResolver() throws Exception {
        RepositoryService repositoryService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        String repository = this.getRepository();
        ManageableRepository manageableRepository = repositoryService.getRepository(repository);
        String workspace = manageableRepository.getConfiguration().getSystemWorkspaceName();
        return new JCRResourceResolver(repository, workspace, "exo:templateFile");
    }

    public String getPortletId() {
        PortletRequestContext pContext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        return pContext.getWindowId();
    }

    public boolean isQuickEditable() throws Exception {
        PortletRequestContext portletRequestContext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletPreferences prefs = portletRequestContext.getRequest().getPreferences();
        boolean isQuickEdit = Boolean.parseBoolean(prefs.getValue("showQuickEditButton", null));
        UIContentListViewerPortlet uiPresentationPortlet = (UIContentListViewerPortlet)this.getAncestorOfType(UIContentListViewerPortlet.class);
        if (isQuickEdit) {
            return uiPresentationPortlet.canEditPortlet();
        }
        return false;
    }

    public void onRefresh(Event<UIContentListPresentation> event) throws Exception {
        UIContentListPresentation contentListPresentation = (UIContentListPresentation)event.getSource();
        UIFolderViewer uiFolderViewer = (UIFolderViewer)contentListPresentation.getParent();
        uiFolderViewer.getChildren().clear();
        uiFolderViewer.init();
    }
}

