/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.clv.config;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.portlet.PortletPreferences;
import org.exoplatform.ecm.webui.form.UIFormInputSetWithAction;
import org.exoplatform.ecm.webui.selector.UISelectable;
import org.exoplatform.portal.webui.util.SessionProviderFactory;
import org.exoplatform.services.cms.views.ApplicationTemplateManagerService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.wcm.webui.clv.config.UIPortletConfig;
import org.exoplatform.wcm.webui.clv.config.UIViewerManagementForm;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupContainer;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/groovy/ContentListViewer/config/UIFolderListViewerConfigForm.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={CancelActionListener.class}), @EventConfig(listeners={SelectFolderPathActionListener.class})})
public class UIViewerManagementForm
extends UIForm
implements UISelectable {
    public static final String HEADER = "Header";
    public static final String PORTLET_NAME = "Content List Viewer";
    public static final String FORM_VIEW_TEMPLATE_CATEGORY = "list-by-folder";
    public static final String PAGINATOR_TEMPLATE_CATEGORY = "paginators";
    public static final String FOLDER_PATH_INPUTSET = "FolderPathInputSet";
    public static final String FOLDER_PATH_INPUT = "FolderPathInput";
    public static final String FORM_VIEW_TEMPLATES_SELECTOR = "FormViewTemplate";
    public static final String PAGINATOR_TEMPLATES_SELECTOR = "PaginatorTemplate";
    public static final String ITEMS_PER_PAGE_SELECTOR = "ItemsPerPage";
    public static final String VIEWER_BUTTON_QUICK_EDIT = "ViewerButtonQuickEdit";
    public static final String VIEWER_BUTTON_REFRESH = "ViewerButtonRefresh";
    public static final String VIEWER_THUMBNAILS_IMAGE = "ViewerThumbnailsView";
    public static final String VIEWER_TITLE = "ViewerTitle";
    public static final String VIEWER_DATE_CREATED = "ViewerDateCreated";
    public static final String VIEWER_SUMMARY = "ViewerSummary";
    public static final String VIEWER_HEADER = "ViewerHeader";

    public UIViewerManagementForm() throws Exception {
        PortletPreferences portletPreferences = ((PortletRequestContext)WebuiRequestContext.getCurrentInstance()).getRequest().getPreferences();
        String folderPath = portletPreferences.getValue("folderPath", "folderPath");
        UIFormStringInput headerInput = new UIFormStringInput(HEADER, HEADER, null);
        String headerValue = portletPreferences.getValue("header", null);
        headerInput.setValue((Object)headerValue);
        List formViewerTemplateList = this.getTemplateList(PORTLET_NAME, FORM_VIEW_TEMPLATE_CATEGORY);
        List paginatorTemplateList = this.getTemplateList(PORTLET_NAME, PAGINATOR_TEMPLATE_CATEGORY);
        ArrayList<SelectItemOption> itemsPerPageList = new ArrayList<SelectItemOption>();
        itemsPerPageList.add(new SelectItemOption("5", (Object)"5"));
        itemsPerPageList.add(new SelectItemOption("10", (Object)"10"));
        itemsPerPageList.add(new SelectItemOption("20", (Object)"20"));
        UIFormInputSetWithAction folderPathInputSet = new UIFormInputSetWithAction(FOLDER_PATH_INPUTSET);
        UIFormStringInput folderPathInput = new UIFormStringInput(FOLDER_PATH_INPUT, FOLDER_PATH_INPUT, null);
        folderPathInput.setEditable(false);
        if (folderPath != null) {
            folderPathInput.setValue((Object)folderPath);
        }
        folderPathInputSet.addChild((UIComponent)folderPathInput);
        folderPathInputSet.setActionInfo(FOLDER_PATH_INPUT, new String[]{"SelectFolderPath"});
        UIFormSelectBox itemsPerPage = new UIFormSelectBox(ITEMS_PER_PAGE_SELECTOR, ITEMS_PER_PAGE_SELECTOR, itemsPerPageList);
        UIFormSelectBox formViewTemplateSelector = new UIFormSelectBox(FORM_VIEW_TEMPLATES_SELECTOR, FORM_VIEW_TEMPLATES_SELECTOR, formViewerTemplateList);
        UIFormSelectBox paginatorTemplateSelector = new UIFormSelectBox(PAGINATOR_TEMPLATES_SELECTOR, PAGINATOR_TEMPLATES_SELECTOR, paginatorTemplateList);
        UIFormCheckBoxInput viewerButtonQuickEditCheckbox = new UIFormCheckBoxInput(VIEWER_BUTTON_QUICK_EDIT, VIEWER_BUTTON_QUICK_EDIT, null);
        viewerButtonQuickEditCheckbox.setChecked(true);
        UIFormCheckBoxInput viewerButtonRefreshCheckbox = new UIFormCheckBoxInput(VIEWER_BUTTON_REFRESH, VIEWER_BUTTON_REFRESH, null);
        viewerButtonRefreshCheckbox.setChecked(true);
        UIFormCheckBoxInput thumbnailsViewCheckbox = new UIFormCheckBoxInput(VIEWER_THUMBNAILS_IMAGE, VIEWER_THUMBNAILS_IMAGE, null);
        thumbnailsViewCheckbox.setChecked(true);
        UIFormCheckBoxInput titleViewerCheckbox = new UIFormCheckBoxInput(VIEWER_TITLE, VIEWER_TITLE, null);
        titleViewerCheckbox.setChecked(true);
        UIFormCheckBoxInput summaryViewerCheckbox = new UIFormCheckBoxInput(VIEWER_SUMMARY, VIEWER_SUMMARY, null);
        summaryViewerCheckbox.setChecked(true);
        UIFormCheckBoxInput dateCreatedViewerCheckbox = new UIFormCheckBoxInput(VIEWER_DATE_CREATED, VIEWER_DATE_CREATED, null);
        dateCreatedViewerCheckbox.setChecked(true);
        UIFormCheckBoxInput viewerHeader = new UIFormCheckBoxInput(VIEWER_HEADER, VIEWER_HEADER, null);
        viewerHeader.setChecked(Boolean.parseBoolean(portletPreferences.getValue("showHeader", null)));
        String quickEditAble = portletPreferences.getValue("showQuickEditButton", null);
        viewerButtonQuickEditCheckbox.setChecked(Boolean.parseBoolean(quickEditAble));
        String refreshAble = portletPreferences.getValue("showRefreshButton", null);
        viewerButtonRefreshCheckbox.setChecked(Boolean.parseBoolean(refreshAble));
        String imageShowAble = portletPreferences.getValue("showThumbnailsView", null);
        thumbnailsViewCheckbox.setChecked(Boolean.parseBoolean(imageShowAble));
        String titleShowAble = portletPreferences.getValue("showTitle", null);
        titleViewerCheckbox.setChecked(Boolean.parseBoolean(titleShowAble));
        String summaryShowAble = portletPreferences.getValue("showSummary", null);
        summaryViewerCheckbox.setChecked(Boolean.parseBoolean(summaryShowAble));
        String dateShowAble = portletPreferences.getValue("showDateCreated", null);
        dateCreatedViewerCheckbox.setChecked(Boolean.parseBoolean(dateShowAble));
        String formViewTemplate = portletPreferences.getValue("formViewTemplatePath", null);
        formViewTemplateSelector.setValue(formViewTemplate);
        String paginatorTemplate = portletPreferences.getValue("paginatorTemplatePath", null);
        paginatorTemplateSelector.setValue(paginatorTemplate);
        String itemsPerPageVal = portletPreferences.getValue("itemsPerPage", null);
        itemsPerPage.setValue(itemsPerPageVal);
        this.addChild((UIComponent)folderPathInputSet);
        this.addChild((UIComponent)headerInput);
        this.addChild((UIComponent)formViewTemplateSelector);
        this.addChild((UIComponent)paginatorTemplateSelector);
        this.addChild((UIComponent)itemsPerPage);
        this.addChild((UIComponent)viewerButtonQuickEditCheckbox);
        this.addChild((UIComponent)viewerButtonRefreshCheckbox);
        this.addChild((UIComponent)thumbnailsViewCheckbox);
        this.addChild((UIComponent)titleViewerCheckbox);
        this.addChild((UIComponent)dateCreatedViewerCheckbox);
        this.addChild((UIComponent)summaryViewerCheckbox);
        this.addChild((UIComponent)viewerHeader);
        this.setActions(new String[]{"Save", "Cancel"});
    }

    public void doSelect(String selectField, Object value) throws Exception {
        this.getUIStringInput(selectField).setValue((Object)((String)value));
        this.showPopupComponent(null);
    }

    public void showPopupComponent(UIComponent uiComponent) throws Exception {
        UIPortletConfig uiPortletConfig = (UIPortletConfig)this.getAncestorOfType(UIPortletConfig.class);
        UIPopupContainer uiPopupContainer = (UIPopupContainer)uiPortletConfig.getChild(UIPopupContainer.class);
        if (uiComponent == null) {
            uiPopupContainer.deActivate();
            return;
        }
        uiComponent.setRendered(true);
        uiPopupContainer.activate(uiComponent, 600, 300);
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        context.addUIComponentToUpdateByAjax((UIComponent)uiPopupContainer);
    }

    private List<SelectItemOption<String>> getTemplateList(String portletName, String category) throws Exception {
        ArrayList<SelectItemOption<String>> templateOptionList = new ArrayList<SelectItemOption<String>>();
        ApplicationTemplateManagerService templateManagerService = (ApplicationTemplateManagerService)this.getApplicationComponent(ApplicationTemplateManagerService.class);
        SessionProvider provider = SessionProviderFactory.createSessionProvider();
        RepositoryService repositoryService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        ManageableRepository manageableRepository = repositoryService.getCurrentRepository();
        String repository = manageableRepository.getConfiguration().getName();
        List templateNodeList = templateManagerService.getTemplatesByCategory(repository, portletName, category, provider);
        for (Node templateNode : templateNodeList) {
            String templateName = templateNode.getName();
            String templatePath = templateNode.getPath();
            templateOptionList.add((SelectItemOption<String>)new SelectItemOption(templateName, (Object)templatePath));
        }
        return templateOptionList;
    }
}

