/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.pcv;

import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLDecoder;
import java.security.AccessControlException;
import java.util.List;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.Session;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.ecm.resolver.JCRResourceResolver;
import org.exoplatform.ecm.webui.presentation.UIBaseNodePresentation;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.webui.portal.UIPortal;
import org.exoplatform.portal.webui.util.SessionProviderFactory;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.resolver.ResourceResolver;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.wcm.webui.pcv.UIContentViewerContainer;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.lifecycle.Lifecycle;

@ComponentConfig(lifecycle=Lifecycle.class)
public class UIContentViewer
extends UIBaseNodePresentation {
    private Node contentNode;
    private JCRResourceResolver resourceResolver;
    private String repository;
    private String workspace;
    public static final String CONTENT_NOT_FOUND_EXC = "UIMessageBoard.msg.content-not-found";
    public static final String ACCESS_CONTROL_EXC = "UIMessageBoard.msg.access-control-exc";
    public static final String CONTENT_UNSUPPORT_EXC = "UIMessageBoard.msg.content-unsupport-exc";
    public static final String PARAMETER_REGX = "(.*)/(.*)";

    public Node getNode() throws Exception {
        return this.contentNode;
    }

    public Node getOriginalNode() throws Exception {
        return this.getNode();
    }

    public String getRepositoryName() throws Exception {
        return this.repository;
    }

    public String getWorkspaceName() throws Exception {
        return this.workspace;
    }

    public String getTemplatePath() throws Exception {
        TemplateService templateService = (TemplateService)this.getApplicationComponent(TemplateService.class);
        return templateService.getTemplatePath(this.getNode(), false);
    }

    public String getTemplate() {
        try {
            return this.getTemplatePath();
        }
        catch (Exception e) {
            return null;
        }
    }

    public ResourceResolver getTemplateResourceResolver(WebuiRequestContext context, String template) {
        try {
            this.resourceResolver = new JCRResourceResolver(this.repository, this.workspace, "exo:templateFile");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.resourceResolver;
    }

    public String getNodeType() throws Exception {
        return this.contentNode.getPrimaryNodeType().getName();
    }

    public boolean isNodeTypeSupported() {
        return false;
    }

    public void setNode(Node node) {
        this.contentNode = node;
    }

    public void setRepository(String repository) {
        this.repository = repository;
    }

    public void setWorkspace(String workspace) {
        this.workspace = workspace;
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        PortletRequestContext porletRequestContext = (PortletRequestContext)context;
        HttpServletRequestWrapper requestWrapper = (HttpServletRequestWrapper)porletRequestContext.getRequest();
        PortalRequestContext portalRequestContext = Util.getPortalRequestContext();
        UIPortal uiPortal = Util.getUIPortal();
        String portalURI = portalRequestContext.getPortalURI();
        String requestURI = requestWrapper.getRequestURI();
        String pageNodeSelected = uiPortal.getSelectedNode().getName();
        String parameters = null;
        Object object = requestWrapper.getAttribute("ParameterizedContentViewerPortlet.data.object");
        try {
            parameters = URLDecoder.decode(StringUtils.substringAfter((String)requestURI, (String)portalURI.concat(pageNodeSelected + "/")), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        if (!parameters.matches(PARAMETER_REGX)) {
            this.renderErrorMessage(context, CONTENT_NOT_FOUND_EXC);
            return;
        }
        String nodeIdentifier = null;
        String[] params = parameters.split("/");
        String repository = params[0];
        String workspace = params[1];
        Node currentNode = null;
        SessionProvider sessionProvider = null;
        Session session = null;
        String userId = Util.getPortalRequestContext().getRemoteUser();
        sessionProvider = userId == null ? SessionProviderFactory.createAnonimProvider() : SessionProviderFactory.createSessionProvider();
        if (object instanceof ItemNotFoundException || object instanceof AccessControlException || object instanceof ItemNotFoundException || object == null) {
            try {
                RepositoryService repositoryService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
                ManageableRepository manageableRepository = repositoryService.getRepository(repository);
                session = sessionProvider.getSession(workspace, manageableRepository);
            }
            catch (AccessControlException ace) {
                this.renderErrorMessage(context, ACCESS_CONTROL_EXC);
                return;
            }
            catch (Exception e) {
                this.renderErrorMessage(context, CONTENT_NOT_FOUND_EXC);
                return;
            }
            if (params.length > 2) {
                StringBuffer identifier = new StringBuffer();
                for (int i = 2; i < params.length; ++i) {
                    identifier.append("/").append(params[i]);
                }
                nodeIdentifier = identifier.toString();
                boolean isUUID = false;
                try {
                    currentNode = (Node)session.getItem(nodeIdentifier);
                }
                catch (Exception e) {
                    isUUID = true;
                }
                if (isUUID) {
                    try {
                        String uuid = params[params.length - 1];
                        currentNode = session.getNodeByUUID(uuid);
                    }
                    catch (ItemNotFoundException exc) {
                        this.renderErrorMessage(context, CONTENT_NOT_FOUND_EXC);
                        return;
                    }
                }
            } else if (params.length == 2) {
                currentNode = session.getRootNode();
            }
        } else {
            currentNode = (Node)object;
        }
        TemplateService templateService = (TemplateService)this.getApplicationComponent(TemplateService.class);
        List documentTypes = templateService.getDocumentTemplates(repository);
        Boolean isDocumentType = false;
        for (String docType : documentTypes) {
            if (!currentNode.isNodeType(docType)) continue;
            isDocumentType = true;
            break;
        }
        if (currentNode.isNodeType("exo:hiddenable")) {
            this.renderErrorMessage(context, ACCESS_CONTROL_EXC);
            return;
        }
        if (isDocumentType.booleanValue()) {
            if (this.hasChildren()) {
                this.removeChild(UIContentViewerContainer.class);
            }
            this.setNode(currentNode);
            this.setRepository(repository);
            this.setWorkspace(workspace);
            super.processRender(context);
        } else {
            this.renderErrorMessage(context, CONTENT_UNSUPPORT_EXC);
        }
    }

    private void renderErrorMessage(WebuiRequestContext context, String keyBundle) throws Exception {
        Writer writer = context.getWriter();
        String message = context.getApplicationResourceBundle().getString(keyBundle);
        writer.write("<div style=\"height: 55px; font-size: 13px; text-align: center; padding-top: 10px;\">");
        writer.write("<span>");
        writer.write(message);
        writer.write("</span>");
        writer.write("</div>");
        writer.close();
    }
}

