/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.scv;

import java.security.AccessControlException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.Session;
import javax.portlet.PortletMode;
import javax.portlet.PortletPreferences;
import org.apache.commons.logging.Log;
import org.exoplatform.portal.webui.util.SessionProviderFactory;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.wcm.webui.Utils;
import org.exoplatform.wcm.webui.WebUIPropertiesConfigService;
import org.exoplatform.wcm.webui.scv.UIPresentationContainer;
import org.exoplatform.wcm.webui.scv.config.UIPortletConfig;
import org.exoplatform.wcm.webui.scv.config.UIStartEditionInPageWizard;
import org.exoplatform.webui.application.WebuiApplication;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupContainer;
import org.exoplatform.webui.core.UIPortletApplication;
import org.exoplatform.webui.core.lifecycle.UIApplicationLifecycle;

@ComponentConfig(lifecycle=UIApplicationLifecycle.class)
public class UISingleContentViewerPortlet
extends UIPortletApplication {
    public static String REPOSITORY = "repository";
    public static String WORKSPACE = "workspace";
    public static String IDENTIFIER = "nodeIdentifier";
    public static final Log scvLog = ExoLogger.getLogger((String)"wcm:SingleContentViewer");
    private PortletMode mode_ = PortletMode.VIEW;

    public UISingleContentViewerPortlet() throws Exception {
        this.activateMode(this.mode_);
    }

    private void activateMode(PortletMode mode) throws Exception {
        this.getChildren().clear();
        PortletRequestContext portletRequestContext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        if (portletRequestContext.getRemoteUser() != null) {
            this.addChild(UIPopupContainer.class, null, null);
        }
        if (PortletMode.VIEW.equals((Object)mode)) {
            this.addChild(UIPresentationContainer.class, null, UIPortletApplication.VIEW_MODE);
        } else if (PortletMode.EDIT.equals((Object)mode)) {
            UIPopupContainer maskPopupContainer = (UIPopupContainer)this.getChild(UIPopupContainer.class);
            UIStartEditionInPageWizard portletEditMode = (UIStartEditionInPageWizard)this.createUIComponent(UIStartEditionInPageWizard.class, null, null);
            this.addChild((UIComponent)portletEditMode);
            UIPortletConfig portletConfig = (UIPortletConfig)portletEditMode.createUIComponent(UIPortletConfig.class, null, null);
            portletEditMode.addChild((UIComponent)portletConfig);
            portletConfig.init();
            portletConfig.setRendered(true);
            WebUIPropertiesConfigService propertiesConfigService = (WebUIPropertiesConfigService)this.getApplicationComponent(WebUIPropertiesConfigService.class);
            WebUIPropertiesConfigService.PopupWindowProperties popupProperties = (WebUIPropertiesConfigService.PopupWindowProperties)propertiesConfigService.getProperties(WebUIPropertiesConfigService.SCV_POPUP_SIZE_EDIT_PORTLET_MODE);
            maskPopupContainer.activate((UIComponent)portletConfig, popupProperties.getWidth(), popupProperties.getHeight());
            portletRequestContext.addUIComponentToUpdateByAjax((UIComponent)maskPopupContainer);
        }
    }

    public void processRender(WebuiApplication app, WebuiRequestContext context) throws Exception {
        PortletRequestContext pContext = (PortletRequestContext)context;
        PortletMode newMode = pContext.getApplicationMode();
        if (!this.mode_.equals((Object)newMode)) {
            this.activateMode(newMode);
            this.mode_ = newMode;
        }
        super.processRender(app, context);
    }

    public boolean canEditPortlet() throws Exception {
        PortletRequestContext context = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        String userId = context.getRemoteUser();
        return Utils.canEditCurrentPortal((String)userId);
    }

    public Node getReferencedContent() throws Exception {
        PortletRequestContext portletRequestContext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletPreferences preferences = portletRequestContext.getRequest().getPreferences();
        String repository = preferences.getValue(REPOSITORY, "repository");
        String worksapce = preferences.getValue(WORKSPACE, "collaboration");
        String nodeIdentifier = preferences.getValue(IDENTIFIER, "");
        if (repository == null || worksapce == null || nodeIdentifier == null) {
            throw new ItemNotFoundException();
        }
        RepositoryService repositoryService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        ManageableRepository manageableRepository = repositoryService.getRepository(repository);
        String userId = Util.getPortalRequestContext().getRemoteUser();
        SessionProvider sessionProvider = null;
        sessionProvider = userId == null ? SessionProviderFactory.createAnonimProvider() : SessionProviderFactory.createSessionProvider();
        Session session = sessionProvider.getSession(worksapce, manageableRepository);
        Node content = null;
        try {
            content = session.getNodeByUUID(nodeIdentifier);
        }
        catch (Exception e) {
            content = (Node)session.getItem(nodeIdentifier);
        }
        return content;
    }

    public boolean canEditContent(Node content) throws Exception {
        if (!content.isNodeType("exo:webContent")) {
            return false;
        }
        try {
            ((ExtendedNode)content).checkPermission("add_node");
            ((ExtendedNode)content).checkPermission("remove");
            ((ExtendedNode)content).checkPermission("set_property");
        }
        catch (AccessControlException e) {
            return false;
        }
        return true;
    }
}

