/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.scv.config;

import javax.jcr.Node;
import javax.jcr.Session;
import javax.portlet.PortletPreferences;
import org.exoplatform.ecm.resolver.JCRResourceResolver;
import org.exoplatform.ecm.webui.form.DialogFormActionListeners;
import org.exoplatform.ecm.webui.form.UIDialogForm;
import org.exoplatform.ecm.webui.utils.LockUtil;
import org.exoplatform.portal.webui.util.SessionProviderFactory;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.resolver.ResourceResolver;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.wcm.core.NodeIdentifier;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.wcm.webui.scv.UISingleContentViewerPortlet;
import org.exoplatform.wcm.webui.scv.config.UIContentDialogForm;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;

@ComponentConfig(lifecycle=UIFormLifecycle.class, events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={CancelActionListener.class}), @EventConfig(listeners={DialogFormActionListeners.RemoveDataActionListener.class})})
public class UIContentDialogForm
extends UIDialogForm {
    protected JCRResourceResolver resourceResolver;
    protected NodeLocation storedLocation;
    public NodeIdentifier savedNodeIdentifier;
    protected Node webContent;
    private boolean isEditNotIntegrity;

    public UIContentDialogForm() throws Exception {
        this.setActions(ACTIONS);
    }

    public void init() throws Exception {
        PortletPreferences prefs = ((PortletRequestContext)WebuiRequestContext.getCurrentInstance()).getRequest().getPreferences();
        String repositoryName = prefs.getValue(UISingleContentViewerPortlet.REPOSITORY, null);
        String workspace = prefs.getValue(UISingleContentViewerPortlet.WORKSPACE, null);
        String identifier = prefs.getValue(UISingleContentViewerPortlet.IDENTIFIER, null);
        RepositoryService repositoryService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        ManageableRepository manageableRepository = repositoryService.getRepository(repositoryName);
        SessionProvider provider = SessionProviderFactory.createSessionProvider();
        Session session = provider.getSession(workspace, manageableRepository);
        Node webContentNode = null;
        try {
            webContentNode = session.getNodeByUUID(identifier);
        }
        catch (Exception e) {
            webContentNode = (Node)session.getItem(identifier);
        }
        NodeLocation nodeLocation = new NodeLocation();
        nodeLocation.setRepository(repositoryName);
        nodeLocation.setWorkspace(workspace);
        nodeLocation.setPath(webContentNode.getParent().getPath());
        this.setStoredLocation(nodeLocation);
        this.setNodePath(webContentNode.getPath());
        this.setContentType(webContentNode.getPrimaryNodeType().getName());
        this.addNew(false);
        this.resetProperties();
    }

    public Node getWebContent() {
        return this.webContent;
    }

    protected void setWebContent(Node node) {
        this.webContent = node;
    }

    public void setStoredLocation(NodeLocation location) {
        this.storedLocation = location;
        this.setRepositoryName(location.getRepository());
        this.setWorkspace(location.getWorkspace());
        this.setStoredPath(location.getPath());
    }

    public NodeIdentifier getSavedNodeIdentifier() {
        return this.savedNodeIdentifier;
    }

    public String getTemplate() {
        TemplateService templateService = (TemplateService)this.getApplicationComponent(TemplateService.class);
        String userName = Util.getPortalRequestContext().getRemoteUser();
        try {
            return templateService.getTemplatePathByUser(true, this.contentType, userName, this.repositoryName);
        }
        catch (Exception e) {
            UIApplication uiApp = (UIApplication)this.getAncestorOfType(UIApplication.class);
            Object[] arg = new Object[]{this.contentType};
            uiApp.addMessage(new ApplicationMessage("UIDocumentForm.msg.not-support", arg, 0));
            return null;
        }
    }

    public ResourceResolver getTemplateResourceResolver(WebuiRequestContext context, String template) {
        block3: {
            try {
                if (this.resourceResolver == null) {
                    RepositoryService repositoryService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
                    ManageableRepository manageableRepository = repositoryService.getRepository(this.repositoryName);
                    String workspace = manageableRepository.getConfiguration().getSystemWorkspaceName();
                    this.resourceResolver = new JCRResourceResolver(this.repositoryName, workspace, TemplateService.EXO_TEMPLATE_FILE_PROP);
                }
            }
            catch (Exception e) {
                if (!UISingleContentViewerPortlet.scvLog.isDebugEnabled()) break block3;
                UISingleContentViewerPortlet.scvLog.debug((Object)e);
            }
        }
        return this.resourceResolver;
    }

    public void onchange(Event event) throws Exception {
    }

    private Node getParentNode() throws Exception {
        String repository = this.storedLocation.getRepository();
        String path = this.storedLocation.getPath();
        String workspace = this.storedLocation.getWorkspace();
        RepositoryService repositoryService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        ManageableRepository manageableRepository = repositoryService.getRepository(repository);
        SessionProvider provider = SessionProviderFactory.createSessionProvider();
        Session session = provider.getSession(workspace, manageableRepository);
        Node parentNode = (Node)session.getItem(path);
        return parentNode;
    }

    private boolean nodeIsLocked(Node node) throws Exception {
        if (!node.isLocked()) {
            return false;
        }
        String lockToken = LockUtil.getLockToken((Node)node);
        if (lockToken != null) {
            node.getSession().addLockToken(lockToken);
            return false;
        }
        return true;
    }

    public boolean isEditNotIntegrity() {
        return this.isEditNotIntegrity;
    }

    public void setEditNotIntegrity(boolean isEditNotIntegrity) {
        this.isEditNotIntegrity = isEditNotIntegrity;
    }

    static /* synthetic */ boolean access$000(UIContentDialogForm x0, Node x1) throws Exception {
        return x0.nodeIsLocked(x1);
    }

    static /* synthetic */ Node access$100(UIContentDialogForm x0) throws Exception {
        return x0.getParentNode();
    }

    static /* synthetic */ String access$200(UIContentDialogForm x0) {
        return x0.contentType;
    }

    static /* synthetic */ boolean access$300(UIContentDialogForm x0) {
        return x0.isAddNew;
    }

    static /* synthetic */ String access$400(UIContentDialogForm x0) {
        return x0.repositoryName;
    }
}

