/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.scv.config;

import java.util.Map;
import java.util.Set;
import org.exoplatform.ecm.webui.selector.UISelectable;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.services.wcm.core.WCMConfigurationService;
import org.exoplatform.services.wcm.publication.WCMPublicationService;
import org.exoplatform.services.wcm.publication.WebpagePublicationPlugin;
import org.exoplatform.wcm.webui.scv.config.UIDMSSelectorForm;
import org.exoplatform.wcm.webui.scv.config.UIPortletConfig;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.ext.UIFormInputSetWithAction;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIFormWithTitle.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={BackActionListener.class}), @EventConfig(listeners={BrowseActionListener.class}), @EventConfig(listeners={BrowsePublicationActionListener.class})})
public class UIDMSSelectorForm
extends UIForm
implements UISelectable {
    static final String PATH = "path".intern();
    static final String FIELD_PATH = "location".intern();
    static final String PUBLICATION = "publication".intern();
    static final String PUBLICATION_PATH = "PublicationPath".intern();
    private String repository;
    private String workspace;
    private String livePortalsPath;
    private String liveSharedPortalName;

    public UIDMSSelectorForm() throws Exception {
        RepositoryService repoService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        String repoName = repoService.getCurrentRepository().getConfiguration().getName();
        WCMConfigurationService configurationService = (WCMConfigurationService)this.getApplicationComponent(WCMConfigurationService.class);
        NodeLocation nodeLocation = configurationService.getLivePortalsLocation(repoName);
        this.repository = nodeLocation.getRepository();
        this.workspace = nodeLocation.getWorkspace();
        this.livePortalsPath = nodeLocation.getPath();
        this.liveSharedPortalName = configurationService.getSharedPortalName(this.repository);
        UIFormInputSetWithAction uiPathSelection = new UIFormInputSetWithAction(FIELD_PATH);
        uiPathSelection.addUIFormInput((UIFormInput)new UIFormStringInput(PATH, PATH, null).setEditable(false));
        uiPathSelection.setActionInfo(PATH, new String[]{"Browse"});
        this.addChild((UIComponent)uiPathSelection);
        this.setActions(new String[]{"Save", "Back"});
    }

    public void init() throws Exception {
        WCMPublicationService wcmService = (WCMPublicationService)this.getApplicationComponent(WCMPublicationService.class);
        Map publicationPluginMap = wcmService.getWebpagePublicationPlugins();
        Set keySet = publicationPluginMap.keySet();
        if (keySet.size() > 1) {
            UIFormInputSetWithAction uiPublicationSelector = new UIFormInputSetWithAction(PUBLICATION);
            uiPublicationSelector.addUIFormInput((UIFormInput)new UIFormStringInput(PUBLICATION, PUBLICATION, null).setEditable(false));
            uiPublicationSelector.setActionInfo(PUBLICATION, new String[]{"BrowsePublication"});
            this.addChild((UIComponent)uiPublicationSelector);
        } else {
            for (String str : keySet) {
                WebpagePublicationPlugin publicationPlugin = (WebpagePublicationPlugin)publicationPluginMap.get(str);
                String lifecycleName = publicationPlugin.getLifecycleName();
                this.addChild((UIComponent)new UIFormStringInput(PUBLICATION, PUBLICATION, lifecycleName).setEditable(false));
            }
        }
    }

    private boolean isOnlyOnePublicationPlugin() {
        WCMPublicationService wcmService = (WCMPublicationService)this.getApplicationComponent(WCMPublicationService.class);
        Map publicationPluginMap = wcmService.getWebpagePublicationPlugins();
        Set keySet = publicationPluginMap.keySet();
        return keySet.size() <= 1;
    }

    public String getLivePortalPath() {
        return this.livePortalsPath;
    }

    public String getLiveSharedPortalName() {
        return this.liveSharedPortalName;
    }

    public String getRepositoryName() {
        return this.repository;
    }

    public String getWorkspace() {
        return this.workspace;
    }

    public void doSelect(String selectField, Object value) throws Exception {
        this.getUIStringInput(selectField).setValue((Object)((String)value));
        UIPortletConfig uiPortletConfig = (UIPortletConfig)this.getAncestorOfType(UIPortletConfig.class);
        UIPopupWindow uiPopup = (UIPopupWindow)uiPortletConfig.getChildById(UIPortletConfig.POPUP_DMS_SELECTOR);
        uiPopup.setShow(false);
    }

    public void showPopupComponent(UIComponent uiComponent) throws Exception {
        UIContainer uiParent = (UIContainer)this.getParent();
        if (uiComponent == null) {
            uiParent.removeChild(UIPopupWindow.class);
            return;
        }
        UIPopupWindow uiPopup = (UIPopupWindow)uiParent.getChild(UIPopupWindow.class);
        if (uiPopup == null) {
            uiPopup = (UIPopupWindow)uiParent.addChild(UIPopupWindow.class, null, null);
        }
        uiPopup.setUIComponent(uiComponent);
        uiPopup.setWindowSize(610, 300);
        uiPopup.setResizable(true);
        uiPopup.setShow(true);
    }
}

