/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.scv.config;

import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.jcr.Node;
import javax.jcr.Session;
import javax.jcr.nodetype.NodeType;
import javax.portlet.PortletPreferences;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.ecm.webui.form.validator.ECMNameValidator;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.webui.util.SessionProviderFactory;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.core.nodetype.ExtendedNodeTypeManager;
import org.exoplatform.wcm.webui.scv.UISingleContentViewerPortlet;
import org.exoplatform.wcm.webui.scv.config.UINameWebContentForm;
import org.exoplatform.wcm.webui.scv.config.UIPortletConfig;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.validator.MandatoryValidator;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/groovy/SingleContentViewer/config/UINameWebContentForm.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={AbortActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={ChangeTemplateTypeActionListener.class}, phase=Event.Phase.DECODE)})
public class UINameWebContentForm
extends UIForm {
    public static final String NAME_WEBCONTENT = "name".intern();
    public static final String SUMMARY_WEBCONTENT = "summary".intern();
    public static final String FIELD_SELECT = "selectTemplate".intern();
    private String pictureDescribe;

    public UINameWebContentForm() throws Exception {
        this.addUIFormInput((UIFormInput)new UIFormStringInput(NAME_WEBCONTENT, NAME_WEBCONTENT, null).addValidator(MandatoryValidator.class, new Object[0]).addValidator(ECMNameValidator.class, new Object[0]));
        this.setActions(new String[]{"Save", "Abort"});
    }

    public void init() throws Exception {
        TemplateService templateService = (TemplateService)this.getApplicationComponent(TemplateService.class);
        RepositoryService repositoryService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        String repositoryName = repositoryService.getCurrentRepository().getConfiguration().getName();
        ExtendedNodeTypeManager nodeTypeManager = repositoryService.getRepository(repositoryName).getNodeTypeManager();
        List documentTemplates = templateService.getDocumentTemplates(repositoryName);
        ArrayList<SelectItemOption> options = new ArrayList<SelectItemOption>();
        PortalRequestContext requestContext = Util.getPortalRequestContext();
        ResourceBundle resourceBundle = requestContext.getApplicationResourceBundle();
        for (String documentTemplate : documentTemplates) {
            String templateLabel;
            NodeType nodeType = nodeTypeManager.getNodeType(documentTemplate);
            if (!nodeType.isNodeType("exo:webContent")) continue;
            String contentType = nodeType.getName();
            String resolveLabel = templateLabel = StringUtils.deleteWhitespace((String)templateService.getTemplateLabel(contentType, repositoryName));
            try {
                resolveLabel = resourceBundle.getString("ContentType.lable." + templateLabel);
            }
            catch (Exception e) {
                // empty catch block
            }
            options.add(new SelectItemOption(resolveLabel, (Object)contentType));
        }
        UIFormSelectBox templateSelect = new UIFormSelectBox(FIELD_SELECT, FIELD_SELECT, options);
        templateSelect.setOnChange("ChangeTemplateType");
        templateSelect.setDefaultValue((Object)"exo:webContent");
        this.setPictureDescribe("exo_webContent");
        this.addUIFormInput((UIFormInput)templateSelect);
    }

    public void back() throws Exception {
        if (!this.isNewConfig()) {
            Node currentNode = this.getNode();
            UIFormStringInput uiFormStringInput = (UIFormStringInput)this.getChild(UIFormStringInput.class);
            uiFormStringInput.setValue((Object)currentNode.getName());
            uiFormStringInput.setEditable(false);
            return;
        }
        UIFormSelectBox templateSelect = (UIFormSelectBox)this.getChild(UIFormSelectBox.class);
        templateSelect.setOnChange("ChangeTemplateType");
        templateSelect.setDefaultValue((Object)"exo:webContent");
        this.setPictureDescribe("exo_webContent");
    }

    public Node getNode() throws Exception {
        PortletRequestContext context = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletPreferences prefs = context.getRequest().getPreferences();
        String repositoryName = prefs.getValue(UISingleContentViewerPortlet.REPOSITORY, null);
        String workspace = prefs.getValue(UISingleContentViewerPortlet.WORKSPACE, null);
        String UUID = prefs.getValue(UISingleContentViewerPortlet.IDENTIFIER, null);
        RepositoryService repositoryService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        ManageableRepository manageableRepository = repositoryService.getRepository(repositoryName);
        Session session = SessionProviderFactory.createSystemProvider().getSession(workspace, manageableRepository);
        return session.getNodeByUUID(UUID);
    }

    public boolean isNewConfig() {
        UIPortletConfig uiPortletConfig = (UIPortletConfig)this.getAncestorOfType(UIPortletConfig.class);
        return uiPortletConfig.isNewConfig();
    }

    public String getPictureDescribe() {
        return this.pictureDescribe;
    }

    public void setPictureDescribe(String pictureDescribe) {
        this.pictureDescribe = pictureDescribe;
    }
}

