/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.scv.config;

import javax.jcr.Node;
import javax.portlet.PortletPreferences;
import org.exoplatform.portal.webui.portal.UIPortal;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIMaskWorkspace;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;
import org.exoplatform.wcm.webui.Utils;
import org.exoplatform.wcm.webui.WebUIPropertiesConfigService;
import org.exoplatform.wcm.webui.scv.UISingleContentViewerPortlet;
import org.exoplatform.wcm.webui.scv.config.UIDMSSelectorForm;
import org.exoplatform.wcm.webui.scv.config.UINonEditable;
import org.exoplatform.wcm.webui.scv.config.UIWebContentSelectorForm;
import org.exoplatform.wcm.webui.scv.config.UIWelcomeScreen;
import org.exoplatform.wcm.webui.scv.config.quickedition.UIQuickEditContainer;
import org.exoplatform.wcm.webui.selector.document.UIDocumentPathSelector;
import org.exoplatform.wcm.webui.selector.webcontent.UIWebContentPathSelector;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.UIPopupContainer;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.lifecycle.UIContainerLifecycle;

@ComponentConfig(lifecycle=UIContainerLifecycle.class)
public class UIPortletConfig
extends UIContainer
implements UIPopupComponent {
    private UIComponent uiBackComponent;
    private boolean isNewConfig;
    static final String POPUP_WEBCONTENT_SELECTOR = "PopupWebContentSelector".intern();
    static final String POPUP_DMS_SELECTOR = "PopupDMSSelector".intern();

    public void init() throws Exception {
        block5: {
            this.isNewConfig = this.checkNewConfig();
            UISingleContentViewerPortlet uiPresentationPortlet = (UISingleContentViewerPortlet)this.getAncestorOfType(UISingleContentViewerPortlet.class);
            if (!uiPresentationPortlet.canEditPortlet()) {
                this.addChild(UINonEditable.class, null, null);
                return;
            }
            if (Utils.isEditPortletInCreatePageWizard()) {
                this.addUIWelcomeScreen();
                return;
            }
            try {
                Node node = uiPresentationPortlet.getReferencedContent();
                if (uiPresentationPortlet.canEditContent(node)) {
                    this.addChild(UIQuickEditContainer.class, null, null);
                    return;
                }
            }
            catch (Exception e) {
                if (!UISingleContentViewerPortlet.scvLog.isDebugEnabled()) break block5;
                UISingleContentViewerPortlet.scvLog.debug((Object)e);
            }
        }
        this.addUIWelcomeScreen();
    }

    public void addUIWelcomeScreen() throws Exception {
        UIWelcomeScreen uiWellcomeScreen = (UIWelcomeScreen)this.addChild(UIWelcomeScreen.class, null, null);
        uiWellcomeScreen.setCreateMode(this.checkNewConfig());
        this.uiBackComponent = uiWellcomeScreen;
    }

    public boolean isQuickEditable() throws Exception {
        PortletRequestContext portletRequestContext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletPreferences prefs = portletRequestContext.getRequest().getPreferences();
        boolean isQuickEdit = Boolean.parseBoolean(prefs.getValue("ShowQuickEdit", null));
        UISingleContentViewerPortlet uiPresentationPortlet = (UISingleContentViewerPortlet)this.getAncestorOfType(UISingleContentViewerPortlet.class);
        if (isQuickEdit) {
            return uiPresentationPortlet.canEditPortlet();
        }
        return false;
    }

    private boolean checkNewConfig() {
        UISingleContentViewerPortlet uiportlet = (UISingleContentViewerPortlet)this.getAncestorOfType(UISingleContentViewerPortlet.class);
        try {
            uiportlet.getReferencedContent();
            return false;
        }
        catch (Exception e) {
            if (UISingleContentViewerPortlet.scvLog.isDebugEnabled()) {
                UISingleContentViewerPortlet.scvLog.debug((Object)e);
            }
            return true;
        }
    }

    public UIComponent getBackComponent() {
        this.uiBackComponent.setRendered(true);
        return this.uiBackComponent;
    }

    public void setBackComponent(UIComponent uicomponent) {
        this.uiBackComponent = uicomponent;
    }

    public void setNewConfig(boolean newConfig) {
        this.isNewConfig = newConfig;
    }

    public boolean isNewConfig() {
        return this.isNewConfig;
    }

    public boolean isEditPortletInCreatePageWizard() {
        UIPortal uiPortal = Util.getUIPortal();
        UIPortalApplication uiApp = (UIPortalApplication)uiPortal.getAncestorOfType(UIPortalApplication.class);
        UIMaskWorkspace uiMaskWS = (UIMaskWorkspace)uiApp.getChildById("UIMaskWorkspace");
        return uiMaskWS.getWindowWidth() > 0 && uiMaskWS.getWindowHeight() < 0;
    }

    public void closePopupAndUpdateUI(WebuiRequestContext requestContext, boolean isUpdate) throws Exception {
        UISingleContentViewerPortlet uiPresentationPortlet = (UISingleContentViewerPortlet)this.getAncestorOfType(UISingleContentViewerPortlet.class);
        UIPopupContainer popupAction = (UIPopupContainer)uiPresentationPortlet.getChild(UIPopupContainer.class);
        popupAction.deActivate();
        requestContext.addUIComponentToUpdateByAjax((UIComponent)popupAction);
        if (isUpdate && !this.isEditPortletInCreatePageWizard()) {
            this.getChildren().clear();
            Utils.refreshBrowser((PortletRequestContext)((PortletRequestContext)requestContext));
        }
    }

    public void showPopup(WebuiRequestContext requestContext) throws Exception {
        UISingleContentViewerPortlet viewerPortlet = (UISingleContentViewerPortlet)this.getAncestorOfType(UISingleContentViewerPortlet.class);
        UIPopupContainer popupContainer = (UIPopupContainer)viewerPortlet.getChild(UIPopupContainer.class);
        WebUIPropertiesConfigService propertiesConfigService = (WebUIPropertiesConfigService)this.getApplicationComponent(WebUIPropertiesConfigService.class);
        WebUIPropertiesConfigService.PopupWindowProperties properties = null;
        properties = Utils.isEditPortletInCreatePageWizard() ? (WebUIPropertiesConfigService.PopupWindowProperties)propertiesConfigService.getProperties(WebUIPropertiesConfigService.SCV_POPUP_SIZE_EDIT_PORTLET_MODE) : (WebUIPropertiesConfigService.PopupWindowProperties)propertiesConfigService.getProperties(WebUIPropertiesConfigService.SCV_POPUP_SIZE_QUICK_EDIT);
        popupContainer.activate((UIComponent)this, properties.getWidth(), properties.getHeight());
        requestContext.addUIComponentToUpdateByAjax((UIComponent)popupContainer);
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    public void initPopupWebContentSelector() throws Exception {
        UIPopupWindow uiPopup = (UIPopupWindow)this.getChildById(POPUP_WEBCONTENT_SELECTOR);
        if (uiPopup == null) {
            uiPopup = (UIPopupWindow)this.addChild(UIPopupWindow.class, null, POPUP_WEBCONTENT_SELECTOR);
        }
        UIWebContentPathSelector webContentPathSelector = (UIWebContentPathSelector)this.createUIComponent(UIWebContentPathSelector.class, null, null);
        UIWebContentSelectorForm uiWebContentSelector = (UIWebContentSelectorForm)this.getChild(UIWebContentSelectorForm.class);
        webContentPathSelector.setSourceComponent((UIComponent)uiWebContentSelector, new String[]{UIWebContentSelectorForm.PATH});
        uiPopup.setUIComponent((UIComponent)webContentPathSelector);
        webContentPathSelector.init();
        uiPopup.setWindowSize(600, 400);
        uiPopup.setShow(true);
    }

    public void initPopupDMSSelector() throws Exception {
        UIPopupWindow uiPopup = (UIPopupWindow)this.getChildById(POPUP_DMS_SELECTOR);
        if (uiPopup == null) {
            uiPopup = (UIPopupWindow)this.addChild(UIPopupWindow.class, null, POPUP_DMS_SELECTOR);
        }
        UIDocumentPathSelector dmsSelector = (UIDocumentPathSelector)this.createUIComponent(UIDocumentPathSelector.class, null, null);
        UIDMSSelectorForm dmsSelectorForm = (UIDMSSelectorForm)this.getChild(UIDMSSelectorForm.class);
        dmsSelector.setSourceComponent((UIComponent)dmsSelectorForm, new String[]{UIDMSSelectorForm.PATH});
        uiPopup.setUIComponent((UIComponent)dmsSelector);
        dmsSelector.init();
        uiPopup.setWindowSize(600, 400);
        uiPopup.setShow(true);
    }
}

