/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.scv.config.access;

import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.jcr.Node;
import org.exoplatform.commons.utils.ObjectPageList;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.services.jcr.access.AccessControlEntry;
import org.exoplatform.services.jcr.access.PermissionType;
import org.exoplatform.services.jcr.access.SystemIdentity;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.wcm.webui.scv.config.UIContentDialogForm;
import org.exoplatform.wcm.webui.scv.config.UIQuickCreationWizard;
import org.exoplatform.wcm.webui.scv.config.access.UIPermissionInfo;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIGrid;
import org.exoplatform.webui.core.lifecycle.UIContainerLifecycle;

@ComponentConfig(lifecycle=UIContainerLifecycle.class, events={@EventConfig(listeners={DeleteActionListener.class}, confirm="UIPermissionInfo.msg.confirm-delete-permission"), @EventConfig(listeners={EditActionListener.class})})
public class UIPermissionInfo
extends UIContainer {
    public static String[] PERMISSION_FIELD = new String[]{"usersOrGroups", "accessible", "editable"};
    private static String[] PERMISSION_ACTION = new String[]{"Edit", "Delete"};

    public UIPermissionInfo() throws Exception {
        UIGrid uiGrid = (UIGrid)this.createUIComponent(UIGrid.class, null, "PermissionInfo");
        uiGrid.getUIPageIterator().setId("PermissionInfoIterator");
        uiGrid.configure("usersOrGroups", PERMISSION_FIELD, PERMISSION_ACTION);
        this.addChild((UIComponent)uiGrid);
    }

    public String getNodeOwner(Node node) throws Exception {
        return node.getProperty("exo:owner").getString();
    }

    private Node getCurrentWebContent() {
        UIQuickCreationWizard quickCreationWizard = (UIQuickCreationWizard)this.getAncestorOfType(UIQuickCreationWizard.class);
        UIContentDialogForm contentDialogForm = (UIContentDialogForm)quickCreationWizard.getChild(UIContentDialogForm.class);
        return contentDialogForm.getWebContent();
    }

    private boolean hasChangePermissionRight(ExtendedNode node) throws Exception {
        try {
            node.checkPermission("add_node");
            node.checkPermission("remove");
            node.checkPermission("set_property");
            return true;
        }
        catch (AccessControlException e) {
            return false;
        }
    }

    public void updateGrid() throws Exception {
        Node node = this.getCurrentWebContent();
        ExtendedNode webContent = (ExtendedNode)node;
        ArrayList<PermissionBean> permissionBeans = new ArrayList<PermissionBean>();
        List permissionList = webContent.getACL().getPermissionEntries();
        HashMap permissionMap = new HashMap();
        for (AccessControlEntry accessControlEntry : permissionList) {
            String currentIdentity = accessControlEntry.getIdentity();
            String currentPermission = accessControlEntry.getPermission();
            ArrayList<String> currentPermissionsList = (ArrayList<String>)permissionMap.get(currentIdentity);
            if (!permissionMap.containsKey(currentIdentity)) {
                permissionMap.put(currentIdentity, null);
            }
            if (currentPermissionsList == null) {
                currentPermissionsList = new ArrayList<String>();
            }
            if (!currentPermissionsList.contains(currentPermission)) {
                currentPermissionsList.add(currentPermission);
            }
            permissionMap.put(currentIdentity, currentPermissionsList);
        }
        Set keys = permissionMap.keySet();
        Iterator keysIter = keys.iterator();
        String owner = SystemIdentity.SYSTEM;
        if (this.getNodeOwner(node) != null) {
            owner = this.getNodeOwner(node);
        }
        PermissionBean permOwnerBean = new PermissionBean(this);
        if (!permissionMap.containsKey(owner)) {
            permOwnerBean.setUsersOrGroups(owner);
            permOwnerBean.setAccessible(true);
            permOwnerBean.setEditable(true);
            permissionBeans.add(permOwnerBean);
        }
        while (keysIter.hasNext()) {
            String userOrGroup = (String)keysIter.next();
            List permissions = (List)permissionMap.get(userOrGroup);
            PermissionBean permBean = new PermissionBean(this);
            permBean.setUsersOrGroups(userOrGroup);
            int numberPermission = 0;
            for (String p : PermissionType.ALL) {
                if (!permissions.contains(p)) break;
                ++numberPermission;
            }
            if (numberPermission == PermissionType.ALL.length) {
                permBean.setEditable(true);
                permBean.setAccessible(true);
            } else {
                permBean.setAccessible(true);
            }
            permissionBeans.add(permBean);
        }
        UIGrid uiGrid = (UIGrid)this.findFirstComponentOfType(UIGrid.class);
        ObjectPageList objPageList = new ObjectPageList(permissionBeans, 10);
        uiGrid.getUIPageIterator().setPageList((PageList)objPageList);
    }

    static /* synthetic */ Node access$000(UIPermissionInfo x0) {
        return x0.getCurrentWebContent();
    }

    static /* synthetic */ boolean access$100(UIPermissionInfo x0, ExtendedNode x1) throws Exception {
        return x0.hasChangePermissionRight(x1);
    }
}

