/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.scv.config.publication;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.exoplatform.commons.utils.ObjectPageList;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.services.wcm.publication.WCMPublicationService;
import org.exoplatform.services.wcm.publication.WebpagePublicationPlugin;
import org.exoplatform.wcm.webui.scv.config.publication.UIWCMPublicationGrid;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIGrid;

@ComponentConfig(template="app:/groovy/SingleContentViewer/config/UIWCMPublicationGrid.gtmpl", events={@EventConfig(listeners={SelectActionListener.class})})
public class UIWCMPublicationGrid
extends UIGrid {
    public static final String LIFECYCLE_NAME = "LifecycleName".intern();
    public static final String LIFECYCLE_DESC = "LifecycleDesc".intern();
    private String[] LIFECYCLE_FIELDS = new String[]{LIFECYCLE_NAME, LIFECYCLE_DESC};
    private String[] LIFECYCLE_ACTIONS = new String[]{"Select"};
    private String lifecycleNameSelected;
    private boolean isViewGrid;
    private UIComponent sourceComponent;

    public UIWCMPublicationGrid() throws Exception {
        this.configure(LIFECYCLE_NAME, this.LIFECYCLE_FIELDS, this.LIFECYCLE_ACTIONS);
        this.getUIPageIterator().setId("WCMPublicationIterator");
    }

    public void updateGrid() {
        Iterator i$;
        WCMPublicationService wcmPublicationService = (WCMPublicationService)this.getApplicationComponent(WCMPublicationService.class);
        Map publicationPlugins = wcmPublicationService.getWebpagePublicationPlugins();
        ArrayList<LifecycleBean> lifecycleBeanList = new ArrayList<LifecycleBean>();
        Set keySet = publicationPlugins.keySet();
        if (keySet.size() == 1 && (i$ = keySet.iterator()).hasNext()) {
            String str = (String)i$.next();
            this.lifecycleNameSelected = ((WebpagePublicationPlugin)publicationPlugins.get(str)).getLifecycleName();
            return;
        }
        this.isViewGrid = true;
        for (String key : keySet) {
            WebpagePublicationPlugin webPublicationPlugin = (WebpagePublicationPlugin)publicationPlugins.get(key);
            LifecycleBean lifecycleBean = new LifecycleBean();
            lifecycleBean.setLifecycleName(webPublicationPlugin.getLifecycleName());
            lifecycleBean.setLifecycleDesc(webPublicationPlugin.getDescription());
            lifecycleBeanList.add(lifecycleBean);
        }
        ObjectPageList objectPageList = new ObjectPageList(lifecycleBeanList, 10);
        this.getUIPageIterator().setPageList((PageList)objectPageList);
    }

    public String getLifecycleNameSelected() {
        return this.lifecycleNameSelected;
    }

    public boolean isViewGrid() {
        return this.isViewGrid;
    }

    public void setLifecycleNameSelected(String lifecycleNameSelected) {
        this.lifecycleNameSelected = lifecycleNameSelected;
    }

    public UIComponent getSourceComponent() {
        return this.sourceComponent;
    }

    public void setSourceComponent(UIComponent sourceComponent) {
        this.sourceComponent = sourceComponent;
    }
}

