/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.scv.config.quickedition;

import javax.jcr.Node;
import javax.jcr.Session;
import javax.portlet.PortletPreferences;
import org.exoplatform.ecm.webui.form.DialogFormActionListeners;
import org.exoplatform.ecm.webui.utils.LockUtil;
import org.exoplatform.portal.webui.util.SessionProviderFactory;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.wcm.webui.scv.UISingleContentViewerPortlet;
import org.exoplatform.wcm.webui.scv.config.UIContentDialogForm;
import org.exoplatform.wcm.webui.scv.config.quickedition.UIQuickEditWebContentForm;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;

@ComponentConfig(lifecycle=UIFormLifecycle.class, events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={CancelActionListener.class}), @EventConfig(listeners={DialogFormActionListeners.RemoveDataActionListener.class})})
public class UIQuickEditWebContentForm
extends UIContentDialogForm {
    public UIQuickEditWebContentForm() throws Exception {
        this.setActions(ACTIONS);
    }

    public void init() throws Exception {
        PortletRequestContext pContext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletPreferences prefs = pContext.getRequest().getPreferences();
        String repositoryName = prefs.getValue(UISingleContentViewerPortlet.REPOSITORY, null);
        String workspaceName = prefs.getValue(UISingleContentViewerPortlet.WORKSPACE, null);
        String nodeIdentifier = prefs.getValue(UISingleContentViewerPortlet.IDENTIFIER, null);
        RepositoryService repositoryService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        ManageableRepository manageableRepository = repositoryService.getRepository(repositoryName);
        Session session = SessionProviderFactory.createSystemProvider().getSession(workspaceName, manageableRepository);
        Node webContentNode = null;
        try {
            webContentNode = session.getNodeByUUID(nodeIdentifier);
        }
        catch (Exception e) {
            webContentNode = (Node)session.getItem(nodeIdentifier);
        }
        NodeLocation nodeLocation = new NodeLocation();
        nodeLocation.setRepository(repositoryName);
        nodeLocation.setWorkspace(workspaceName);
        nodeLocation.setPath(webContentNode.getParent().getPath());
        this.setStoredLocation(nodeLocation);
        this.setNodePath(webContentNode.getPath());
        this.setContentType(webContentNode.getPrimaryNodeType().getName());
        this.addNew(false);
        this.resetProperties();
    }

    private Node getParentNode() throws Exception {
        String repository = this.storedLocation.getRepository();
        String path = this.storedLocation.getPath();
        String workspace = this.storedLocation.getWorkspace();
        RepositoryService repositoryService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        ManageableRepository manageableRepository = repositoryService.getRepository(repository);
        SessionProvider provider = SessionProviderFactory.createSessionProvider();
        Session session = provider.getSession(workspace, manageableRepository);
        Node parentNode = (Node)session.getItem(path);
        return parentNode;
    }

    private boolean nodeIsLocked(Node node) throws Exception {
        if (!node.isLocked()) {
            return false;
        }
        String lockToken = LockUtil.getLockToken((Node)node);
        if (lockToken != null) {
            node.getSession().addLockToken(lockToken);
            return false;
        }
        return true;
    }

    static /* synthetic */ boolean access$000(UIQuickEditWebContentForm x0, Node x1) throws Exception {
        return x0.nodeIsLocked(x1);
    }

    static /* synthetic */ Node access$100(UIQuickEditWebContentForm x0) throws Exception {
        return x0.getParentNode();
    }

    static /* synthetic */ String access$200(UIQuickEditWebContentForm x0) {
        return x0.contentType;
    }

    static /* synthetic */ boolean access$300(UIQuickEditWebContentForm x0) {
        return x0.isAddNew;
    }

    static /* synthetic */ String access$400(UIQuickEditWebContentForm x0) {
        return x0.repositoryName;
    }

    static /* synthetic */ void access$500(UIQuickEditWebContentForm x0, Node x1) {
        x0.setWebContent(x1);
    }
}

