/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.search.config;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.portlet.PortletPreferences;
import org.exoplatform.portal.webui.util.SessionProviderFactory;
import org.exoplatform.services.cms.views.ApplicationTemplateManagerService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.wcm.webui.search.UIWCMSearchPortlet;
import org.exoplatform.wcm.webui.search.config.UISearchPageLayoutManager;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormSelectBox;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/groovy/webui/wcm-search/config/UISearchPageLayoutManager.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={CancelActionListener.class}), @EventConfig(listeners={SelectSearchModeActionListener.class})})
public class UISearchPageLayoutManager
extends UIForm {
    public static final String PORTLET_NAME = "WCM Advance Search".intern();
    public static final String SEARCH_PAGE_LAYOUT_CATEGORY = "search-page-layout".intern();
    public static final String SEARCH_PAGE_LAYOUT_SELECTOR = "searchPageLayoutSelector".intern();
    public static final String SEARCH_FORM_TEMPLATE_CATEGORY = "search-form".intern();
    public static final String SEARCH_PAGINATOR_TEMPLATE_CATEGORY = "search-paginator";
    public static final String SEARCH_RESULT_TEMPLATE_CATEGORY = "search-result";
    public static final String SEARCH_FORM_TEMPLATE_SELECTOR = "searchFormSelector";
    public static final String SEARCH_PAGINATOR_TEMPLATE_SELECTOR = "searchPaginatorSelector";
    public static final String SEARCH_RESULT_TEMPLATE_SELECTOR = "searchResultSelector";
    public static final String SEARCH_BOX_TEMPLATE_CATEGORY = "search-box";
    public static final String SEARCH_BOX_TEMPLATE_SELECTOR = "searchBoxSelector";
    public static final String SEARCH_MODE_SELECTOR = "searchModeSelector";
    public static final String SEARCH_BOX_MODE_OPTION = "searchBoxMode";
    public static final String SEARCH_PAGE_MODE_OPTION = "searchPageMode";
    public static final String SEARCH_MODES_OPTION = "searchModes";
    public static final String ITEMS_PER_PAGE_SELECTOR = "itemsPerPageSelector";
    public static final String VIEWER_BUTTON_QUICK_EDIT = "viewerButtonQuickEdit";

    public UISearchPageLayoutManager() throws Exception {
        PortletRequestContext portletRequestContext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletPreferences portletPreferences = portletRequestContext.getRequest().getPreferences();
        String quickEditAble = portletPreferences.getValue("showQuickEditButton", null);
        String itemsPerpage = portletPreferences.getValue("itemsPerPage", null);
        String searchFormTemplate = portletPreferences.getValue(UIWCMSearchPortlet.SEARCH_FORM_TEMPLATE_PATH, null);
        String searchResultTemplate = portletPreferences.getValue(UIWCMSearchPortlet.SEARCH_RESULT_TEMPLATE_PATH, null);
        String searchPaginatorTemplate = portletPreferences.getValue(UIWCMSearchPortlet.SEARCH_PAGINATOR_TEMPLATE_PATH, null);
        String searchPageLayoutTemplate = portletPreferences.getValue(UIWCMSearchPortlet.SEARCH_PAGE_LAYOUT_TEMPLATE_PATH, null);
        String searchBoxTemplate = portletPreferences.getValue(UIWCMSearchPortlet.SEARCH_BOX_TEMPLATE_PATH, null);
        String searchMode = portletPreferences.getValue("searchMode", null);
        List searchModeList = this.createSearchModeList();
        List searchFormTemplateList = this.createTemplateList(PORTLET_NAME, SEARCH_FORM_TEMPLATE_CATEGORY);
        List searchResultTemplateList = this.createTemplateList(PORTLET_NAME, SEARCH_RESULT_TEMPLATE_CATEGORY);
        List searchPaginatorTemplateList = this.createTemplateList(PORTLET_NAME, SEARCH_PAGINATOR_TEMPLATE_CATEGORY);
        List searchBoxTemplateList = this.createTemplateList(PORTLET_NAME, SEARCH_BOX_TEMPLATE_CATEGORY);
        List searchPageLayoutTemplateList = this.createTemplateList(PORTLET_NAME, SEARCH_PAGE_LAYOUT_CATEGORY);
        ArrayList<SelectItemOption> itemsPerPageList = new ArrayList<SelectItemOption>();
        itemsPerPageList.add(new SelectItemOption("5", (Object)"5"));
        itemsPerPageList.add(new SelectItemOption("10", (Object)"10"));
        itemsPerPageList.add(new SelectItemOption("20", (Object)"20"));
        UIFormSelectBox searchModeSelector = new UIFormSelectBox(SEARCH_MODE_SELECTOR, SEARCH_MODE_SELECTOR, searchModeList);
        UIFormSelectBox itemsPerPageSelector = new UIFormSelectBox(ITEMS_PER_PAGE_SELECTOR, ITEMS_PER_PAGE_SELECTOR, itemsPerPageList);
        UIFormSelectBox searchFormTemplateSelector = (UIFormSelectBox)new UIFormSelectBox(SEARCH_FORM_TEMPLATE_SELECTOR, SEARCH_FORM_TEMPLATE_SELECTOR, searchFormTemplateList).setRendered(false);
        UIFormSelectBox searchResultTemplateSelector = (UIFormSelectBox)new UIFormSelectBox(SEARCH_RESULT_TEMPLATE_SELECTOR, SEARCH_RESULT_TEMPLATE_SELECTOR, searchResultTemplateList).setRendered(false);
        UIFormSelectBox searchPaginatorTemplateSelector = (UIFormSelectBox)new UIFormSelectBox(SEARCH_PAGINATOR_TEMPLATE_SELECTOR, SEARCH_PAGINATOR_TEMPLATE_SELECTOR, searchPaginatorTemplateList).setRendered(false);
        UIFormSelectBox searchPageLayoutTemplateSelector = (UIFormSelectBox)new UIFormSelectBox(SEARCH_PAGE_LAYOUT_SELECTOR, SEARCH_PAGE_LAYOUT_SELECTOR, searchPageLayoutTemplateList).setRendered(false);
        UIFormSelectBox searchBoxTemplateSelector = (UIFormSelectBox)new UIFormSelectBox(SEARCH_BOX_TEMPLATE_SELECTOR, SEARCH_BOX_TEMPLATE_SELECTOR, searchBoxTemplateList).setRendered(false);
        UIFormCheckBoxInput viewerButtonQuickEditCheckbox = new UIFormCheckBoxInput(VIEWER_BUTTON_QUICK_EDIT, VIEWER_BUTTON_QUICK_EDIT, null);
        searchModeSelector.setOnChange("SelectSearchMode");
        itemsPerPageSelector.setValue(itemsPerpage);
        searchBoxTemplateSelector.setValue(searchBoxTemplate);
        searchFormTemplateSelector.setValue(searchFormTemplate);
        searchResultTemplateSelector.setValue(searchResultTemplate);
        searchPaginatorTemplateSelector.setValue(searchPaginatorTemplate);
        searchPageLayoutTemplateSelector.setValue(searchPageLayoutTemplate);
        viewerButtonQuickEditCheckbox.setChecked(Boolean.parseBoolean(quickEditAble));
        searchModeSelector.setValue(searchMode);
        this.addUIFormInput((UIFormInput)searchModeSelector);
        this.addUIFormInput((UIFormInput)itemsPerPageSelector);
        this.addUIFormInput((UIFormInput)searchBoxTemplateSelector);
        this.addUIFormInput((UIFormInput)searchFormTemplateSelector);
        this.addUIFormInput((UIFormInput)searchResultTemplateSelector);
        this.addUIFormInput((UIFormInput)searchPaginatorTemplateSelector);
        this.addUIFormInput((UIFormInput)searchPageLayoutTemplateSelector);
        this.addChild((UIComponent)viewerButtonQuickEditCheckbox);
        if (SEARCH_BOX_MODE_OPTION.equals(searchMode)) {
            searchBoxTemplateSelector.setRendered(true);
            searchFormTemplateSelector.setRendered(false);
            searchPaginatorTemplateSelector.setRendered(false);
            searchResultTemplateSelector.setRendered(false);
            searchPageLayoutTemplateSelector.setRendered(false);
        } else if (SEARCH_PAGE_MODE_OPTION.equals(searchMode)) {
            searchBoxTemplateSelector.setRendered(false);
            searchFormTemplateSelector.setRendered(true);
            searchPaginatorTemplateSelector.setRendered(true);
            searchResultTemplateSelector.setRendered(true);
            searchPageLayoutTemplateSelector.setRendered(true);
            searchModeSelector.setValue(searchMode);
        }
        this.setActions(new String[]{"Save", "Cancel"});
    }

    private List<SelectItemOption<String>> createTemplateList(String portletName, String category) throws Exception {
        ArrayList<SelectItemOption<String>> templateList = new ArrayList<SelectItemOption<String>>();
        ApplicationTemplateManagerService templateManagerService = (ApplicationTemplateManagerService)this.getApplicationComponent(ApplicationTemplateManagerService.class);
        SessionProvider provider = SessionProviderFactory.createSessionProvider();
        RepositoryService repositoryService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        ManageableRepository manageableRepository = repositoryService.getCurrentRepository();
        String repository = manageableRepository.getConfiguration().getName();
        List templateNodeList = templateManagerService.getTemplatesByCategory(repository, portletName, category, provider);
        for (Node templateNode : templateNodeList) {
            String templateName = templateNode.getName();
            String templatePath = templateNode.getPath();
            templateList.add((SelectItemOption<String>)new SelectItemOption(templateName, (Object)templatePath));
        }
        return templateList;
    }

    private List<SelectItemOption<String>> createSearchModeList() throws Exception {
        PortletRequestContext portletRequestContext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        ArrayList<SelectItemOption<String>> searchModesList = new ArrayList<SelectItemOption<String>>();
        String modesLabel = portletRequestContext.getApplicationResourceBundle().getString("UISearchPageLayoutManager.mode.selectOption.label");
        String boxModeLabel = portletRequestContext.getApplicationResourceBundle().getString("UISearchPageLayoutManager.mode.box-search.label");
        String pageModeLabel = portletRequestContext.getApplicationResourceBundle().getString("UISearchPageLayoutManager.mode.page-search.label");
        searchModesList.add(new SelectItemOption(modesLabel, (Object)SEARCH_MODES_OPTION));
        searchModesList.add(new SelectItemOption(boxModeLabel, (Object)SEARCH_BOX_MODE_OPTION));
        searchModesList.add(new SelectItemOption(pageModeLabel, (Object)SEARCH_PAGE_MODE_OPTION));
        return searchModesList;
    }
}

