/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.paginator;

import javax.faces.lifecycle.Lifecycle;
import org.exoplatform.resolver.ResourceResolver;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPageIterator;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

@ComponentConfig(lifecycle=Lifecycle.class, events={@EventConfig(listeners={ShowPageActionListener.class})})
public class UICustomizeablePaginator
extends UIPageIterator {
    private String templatePath;
    private ResourceResolver resourceResolver;

    public int getTotalPages() {
        return this.getPageList().getAvailablePage();
    }

    public int getTotalItems() {
        return this.getPageList().getAvailable();
    }

    public int getItemPerPage() {
        return this.getPageList().getPageSize();
    }

    public void init(ResourceResolver resourceResolver, String templatePath) {
        this.resourceResolver = resourceResolver;
        this.templatePath = templatePath;
    }

    public void setTemplatePath(String path) {
        this.templatePath = path;
    }

    public void setResourceResolver(ResourceResolver resolver) {
        this.resourceResolver = resolver;
    }

    public String getTemplate() {
        if (this.templatePath != null) {
            return this.templatePath;
        }
        return super.getTemplate();
    }

    public ResourceResolver getTemplateResourceResolver(WebuiRequestContext context, String template) {
        if (this.resourceResolver != null) {
            return this.resourceResolver;
        }
        return super.getTemplateResourceResolver(context, template);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ShowPageActionListener
    extends EventListener<UICustomizeablePaginator> {
        public void execute(Event<UICustomizeablePaginator> event) throws Exception {
            UICustomizeablePaginator uiPaginator = (UICustomizeablePaginator)((Object)event.getSource());
            int page = Integer.parseInt(event.getRequestContext().getRequestParameter("objectId"));
            uiPaginator.setCurrentPage(page);
            UIComponent parent = uiPaginator.getParent();
            if (parent == null) {
                return;
            }
            event.getRequestContext().addUIComponentToUpdateByAjax(parent);
            parent.broadcast(event, event.getExecutionPhase());
        }
    }
}

