/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.selector.document;

import java.util.List;
import javax.jcr.Node;
import org.exoplatform.ecm.webui.tree.UIBaseNodeTreeSelector;
import org.exoplatform.ecm.webui.tree.selectone.UISelectPathPanel;
import org.exoplatform.portal.webui.util.SessionProviderFactory;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.wcm.portal.LivePortalManagerService;
import org.exoplatform.wcm.webui.selector.document.UIDocumentTreeBuilder;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.lifecycle.UIContainerLifecycle;

@ComponentConfig(lifecycle=UIContainerLifecycle.class)
public class UIDocumentPathSelector
extends UIBaseNodeTreeSelector
implements UIPopupComponent {
    public UIDocumentPathSelector() throws Exception {
        this.addChild(UIDocumentTreeBuilder.class, null, UIDocumentTreeBuilder.class.getSimpleName() + ((Object)((Object)this)).hashCode());
        this.addChild(UISelectPathPanel.class, null, UISelectPathPanel.class.getSimpleName() + ((Object)((Object)this)).hashCode());
    }

    public void init() throws Exception {
        LivePortalManagerService livePortalManagerService = (LivePortalManagerService)this.getApplicationComponent(LivePortalManagerService.class);
        String currentPortalName = Util.getUIPortal().getName();
        SessionProvider sessionProvider = SessionProviderFactory.createSessionProvider();
        Node currentPortal = livePortalManagerService.getLivePortal(currentPortalName, sessionProvider);
        Node sharedPortal = livePortalManagerService.getLiveSharedPortal(sessionProvider);
        String repositoryName = ((ManageableRepository)currentPortal.getSession().getRepository()).getConfiguration().getName();
        TemplateService templateService = (TemplateService)this.getApplicationComponent(TemplateService.class);
        List acceptedNodeTypes = templateService.getDocumentTemplates(repositoryName);
        UISelectPathPanel uiSelectPathPanel = (UISelectPathPanel)this.getChild(UISelectPathPanel.class);
        String[] arrAcceptedNodeTypes = new String[acceptedNodeTypes.size()];
        acceptedNodeTypes.toArray(arrAcceptedNodeTypes);
        uiSelectPathPanel.setAcceptedNodeTypes(arrAcceptedNodeTypes);
        UIDocumentTreeBuilder treeBuilder = (UIDocumentTreeBuilder)this.getChild(UIDocumentTreeBuilder.class);
        treeBuilder.setCurrentPortal(currentPortal);
        treeBuilder.setSharedPortal(sharedPortal);
        treeBuilder.setRootTreeNode(currentPortal.getParent());
        sessionProvider.close();
    }

    public void onChange(Node node, Object context) throws Exception {
        UISelectPathPanel uiSelectPathPanel = (UISelectPathPanel)this.getChild(UISelectPathPanel.class);
        uiSelectPathPanel.setParentNode(node);
        uiSelectPathPanel.updateGrid();
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }
}

