/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webos.webui.page;

import java.util.ArrayList;
import java.util.concurrent.CopyOnWriteArrayList;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.Properties;
import org.exoplatform.portal.webui.application.UIApplication;
import org.exoplatform.portal.webui.application.UIPortlet;
import org.exoplatform.portal.webui.page.UIPage;
import org.exoplatform.portal.webui.page.UIPageActionListener;
import org.exoplatform.portal.webui.page.UIPageLifecycle;
import org.exoplatform.portal.webui.util.PortalDataMapper;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIMaskWorkspace;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;
import org.exoplatform.web.application.JavascriptManager;
import org.exoplatform.web.controller.QualifiedName;
import org.exoplatform.webos.services.desktop.DesktopBackground;
import org.exoplatform.webos.services.desktop.DesktopBackgroundService;
import org.exoplatform.webos.webui.page.UIAddNewApplication;
import org.exoplatform.webos.webui.page.UIBackgroundSelector;
import org.exoplatform.webos.webui.page.UIDesktopPageForm;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.ComponentConfigs;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIRightClickPopupMenu;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

@ComponentConfigs(value={@ComponentConfig(lifecycle=UIPageLifecycle.class, template="system:/groovy/portal/webui/page/UIDesktopPage.gtmpl", events={@EventConfig(listeners={UIPageActionListener.DeleteGadgetActionListener.class}), @EventConfig(name="RemoveChild", listeners={RemovePortletActionListener.class}), @EventConfig(listeners={SaveWindowPropertiesActionListener.class}), @EventConfig(listeners={ShowAddNewApplicationActionListener.class}), @EventConfig(listeners={ShowPortletActionListener.class}), @EventConfig(name="EditCurrentPage", listeners={EditCurrentPageActionListener.class})}), @ComponentConfig(id="UIDesktopContextMenu", type=UIRightClickPopupMenu.class, template="system:/groovy/portal/webui/page/UIDesktopContextMenu.gtmpl", events={@EventConfig(listeners={ShowAddNewApplicationActionListener.class}), @EventConfig(listeners={RefreshPageActionListener.class}), @EventConfig(listeners={EditCurrentPageActionListener.class}), @EventConfig(listeners={ChangeBackgroundActionListener.class})})})
public final class UIDesktopPage
extends UIPage {
    public static String DESKTOP_FACTORY_ID = "Desktop";
    public static final String PAGE_ID = "webos";
    public static final String PAGE_TITLE = "WebOS Page";
    public static final String NODE_NAME = "classicWebosPage";
    public static final String NODE_LABEL = "WebOS Page";
    public static final QualifiedName WINDOW_ID = QualifiedName.create((String)"gtn", (String)"wid");
    private DesktopBackground currBackground;

    public UIDesktopPage() throws Exception {
        this.setChildren(new CopyOnWriteArrayList());
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        UIPortlet target;
        String selectedWindow;
        UIRightClickPopupMenu rightClickPopup = (UIRightClickPopupMenu)this.getChild(UIRightClickPopupMenu.class);
        if (rightClickPopup == null) {
            this.addChild(UIRightClickPopupMenu.class, "UIDesktopContextMenu", null);
        }
        if ((selectedWindow = ((PortalRequestContext)context).getControllerContext().getParameter(WINDOW_ID)) != null && (target = (UIPortlet)this.findComponentById(selectedWindow)) != null) {
            int maxIndex = this.getMaxZIndex();
            Properties prop = target.getProperties();
            prop.setProperty("zIndex", String.valueOf(maxIndex));
            prop.setProperty("appStatus", "SHOW");
        }
        super.processRender(context);
    }

    private int getMaxZIndex() {
        ArrayList portlets = new ArrayList();
        this.findComponentOfType(portlets, UIPortlet.class);
        int maxIndex = -1;
        for (UIPortlet portlet : portlets) {
            int idx = portlet.getProperties().getIntValue("zIndex");
            if (idx <= maxIndex) continue;
            maxIndex = idx;
        }
        return ++maxIndex;
    }

    public boolean isShowMaxWindow() {
        return true;
    }

    public void showEditBackgroundPopup(WebuiRequestContext context) throws Exception {
        PortalRequestContext pContext = (PortalRequestContext)context;
        UIPortalApplication uiPortalApp = (UIPortalApplication)pContext.getUIApplication();
        UIMaskWorkspace maskWorkspace = (UIMaskWorkspace)uiPortalApp.findComponentById("UIMaskWorkspace");
        maskWorkspace.createUIComponent(UIBackgroundSelector.class, "backgroundSelector", "backgroundSelector");
        pContext.addUIComponentToUpdateByAjax((UIComponent)maskWorkspace);
    }

    public void setDesktopBackground(DesktopBackground desktopBackground) {
        this.currBackground = desktopBackground;
        this.showDesktopBackground(this.currBackground);
    }

    public void showDesktopBackground(DesktopBackground desktopBackground) {
        String backgroundURL = null;
        if (desktopBackground != null) {
            backgroundURL = "'" + desktopBackground.getImageURL() + "'";
        }
        JavascriptManager jsManager = WebuiRequestContext.getCurrentInstance().getJavascriptManager();
        jsManager.addOnLoadJavascript((CharSequence)("eXo.desktop.UIDesktop.setDesktopBackground(" + backgroundURL + ")"));
    }

    public String getCurrBackgroundLabel() throws Exception {
        this.initBackground();
        return this.currBackground.getImageLabel();
    }

    public String getCurrBackgroundURL() throws Exception {
        this.initBackground();
        return this.currBackground.getImageURL();
    }

    private void initBackground() throws Exception {
        if (this.currBackground == null) {
            DesktopBackgroundService service = (DesktopBackgroundService)this.getApplicationComponent(DesktopBackgroundService.class);
            this.currBackground = service.getCurrentDesktopBackground(this.getPageId());
            if (this.currBackground == null) {
                this.currBackground = new DesktopBackground();
            }
        }
    }

    private String getApplicationIconImageLocation(UIPortlet window) {
        String applicationId = window.getApplicationId();
        if (applicationId.indexOf("/") >= 0) {
            String imgLocation = applicationId.substring(0, applicationId.indexOf("/")) + "/skin/DefaultSkin/portletIcons/" + applicationId.substring(applicationId.indexOf("/") + 1, applicationId.length());
            return imgLocation;
        }
        return "";
    }

    public void switchToEditMode() throws Exception {
        this.showPageForm(this);
    }

    public void switchToEditMode(Page page) throws Exception {
        if (page == null) {
            return;
        }
        UIDesktopPage desktopPage = (UIDesktopPage)this.createUIComponent(UIDesktopPage.class, null, null);
        PortalDataMapper.toUIPage((UIPage)desktopPage, (Page)page);
        this.showPageForm(desktopPage);
    }

    private void showPageForm(UIDesktopPage uiDesktopPage) throws Exception {
        UIPortalApplication portalApp = Util.getUIPortalApplication();
        UIDesktopPageForm pageForm = (UIDesktopPageForm)portalApp.createUIComponent(UIDesktopPageForm.class, null, null);
        pageForm.setValues(uiDesktopPage);
        UIMaskWorkspace maskWorkspace = (UIMaskWorkspace)portalApp.getChildById("UIMaskWorkspace");
        maskWorkspace.setUIComponent((UIComponent)pageForm);
        Util.getPortalRequestContext().addUIComponentToUpdateByAjax((UIComponent)maskWorkspace);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ChangeBackgroundActionListener
    extends BaseDesktopActionListener {
        @Override
        protected void doAction(Event<UIComponent> event, UIPage uiPage) throws Exception {
            ((UIDesktopPage)uiPage).showEditBackgroundPopup(event.getRequestContext());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RefreshPageActionListener
    extends EventListener<UIRightClickPopupMenu> {
        public void execute(Event<UIRightClickPopupMenu> event) throws Exception {
            PortalRequestContext context = Util.getPortalRequestContext();
            UIPortalApplication uiApp = Util.getUIPortalApplication();
            context.addUIComponentToUpdateByAjax(uiApp.getChildById("UIWorkingWorkspace"));
            context.setFullRender(true);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EditCurrentPageActionListener
    extends BaseDesktopActionListener {
        @Override
        protected void doAction(Event<UIComponent> event, UIPage uiPage) throws Exception {
            uiPage.switchToEditMode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RemovePortletActionListener
    extends EventListener<UIDesktopPage> {
        public void execute(Event<UIDesktopPage> event) throws Exception {
            UIDesktopPage desktopPage = (UIDesktopPage)((Object)event.getSource());
            String id = event.getRequestContext().getRequestParameter("objectId");
            PortalRequestContext pcontext = (PortalRequestContext)event.getRequestContext();
            desktopPage.removeChildById(id);
            Page page = (Page)PortalDataMapper.buildModelObject((UIComponent)desktopPage);
            if (page.getChildren() == null) {
                page.setChildren(new ArrayList());
            }
            DataStorage dataService = (DataStorage)desktopPage.getApplicationComponent(DataStorage.class);
            dataService.save(page);
            pcontext.setFullRender(false);
            pcontext.setResponseComplete(true);
            pcontext.getWriter().write("OK");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ShowPortletActionListener
    extends EventListener<UIPage> {
        public void execute(Event<UIPage> event) throws Exception {
            UIPage uiPage = (UIPage)event.getSource();
            String portletId = event.getRequestContext().getRequestParameter("objectId");
            UIPortlet uiPortlet = (UIPortlet)uiPage.getChildById(portletId);
            uiPortlet.getProperties().setProperty("appStatus", "SHOW");
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiPortlet);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ShowAddNewApplicationActionListener
    extends BaseDesktopActionListener {
        @Override
        protected void doAction(Event<UIComponent> event, UIPage uiPage) throws Exception {
            UIPortalApplication uiPortalApp = (UIPortalApplication)uiPage.getAncestorOfType(UIPortalApplication.class);
            UIMaskWorkspace uiMaskWorkspace = (UIMaskWorkspace)uiPortalApp.getChildById("UIMaskWorkspace");
            UIAddNewApplication uiAddApplication = (UIAddNewApplication)uiPage.createUIComponent(UIAddNewApplication.class, null, null);
            uiAddApplication.setInPage(true);
            uiAddApplication.setUiComponentParent((UIComponent)uiPage);
            uiMaskWorkspace.setWindowSize(700, 375);
            uiMaskWorkspace.setUIComponent((UIComponent)uiAddApplication);
            uiMaskWorkspace.setShow(true);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiMaskWorkspace);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class BaseDesktopActionListener
    extends EventListener<UIComponent> {
        public void execute(Event<UIComponent> event) throws Exception {
            UIComponent source = (UIComponent)event.getSource();
            UIPage uiPage = source instanceof UIPage ? (UIPage)source : (UIPage)source.getAncestorOfType(UIPage.class);
            this.doAction(event, uiPage);
        }

        protected abstract void doAction(Event<UIComponent> var1, UIPage var2) throws Exception;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SaveWindowPropertiesActionListener
    extends EventListener<UIPage> {
        public void execute(Event<UIPage> event) throws Exception {
            String appStatus;
            String zIndex;
            String objectId;
            UIPage uiPage = (UIPage)event.getSource();
            UIApplication uiApp = (UIApplication)uiPage.getChildById(objectId = event.getRequestContext().getRequestParameter("objectId"));
            if (uiApp == null) {
                return;
            }
            String posX = event.getRequestContext().getRequestParameter("posX");
            String posY = event.getRequestContext().getRequestParameter("posY");
            if (posX != null) {
                uiApp.getProperties().put((Object)"locationX", (Object)posX);
            }
            if (posY != null) {
                uiApp.getProperties().put((Object)"locationY", (Object)posY);
            }
            if ((zIndex = event.getRequestContext().getRequestParameter("zIndex")) != null) {
                uiApp.getProperties().put((Object)"zIndex", (Object)zIndex);
            }
            String windowWidth = event.getRequestContext().getRequestParameter("windowWidth");
            String windowHeight = event.getRequestContext().getRequestParameter("windowHeight");
            if (windowWidth != null) {
                uiApp.setWidth(windowWidth);
            }
            if (windowHeight != null) {
                uiApp.setHeight(windowHeight);
            }
            if ((appStatus = event.getRequestContext().getRequestParameter("appStatus")) != null) {
                uiApp.getProperties().put((Object)"appStatus", (Object)appStatus);
            }
        }
    }
}

