/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.bench;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.bench.DataInjector;
import org.exoplatform.services.jcr.util.IdGenerator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.wiki.WikiException;
import org.exoplatform.wiki.mow.api.Attachment;
import org.exoplatform.wiki.mow.api.Page;
import org.exoplatform.wiki.mow.api.Permission;
import org.exoplatform.wiki.mow.api.PermissionEntry;
import org.exoplatform.wiki.mow.api.PermissionType;
import org.exoplatform.wiki.mow.api.Wiki;
import org.exoplatform.wiki.resolver.TitleResolver;
import org.exoplatform.wiki.service.IDType;
import org.exoplatform.wiki.service.PageUpdateType;
import org.exoplatform.wiki.service.WikiService;

public class WikiDataInjector
extends DataInjector {
    private HashMap<String, Integer> prefixesIndex = new HashMap();
    public static final String QUANTITY = "q";
    public static final String PREFIX = "pre";
    public static final String PAGE_SIZE = "mP";
    public static final String ATTACH_SIZE = "maxAtt";
    public static final String WIKI_OWNER = "wo";
    public static final String WIKI_TYPE = "wt";
    public static final String RECURSIVE = "rcs";
    public static final String PERMISSION = "perm";
    public static final String ARRAY_SPLIT = ",";
    private static Log log = ExoLogger.getLogger(WikiDataInjector.class);
    private WikiService wikiService;

    public WikiDataInjector(WikiService wikiService, InitParams params) {
        this.wikiService = wikiService;
    }

    private List<Integer> readQuantities(HashMap<String, String> queryParams) {
        String quantitiesString = queryParams.get(QUANTITY);
        LinkedList<Integer> quantities = new LinkedList<Integer>();
        for (String s : quantitiesString.split(ARRAY_SPLIT)) {
            if (s.length() <= 0) continue;
            int quantity = Integer.parseInt(s.trim());
            quantities.add(quantity);
        }
        return quantities;
    }

    private List<String> readPrefixes(HashMap<String, String> queryParams) {
        String prefixesString = queryParams.get(PREFIX);
        LinkedList<String> prefixes = new LinkedList<String>();
        for (String s : prefixesString.split(ARRAY_SPLIT)) {
            if (s.length() <= 0) continue;
            prefixes.add(s);
        }
        return prefixes;
    }

    private String readWikiOwner(HashMap<String, String> queryParams) {
        return queryParams.get(WIKI_OWNER);
    }

    private String readWikiType(HashMap<String, String> queryParams) {
        return queryParams.get(WIKI_TYPE);
    }

    private int readMaxAttachmentIfExist(HashMap<String, String> queryParams) {
        String value = queryParams.get(ATTACH_SIZE);
        if (value != null) {
            return Integer.parseInt(value);
        }
        return 0;
    }

    private int readMaxPagesIfExist(HashMap<String, String> queryParams) {
        String value = queryParams.get(PAGE_SIZE);
        if (value != null) {
            return Integer.parseInt(value);
        }
        return 0;
    }

    private boolean readRecursive(HashMap<String, String> queryParams) {
        boolean recursive = false;
        String value = queryParams.get(RECURSIVE);
        if (value != null) {
            recursive = Boolean.parseBoolean(value);
        }
        return recursive;
    }

    private List<Permission> readPermission(HashMap<String, String> queryParams) {
        boolean flag;
        String permString = queryParams.get(PERMISSION);
        LinkedList<Permission> permissions = new LinkedList<Permission>();
        boolean bl = flag = Integer.parseInt(permString.substring(0, 1)) > 0;
        if (flag) {
            permissions.add(new Permission(PermissionType.VIEWPAGE, true));
        }
        boolean bl2 = flag = Integer.parseInt(permString.substring(1, 2)) > 0;
        if (flag) {
            permissions.add(new Permission(PermissionType.EDITPAGE, true));
        }
        return permissions;
    }

    private List<PermissionEntry> readPermissions(HashMap<String, String> queryParams) {
        ArrayList<PermissionEntry> permissionEntries = new ArrayList<PermissionEntry>();
        Permission[] permissions = this.readPermission(queryParams).toArray(new Permission[0]);
        for (String identity : this.readGroupsIfExist(queryParams)) {
            permissionEntries.add(new PermissionEntry(identity, "", IDType.GROUP, permissions));
        }
        for (String identity : this.readUsersIfExist(queryParams)) {
            permissionEntries.add(new PermissionEntry(identity, "", IDType.USER, permissions));
        }
        for (String identity : this.readMembershipIfExist(queryParams)) {
            permissionEntries.add(new PermissionEntry(identity, "", IDType.MEMBERSHIP, permissions));
        }
        return permissionEntries;
    }

    private String makeTitle(String prefix, int order) {
        return prefix + "_" + order;
    }

    private Page createPage(Page father, String title, String wikiOwner, String wikiType, int attSize) throws WikiException {
        Page newPage = new Page();
        newPage.setTitle(title);
        newPage.setContent(title + "_content " + this.randomParagraphs(10));
        Page page = this.wikiService.createPage(new Wiki(wikiType, wikiOwner), father.getName(), newPage);
        if (attSize > 0) {
            Attachment attachment = new Attachment();
            String attachmentTitle = "att" + IdGenerator.generate();
            attachment.setName(attachmentTitle + ".txt");
            attachment.setTitle(attachmentTitle);
            int sizeInBytes = attSize * 1024;
            StringBuilder content = new StringBuilder(sizeInBytes);
            content.append(attachment.getName()).append("_content ");
            while (content.length() <= sizeInBytes) {
                content.append(this.randomParagraphs(1));
            }
            attachment.setContent(content.toString().getBytes());
            attachment.setMimeType("text/plain");
            this.wikiService.addAttachmentToPage(attachment, page);
        }
        return page;
    }

    private void generatePages(List<Integer> quantities, List<String> prefixes, int depth, int attSize, int totalPages, String wikiOwner, String wikiType, Page father) throws WikiException {
        int numOfPages = quantities.get(depth);
        String prefix = prefixes.get(depth);
        List<Page> childrenPagesWithPrefix = this.getPagesByPrefix(prefix, father);
        for (Page childPage : childrenPagesWithPrefix) {
            log.info((Object)String.format("%1$" + (depth + 1) * 4 + "s Process page: %2$s in depth %3$s .......", " ", childPage.getTitle(), depth + 1));
            if (depth >= quantities.size() - 1) continue;
            this.generatePages(quantities, prefixes, depth + 1, attSize, totalPages, wikiOwner, wikiType, childPage);
        }
        int prefixSize = childrenPagesWithPrefix.size();
        if (prefixSize < numOfPages) {
            for (int i = prefixSize; i < numOfPages; ++i) {
                Integer index = this.prefixesIndex.get(prefix);
                if (index == null) {
                    index = i;
                }
                Integer n = index;
                Integer n2 = index = Integer.valueOf(index + 1);
                this.prefixesIndex.put(prefix, index);
                Page page = this.createPage(father, this.makeTitle(prefix, index), wikiOwner, wikiType, attSize);
                log.info((Object)String.format("%1$" + (depth + 1) * 4 + "s Process page: %2$s in depth %3$s .......", " ", page.getTitle(), depth + 1));
                if (depth >= quantities.size() - 1) continue;
                this.generatePages(quantities, prefixes, depth + 1, attSize, totalPages, wikiOwner, wikiType, page);
            }
        }
    }

    private void injectData(HashMap<String, String> queryParams) throws WikiException {
        log.info((Object)"Start to inject data ............... ");
        List<Integer> quantities = this.readQuantities(queryParams);
        List<String> prefixes = this.readPrefixes(queryParams);
        int attSize = this.readMaxAttachmentIfExist(queryParams);
        int totalPages = this.readMaxPagesIfExist(queryParams);
        String wikiOwner = this.readWikiOwner(queryParams);
        String wikiType = this.readWikiType(queryParams);
        this.generatePages(quantities, prefixes, 0, attSize, totalPages, wikiOwner, wikiType, this.wikiService.getWikiByTypeAndOwner(wikiType, wikiOwner).getWikiHome());
        log.info((Object)"Injecting data has been done successfully!");
    }

    private void grantPermission(List<Integer> quantities, List<String> prefixes, int depth, Page father, String wikiOwner, String wikiType, List<PermissionEntry> permissions, boolean isRecursive) throws WikiException {
        int numOfPages = quantities.get(depth);
        String prefix = prefixes.get(depth);
        List<Page> childrenPagesWithPrefix = this.getPagesByPrefix(prefix, father);
        for (Page childPage : childrenPagesWithPrefix) {
            if (numOfPages-- <= 0) break;
            if (!isRecursive && depth != quantities.size() - 1) continue;
            log.info((Object)String.format("Grant permissions %1$s for page: %2$s", this.permissionsToString(permissions), childPage.getTitle()));
            childPage.setPermissions(permissions);
            this.wikiService.updatePage(childPage, PageUpdateType.EDIT_PAGE_PERMISSIONS);
            if (depth >= quantities.size() - 1) continue;
            this.grantPermission(quantities, prefixes, depth + 1, childPage, wikiOwner, wikiType, permissions, isRecursive);
        }
    }

    private String permissionsToString(List<PermissionEntry> permissions) {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        for (PermissionEntry permissionEntry : permissions) {
            Permission[] value = permissionEntry.getPermissions();
            sb.append("[" + permissionEntry.getIdType() + ":" + permissionEntry.getId() + ":");
            for (Permission permission : value) {
                if (!permission.isAllowed()) continue;
                sb.append(permission.getPermissionType().toString()).append(ARRAY_SPLIT);
            }
            sb.delete(sb.length() - 1, sb.length());
            sb.append("],");
        }
        if (sb.length() > 1) {
            sb.delete(sb.length() - 1, sb.length());
        }
        sb.append(")");
        return sb.toString();
    }

    private void grantPermission(HashMap<String, String> queryParams) throws WikiException {
        log.info((Object)"Start to grant permissions ............... ");
        List<Integer> quantities = this.readQuantities(queryParams);
        List<String> prefixes = this.readPrefixes(queryParams);
        String wikiOwner = this.readWikiOwner(queryParams);
        String wikiType = this.readWikiType(queryParams);
        List<PermissionEntry> permissions = this.readPermissions(queryParams);
        boolean isRecursive = this.readRecursive(queryParams);
        this.grantPermission(quantities, prefixes, 0, this.wikiService.getWikiByTypeAndOwner(wikiType, wikiOwner).getWikiHome(), wikiOwner, wikiType, permissions, isRecursive);
        log.info((Object)"Permissions have been granted successfully!");
    }

    public void inject(HashMap<String, String> queryParams) throws WikiException {
        String type = queryParams.get(CONSTANTS.TYPE.getName());
        if (CONSTANTS.DATA.getName().equalsIgnoreCase(type)) {
            this.injectData(queryParams);
        } else if (CONSTANTS.PERM.getName().equalsIgnoreCase(type)) {
            this.grantPermission(queryParams);
        }
    }

    public void reject(HashMap<String, String> params) throws WikiException {
        log.info((Object)"Start to reject data ............. ");
        String wikiOwner = this.readWikiOwner(params);
        String wikiType = this.readWikiType(params);
        List<Integer> quantities = this.readQuantities(params);
        List<String> prefixes = this.readPrefixes(params);
        int numOfPages = quantities.get(0);
        String prefix = prefixes.get(0);
        for (int i = 0; i < numOfPages; ++i) {
            String title = this.makeTitle(prefix, i + 1);
            String pageId = TitleResolver.getId((String)title, (boolean)true);
            if (this.wikiService.getPageOfWikiByName(wikiType, wikiOwner, pageId) == null) continue;
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("    Delete page: %1$s and its children ...", title));
            }
            this.wikiService.deletePage(wikiType, wikiOwner, pageId);
        }
        log.info((Object)"Rejecting data has been done successfully!");
    }

    public List<Page> getPagesByPrefix(String prefix, Page father) throws WikiException {
        ArrayList<Page> childrenPagesWithPrefix = new ArrayList<Page>();
        List childrenPages = this.wikiService.getChildrenPageOf(father);
        for (Page childPage : childrenPages) {
            if (childPage.getTitle() == null || !childPage.getTitle().startsWith(prefix)) continue;
            childrenPagesWithPrefix.add(childPage);
        }
        return childrenPagesWithPrefix;
    }

    public Log getLog() {
        return log;
    }

    public Object execute(HashMap<String, String> params) throws WikiException {
        return new Object();
    }

    public static enum CONSTANTS {
        TYPE("type"),
        DATA("data"),
        PERM("perm");

        private final String name;

        private CONSTANTS(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

