/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.jpa.search;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.file.model.FileInfo;
import org.exoplatform.commons.file.model.FileItem;
import org.exoplatform.commons.file.services.FileService;
import org.exoplatform.commons.file.services.FileStorageException;
import org.exoplatform.commons.search.domain.Document;
import org.exoplatform.commons.search.index.impl.ElasticIndexingServiceConnector;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.wiki.jpa.dao.PageAttachmentDAO;
import org.exoplatform.wiki.jpa.entity.PageAttachmentEntity;
import org.exoplatform.wiki.jpa.entity.PageEntity;
import org.exoplatform.wiki.jpa.entity.PermissionEntity;
import org.exoplatform.wiki.mow.api.PermissionType;
import org.json.JSONArray;
import org.json.simple.JSONObject;

public class AttachmentIndexingServiceConnector
extends ElasticIndexingServiceConnector {
    private static final long serialVersionUID = -1229795181507933039L;
    private static final Log LOGGER = ExoLogger.getExoLogger(AttachmentIndexingServiceConnector.class);
    public static final String TYPE = "wiki-attachment";
    private final PageAttachmentDAO attachmentDAO;
    private final FileService fileService;

    public AttachmentIndexingServiceConnector(InitParams initParams, FileService fileService, PageAttachmentDAO attachmentDAO) {
        super(initParams);
        this.attachmentDAO = attachmentDAO;
        this.fileService = fileService;
    }

    public Document create(String id) {
        if (StringUtils.isBlank((String)id)) {
            throw new IllegalArgumentException("Id is null");
        }
        PageAttachmentEntity attachment = (PageAttachmentEntity)this.attachmentDAO.find(Long.valueOf(Long.parseLong(id)));
        if (attachment == null) {
            LOGGER.info("The attachment entity with id {} doesn't exist.", new Object[]{id});
            return null;
        }
        FileItem fileItem = null;
        try {
            fileItem = this.fileService.getFile(attachment.getAttachmentFileID().longValue());
        }
        catch (FileStorageException e) {
            LOGGER.error("Cannot get attachment file ID {}, cause {}", new Object[]{attachment.getAttachmentFileID(), e.getCause()});
        }
        if (fileItem == null) {
            LOGGER.info("The attachment entity with id {} doesn't exist.", new Object[]{id});
            return null;
        }
        HashMap<String, String> fields = new HashMap<String, String>();
        FileInfo fileInfo = fileItem.getFileInfo();
        Document doc = new Document(TYPE, id, this.getUrl(attachment), fileInfo.getUpdatedDate(), this.computePermissions(fileInfo.getUpdater(), attachment), fields);
        doc.addField("title", attachment.getFullTitle());
        doc.addField("file", fileItem.getAsByte());
        doc.addField("name", fileInfo.getName());
        doc.addField("createdDate", String.valueOf(attachment.getCreatedDate().getTime()));
        doc.addField("updatedDate", String.valueOf(fileInfo.getUpdatedDate().getTime()));
        PageEntity page = attachment.getPage();
        doc.addField("pageName", page.getName());
        fields.put("wikiType", page.getWiki().getType());
        fields.put("wikiOwner", page.getWiki().getOwner());
        return doc;
    }

    public Document update(String id) {
        return this.create(id);
    }

    private Set<String> computePermissions(String creator, PageAttachmentEntity attachment) {
        HashSet<String> permissions = new HashSet<String>();
        permissions.add(creator);
        List<PermissionEntity> pagePermission = attachment.getPage().getPermissions();
        if (pagePermission != null) {
            for (PermissionEntity permission : pagePermission) {
                if (!permission.getPermissionType().equals((Object)PermissionType.VIEWPAGE) && !permission.getPermissionType().equals((Object)PermissionType.VIEW_ATTACHMENT)) continue;
                permissions.add(permission.getIdentity());
            }
        }
        return permissions;
    }

    private String getUrl(PageAttachmentEntity attachment) {
        return attachment.getPage().getUrl();
    }

    public String getMapping() {
        StringBuilder mapping = new StringBuilder().append("{").append("  \"properties\" : {\n").append("    \"name\" : {").append("      \"type\" : \"text\",").append("      \"index_options\": \"offsets\",").append("      \"fields\": {").append("        \"raw\": {").append("          \"type\": \"keyword\"").append("        }").append("      }").append("    },\n").append("    \"title\" : {").append("      \"type\" : \"text\",").append("      \"index_options\": \"offsets\",").append("      \"fields\": {").append("        \"raw\": {").append("          \"type\": \"keyword\"").append("        }").append("      }").append("    },\n").append("    \"wikiType\" : {\"type\" : \"keyword\"},\n").append("    \"wikiOwner\" : {\"type\" : \"keyword\"},\n").append("    \"pageName\" : {\"type\" : \"keyword\"},\n").append("    \"permissions\" : {\"type\" : \"keyword\"},\n").append("    \"url\" : {\"type\" : \"text\", \"index\": false},\n").append("    \"attachment\" : { \"properties\" : { \"content\" : {\"type\" : \"text\", \"store\": true, \"term_vector\": \"with_positions_offsets\"}}},\n").append("    \"createdDate\" : {\"type\" : \"date\", \"format\": \"epoch_millis\"},\n").append("    \"updatedDate\" : {\"type\" : \"date\", \"format\": \"epoch_millis\"},\n").append("    \"lastUpdatedDate\" : {\"type\" : \"date\", \"format\": \"epoch_millis\"}\n").append("  }\n").append("}");
        return mapping.toString();
    }

    public List<String> getAllIds(int offset, int limit) {
        ArrayList<String> result;
        List<Long> ids = this.attachmentDAO.findAllIds(offset, limit);
        if (ids == null) {
            result = new ArrayList<String>(0);
        } else {
            result = new ArrayList(ids.size());
            for (Long id : ids) {
                result.add(String.valueOf(id));
            }
        }
        return result;
    }

    public boolean isNeedIngestPipeline() {
        return true;
    }

    public String getPipelineName() {
        return "wiki-attachment-file";
    }

    public String getAttachmentProcessor() {
        JSONObject fieldJSON = new JSONObject();
        fieldJSON.put((Object)"field", (Object)"file");
        fieldJSON.put((Object)"indexed_chars", (Object)-1);
        fieldJSON.put((Object)"properties", (Object)new JSONArray(Collections.singleton("content")));
        JSONObject attachmentJSON = new JSONObject();
        attachmentJSON.put((Object)"attachment", (Object)fieldJSON);
        JSONObject fileBinaryRemoveActionJSON = new JSONObject();
        JSONObject fileBinaryRemoveJSON = new JSONObject();
        fileBinaryRemoveJSON.put((Object)"field", (Object)"file");
        fileBinaryRemoveActionJSON.put((Object)"remove", (Object)fileBinaryRemoveJSON);
        JSONObject processorJSON = new JSONObject();
        processorJSON.put((Object)"description", (Object)"Wiki Attachment processor");
        processorJSON.put((Object)"processors", (Object)new JSONArray(Arrays.asList(attachmentJSON, fileBinaryRemoveActionJSON)));
        return processorJSON.toJSONString();
    }
}

