/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.service.impl;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Stack;
import javax.annotation.security.RolesAllowed;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriBuilderException;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.fileupload.DiskFileUpload;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.utils.HTMLSanitizer;
import org.exoplatform.commons.utils.MimeTypeResolver;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.resources.ResourceBundleService;
import org.exoplatform.services.rest.impl.EnvironmentContext;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.rest.api.EntityBuilder;
import org.exoplatform.social.rest.entity.IdentityEntity;
import org.exoplatform.wiki.WikiException;
import org.exoplatform.wiki.mow.api.DraftPage;
import org.exoplatform.wiki.mow.api.EmotionIcon;
import org.exoplatform.wiki.mow.api.Page;
import org.exoplatform.wiki.mow.api.Wiki;
import org.exoplatform.wiki.mow.api.WikiType;
import org.exoplatform.wiki.service.WikiPageParams;
import org.exoplatform.wiki.service.WikiService;
import org.exoplatform.wiki.service.image.ResizeImageService;
import org.exoplatform.wiki.service.impl.BeanToJsons;
import org.exoplatform.wiki.service.impl.DraftData;
import org.exoplatform.wiki.service.impl.SpaceBean;
import org.exoplatform.wiki.service.related.JsonRelatedData;
import org.exoplatform.wiki.service.related.RelatedUtil;
import org.exoplatform.wiki.service.rest.model.Attachment;
import org.exoplatform.wiki.service.rest.model.Attachments;
import org.exoplatform.wiki.service.rest.model.Link;
import org.exoplatform.wiki.service.rest.model.ObjectFactory;
import org.exoplatform.wiki.service.rest.model.PageSummary;
import org.exoplatform.wiki.service.rest.model.Pages;
import org.exoplatform.wiki.service.rest.model.Space;
import org.exoplatform.wiki.service.rest.model.Spaces;
import org.exoplatform.wiki.service.search.SearchResult;
import org.exoplatform.wiki.service.search.SearchResultType;
import org.exoplatform.wiki.service.search.TitleSearchResult;
import org.exoplatform.wiki.service.search.WikiSearchData;
import org.exoplatform.wiki.tree.JsonNodeData;
import org.exoplatform.wiki.tree.TreeNode;
import org.exoplatform.wiki.tree.WikiTreeNode;
import org.exoplatform.wiki.tree.utils.TreeUtils;
import org.exoplatform.wiki.utils.Utils;
import org.exoplatform.wiki.utils.WikiHTMLSanitizer;

@Path(value="/wiki")
public class WikiRestServiceImpl
implements ResourceContainer {
    private final WikiService wikiService;
    private final ResourceBundleService resourceBundleService;
    private static Log log = ExoLogger.getLogger((String)"wiki:WikiRestService");
    private final CacheControl cc;
    private ObjectFactory objectFactory = new ObjectFactory();

    public WikiRestServiceImpl(WikiService wikiService, ResourceBundleService resourceBundleService) {
        this.wikiService = wikiService;
        this.resourceBundleService = resourceBundleService;
        this.cc = new CacheControl();
        this.cc.setNoCache(true);
        this.cc.setNoStore(true);
    }

    @POST
    @Path(value="/content/")
    public Response getWikiPageContent(@FormParam(value="text") String text) {
        try {
            String outputText = WikiHTMLSanitizer.markupSanitize(text);
            return Response.ok((Object)outputText, (String)"text/html").cacheControl(this.cc).build();
        }
        catch (Exception e) {
            log.error((Object)("Error while converting wiki page content: " + e.getMessage()), (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).cacheControl(this.cc).build();
        }
    }

    @POST
    @Path(value="/upload/{wikiType}/{wikiOwner:.+}/{pageId}/")
    @RolesAllowed(value={"users"})
    public Response upload(@PathParam(value="wikiType") String wikiType, @PathParam(value="wikiOwner") String wikiOwner, @PathParam(value="pageId") String pageId) {
        EnvironmentContext env = EnvironmentContext.getCurrent();
        HttpServletRequest req = (HttpServletRequest)env.get(HttpServletRequest.class);
        boolean isMultipart = FileUploadBase.isMultipartContent((HttpServletRequest)req);
        if (isMultipart) {
            DiskFileUpload upload = new DiskFileUpload();
            try {
                String attachmentName = null;
                List items = upload.parseRequest(req);
                for (FileItem fileItem : items) {
                    byte[] imageBytes;
                    InputStream inputStream = fileItem.getInputStream();
                    if (inputStream != null) {
                        imageBytes = new byte[inputStream.available()];
                        inputStream.read(imageBytes);
                    } else {
                        imageBytes = null;
                    }
                    String fileName = Utils.normalizeUploadedFilename(fileItem.getName());
                    if (fileName != null) {
                        fileName = FilenameUtils.getName((String)fileName);
                    }
                    String mimeType = new MimeTypeResolver().getMimeType(StringUtils.lowerCase((String)fileName));
                    WikiService wikiService = (WikiService)PortalContainer.getComponent(WikiService.class);
                    Page page = wikiService.getExsitedOrNewDraftPageById(wikiType, wikiOwner, pageId);
                    org.exoplatform.wiki.mow.api.Attachment attachment = new org.exoplatform.wiki.mow.api.Attachment();
                    attachment.setName(fileName);
                    if (fileName.lastIndexOf(".") > 0) {
                        attachment.setTitle(fileName.substring(0, fileName.lastIndexOf(".")));
                    }
                    attachment.setMimeType(mimeType);
                    attachment.setContent(imageBytes);
                    ConversationState conversationState = ConversationState.getCurrent();
                    if (conversationState != null && conversationState.getIdentity() != null) {
                        attachment.setCreator(conversationState.getIdentity().getUserId());
                    }
                    wikiService.addAttachmentToPage(attachment, page);
                    attachmentName = attachment.getName();
                }
                StringBuilder responseBody = new StringBuilder("{\"default\":\"").append(Utils.getDefaultRestBaseURI()).append("/wiki/attachments/").append(wikiType).append("/").append("space").append("/").append(wikiOwner).append("/").append("page").append("/").append(pageId).append("/").append(attachmentName).append("\"}");
                return Response.ok((Object)responseBody.toString()).build();
            }
            catch (IllegalArgumentException e) {
                log.error((Object)"Special characters are not allowed in the name of an attachment.");
                return Response.status((int)400).entity((Object)e.getMessage()).build();
            }
            catch (Exception e) {
                log.error((Object)e.getMessage());
                return Response.status((int)400).entity((Object)e.getMessage()).build();
            }
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"The request must be a multipart request").build();
    }

    @GET
    @Path(value="/tree/{type}")
    @Produces(value={"application/json"})
    public Response getTreeData(@PathParam(value="type") String type, @QueryParam(value="path") String path, @QueryParam(value="page") String currentPath, @QueryParam(value="canEdit") Boolean canEdit, @QueryParam(value="excerpt") Boolean showExcerpt, @QueryParam(value="depth") String depth) {
        try {
            List<JsonNodeData> responseData = new ArrayList<JsonNodeData>();
            HashMap<String, Object> context = new HashMap<String, Object>();
            context.put("canEdit", canEdit);
            if (currentPath != null) {
                currentPath = URLDecoder.decode(currentPath, "utf-8");
                context.put("page", currentPath);
                WikiPageParams currentPageParam = TreeUtils.getPageParamsFromPath(currentPath);
                Page currentPage = this.wikiService.getPageOfWikiByName(currentPageParam.getType(), currentPageParam.getOwner(), currentPageParam.getPageName());
                context.put("currentPage", currentPage);
            }
            EnvironmentContext env = EnvironmentContext.getCurrent();
            HttpServletRequest request = (HttpServletRequest)env.get(HttpServletRequest.class);
            path = URLDecoder.decode(path, "utf-8");
            context.put("path", path);
            WikiPageParams pageParam = TreeUtils.getPageParamsFromPath(path);
            Page page = this.wikiService.getPageOfWikiByName(pageParam.getType(), pageParam.getOwner(), pageParam.getPageName());
            if (page == null) {
                log.warn("User [{}] can not get wiki path [{}]. Wiki Home is used instead", new Object[]{ConversationState.getCurrent().getIdentity().getUserId(), path});
                page = this.wikiService.getPageOfWikiByName(pageParam.getType(), pageParam.getOwner(), "WikiHome");
                if (page == null) {
                    ResourceBundle resourceBundle = this.resourceBundleService.getResourceBundle("locale.portlet.wiki.WikiPortlet", request.getLocale());
                    String errorMessage = "";
                    if (resourceBundle != null) {
                        errorMessage = resourceBundle.getString("UIWikiMovePageForm.msg.no-permission-at-wiki-destination");
                    }
                    return Response.serverError().entity((Object)("{ \"message\": \"" + errorMessage + "\"}")).cacheControl(this.cc).build();
                }
            }
            context.put("selectedPage", page);
            context.put("excerpt", showExcerpt);
            if (type.equalsIgnoreCase(TreeNode.TREETYPE.ALL.toString())) {
                Stack<WikiPageParams> stk = Utils.getStackParams(page);
                context.put("stackParams", stk);
                responseData = this.getJsonTree(pageParam, context);
            } else if (type.equalsIgnoreCase(TreeNode.TREETYPE.CHILDREN.toString())) {
                if (depth == null) {
                    depth = "1";
                }
                context.put("depth", depth);
                responseData = this.getJsonDescendants(pageParam, context);
            }
            this.encodeWikiTree(responseData, request.getLocale());
            return Response.ok(new BeanToJsons<JsonNodeData>(responseData), (String)"application/json").cacheControl(this.cc).build();
        }
        catch (Exception e) {
            log.error((Object)("Failed for get tree data by rest service - Cause : " + e.getMessage()), (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).cacheControl(this.cc).build();
        }
    }

    @GET
    @Path(value="/related/")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    public Response getRelated(@QueryParam(value="path") String path) {
        if (path == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        try {
            WikiPageParams params = TreeUtils.getPageParamsFromPath(path);
            Page page = this.wikiService.getPageOfWikiByName(params.getType(), params.getOwner(), params.getPageName());
            if (page != null) {
                List<Page> relatedPages = this.wikiService.getRelatedPagesOfPage(page);
                List<JsonRelatedData> relatedData = RelatedUtil.pageToJson(relatedPages);
                return Response.ok(new BeanToJsons<JsonRelatedData>(relatedData)).cacheControl(this.cc).build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error((Object)String.format("can not get related pages of [%s]", path), (Throwable)e);
            }
            return Response.serverError().cacheControl(this.cc).build();
        }
    }

    @GET
    @Path(value="/{wikiType}/spaces")
    @Produces(value={"application/xml"})
    @RolesAllowed(value={"users"})
    public Spaces getSpaces(@Context UriInfo uriInfo, @PathParam(value="wikiType") String wikiType, @QueryParam(value="start") Integer start, @QueryParam(value="number") Integer number) {
        Spaces spaces = this.objectFactory.createSpaces();
        ArrayList<String> spaceNames = new ArrayList<String>();
        try {
            List<Wiki> wikis = this.wikiService.getWikisByType(wikiType);
            for (Wiki wiki : wikis) {
                spaceNames.add(wiki.getOwner());
            }
            for (String spaceName : spaceNames) {
                Page page = this.wikiService.getPageOfWikiByName(wikiType, spaceName, "WikiHome");
                spaces.getSpaces().add(this.createSpace(this.objectFactory, uriInfo.getBaseUri(), wikiType, spaceName, page));
            }
        }
        catch (WikiException e) {
            log.error((Object)("Cannot get spaces of wiki type " + wikiType + " - Cause : " + e.getMessage()), (Throwable)e);
        }
        return spaces;
    }

    private List getLastAccessedSpace(String userId, String appId, int offset, int limit) throws Exception {
        List spaces = new ArrayList();
        Class<?> spaceServiceClass = Class.forName("org.exoplatform.social.core.space.spi.SpaceService");
        Object spaceService = ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(spaceServiceClass);
        spaces = (List)spaceServiceClass.getDeclaredMethod("getLastAccessedSpace", String.class, String.class, Integer.class, Integer.class).invoke(spaceService, userId, appId, new Integer(offset), new Integer(limit));
        return spaces;
    }

    private <T> T getValueFromSpace(Object space, String getterMethod, Class<T> propertyClass) throws Exception {
        Class<?> spaceClass = Class.forName("org.exoplatform.social.core.space.model.Space");
        Object propertyValue = spaceClass.getMethod(getterMethod, new Class[0]).invoke(space, new Object[0]);
        return (T)propertyValue;
    }

    @GET
    @Path(value="/lastVisited/spaces")
    @Produces(value={"application/xml"})
    @RolesAllowed(value={"users"})
    public Spaces getLastVisitedSpaces(@Context UriInfo uriInfo, @QueryParam(value="offset") Integer offset, @QueryParam(value="limit") Integer limit) {
        Spaces spaces = this.objectFactory.createSpaces();
        String currentUser = Utils.getCurrentUser();
        try {
            List lastVisitedSpaces = this.getLastAccessedSpace(currentUser, "Wiki", offset, limit);
            for (Object space : lastVisitedSpaces) {
                String groupId = this.getValueFromSpace(space, "getGroupId", String.class);
                String displayName = this.getValueFromSpace(space, "getDisplayName", String.class);
                Wiki wiki = this.wikiService.getWikiByTypeAndOwner(WikiType.GROUP.toString(), groupId);
                Page page = this.wikiService.getPageOfWikiByName(wiki.getType(), wiki.getOwner(), "WikiHome");
                spaces.getSpaces().add(this.createSpace(this.objectFactory, uriInfo.getBaseUri(), wiki.getType(), displayName, page));
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return spaces;
    }

    @GET
    @Path(value="/{wikiType}/spaces/{wikiOwner:.+}/")
    @Produces(value={"application/xml"})
    @RolesAllowed(value={"users"})
    public Space getSpace(@Context UriInfo uriInfo, @PathParam(value="wikiType") String wikiType, @PathParam(value="wikiOwner") String wikiOwner) {
        Page page;
        try {
            page = this.wikiService.getPageOfWikiByName(wikiType, wikiOwner, "WikiHome");
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return this.objectFactory.createSpace();
        }
        return this.createSpace(this.objectFactory, uriInfo.getBaseUri(), wikiType, wikiOwner, page);
    }

    @GET
    @Path(value="/{wikiType}/spaces/{wikiOwner:.+}/pages")
    @Produces(value={"application/xml"})
    @RolesAllowed(value={"users"})
    public Pages getPages(@Context UriInfo uriInfo, @PathParam(value="wikiType") String wikiType, @PathParam(value="wikiOwner") String wikiOwner, @QueryParam(value="start") Integer start, @QueryParam(value="number") Integer number, @QueryParam(value="parentId") String parentFilterExpression) {
        Pages pages = this.objectFactory.createPages();
        boolean isWikiHome = true;
        try {
            String parentId = "WikiHome";
            if (parentFilterExpression != null && parentFilterExpression.length() > 0 && !parentFilterExpression.startsWith("^(?!")) {
                parentId = parentFilterExpression;
                if (parentId.indexOf(".") >= 0) {
                    parentId = parentId.substring(parentId.indexOf(".") + 1);
                }
                isWikiHome = false;
            }
            Page page = this.wikiService.getPageOfWikiByName(wikiType, wikiOwner, parentId);
            if (isWikiHome) {
                pages.getPageSummaries().add(this.createPageSummary(this.objectFactory, uriInfo.getBaseUri(), page));
            } else {
                List<Page> childrenPages = this.wikiService.getChildrenPageOf(page);
                for (Page childPage : childrenPages) {
                    pages.getPageSummaries().add(this.createPageSummary(this.objectFactory, uriInfo.getBaseUri(), childPage));
                }
            }
        }
        catch (Exception e) {
            log.error((Object)("Can't get children pages of:" + parentFilterExpression), (Throwable)e);
        }
        return pages;
    }

    @GET
    @Path(value="/{wikiType}/spaces/{wikiOwner:.+}/pages/{pageId}")
    @Produces(value={"application/xml"})
    @RolesAllowed(value={"users"})
    public org.exoplatform.wiki.service.rest.model.Page getPage(@Context UriInfo uriInfo, @PathParam(value="wikiType") String wikiType, @PathParam(value="wikiOwner") String wikiOwner, @PathParam(value="pageId") String pageId) {
        try {
            Page page = this.wikiService.getPageOfWikiByName(wikiType, wikiOwner, pageId);
            if (page != null) {
                return this.createPage(this.objectFactory, uriInfo.getBaseUri(), uriInfo.getAbsolutePath(), page);
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return this.objectFactory.createPage();
    }

    @GET
    @Path(value="/{wikiType}/spaces/{wikiOwner:.+}/pages/{pageId}/attachments")
    @Produces(value={"application/xml"})
    @RolesAllowed(value={"users"})
    public Attachments getAttachments(@Context UriInfo uriInfo, @PathParam(value="wikiType") String wikiType, @PathParam(value="wikiOwner") String wikiOwner, @PathParam(value="pageId") String pageId, @QueryParam(value="start") Integer start, @QueryParam(value="number") Integer number) {
        Attachments attachments = this.objectFactory.createAttachments();
        try {
            Page page = this.wikiService.getPageOfWikiByName(wikiType, wikiOwner, pageId);
            List<org.exoplatform.wiki.mow.api.Attachment> pageAttachments = this.wikiService.getAttachmentsOfPage(page);
            for (org.exoplatform.wiki.mow.api.Attachment pageAttachment : pageAttachments) {
                attachments.getAttachments().add(this.createAttachment(this.objectFactory, uriInfo.getBaseUri(), pageAttachment, page, "attachment", "attachment"));
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return attachments;
    }

    @GET
    @Path(value="contextsearch/")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    public Response searchData(@Context UriInfo uriInfo, @QueryParam(value="keyword") String keyword, @QueryParam(value="wikiType") String wikiType, @QueryParam(value="wikiOwner") String wikiOwner) throws Exception {
        try {
            keyword = keyword.toLowerCase();
            WikiSearchData data = new WikiSearchData(keyword, keyword, wikiType, wikiOwner);
            data.setLimit(10);
            List results = this.wikiService.search(data).getAll();
            ArrayList<TitleSearchResult> titleSearchResults = new ArrayList<TitleSearchResult>();
            for (SearchResult searchResult : results) {
                Page page = this.wikiService.getPageOfWikiByName(searchResult.getWikiType(), searchResult.getWikiOwner(), searchResult.getPageName());
                if (page != null) {
                    if (SearchResultType.ATTACHMENT.equals((Object)searchResult.getType())) {
                        org.exoplatform.wiki.mow.api.Attachment attachment = this.wikiService.getAttachmentOfPageByName(searchResult.getAttachmentName(), page);
                        titleSearchResults.add(new TitleSearchResult(attachment.getName(), searchResult.getType(), attachment.getDownloadURL()));
                        continue;
                    }
                    IdentityEntity posterIdentity = EntityBuilder.buildEntityIdentity((Identity)searchResult.getPoster(), (String)uriInfo.getPath(), (String)"all");
                    IdentityEntity wikiOwnerIdentity = searchResult.getWikiOwnerIdentity() != null ? EntityBuilder.buildEntityIdentity((Identity)searchResult.getWikiOwnerIdentity(), (String)uriInfo.getPath(), (String)"all") : null;
                    titleSearchResults.add(new TitleSearchResult(searchResult.getTitle(), posterIdentity, wikiOwnerIdentity, searchResult.getExcerpt(), searchResult.getCreatedDate().getTimeInMillis(), searchResult.getType(), page.getUrl()));
                    continue;
                }
                log.warn((Object)("Cannot get page of search result " + searchResult.getWikiType() + ":" + searchResult.getWikiOwner() + ":" + searchResult.getPageName()));
            }
            return Response.ok(new BeanToJsons(titleSearchResults), (String)"application/json").cacheControl(this.cc).build();
        }
        catch (Exception e) {
            return Response.status((int)500).cacheControl(this.cc).build();
        }
    }

    @GET
    @Path(value="/images/{wikiType}/space/{wikiOwner:.+}/page/{pageId}/{imageId}")
    public Response getImage(@Context UriInfo uriInfo, @PathParam(value="wikiType") String wikiType, @PathParam(value="wikiOwner") String wikiOwner, @PathParam(value="pageId") String pageId, @PathParam(value="imageId") String imageId, @QueryParam(value="width") Integer width) {
        return this.getAttachment(uriInfo, wikiType, wikiOwner, pageId, imageId, width);
    }

    @GET
    @Path(value="/attachments/{wikiType}/space/{wikiOwner:.+}/page/{pageId}/{attachmentId}")
    public Response getAttachment(@Context UriInfo uriInfo, @PathParam(value="wikiType") String wikiType, @PathParam(value="wikiOwner") String wikiOwner, @PathParam(value="pageId") String pageId, @PathParam(value="attachmentId") String attachmentId, @QueryParam(value="width") Integer width) {
        try {
            InputStream result;
            Page page = this.wikiService.getPageOfWikiByName(wikiType, wikiOwner, pageId);
            if (page == null) {
                page = this.wikiService.getRelatedPage(wikiType, wikiOwner, pageId);
            }
            if (page == null) {
                return Response.status((int)404).entity((Object)("There is no resource matching to request path " + uriInfo.getPath())).type("text/plain").build();
            }
            org.exoplatform.wiki.mow.api.Attachment attachment = this.wikiService.getAttachmentOfPageByName(attachmentId, page, true);
            if (attachment == null) {
                return Response.status((int)404).entity((Object)("There is no resource matching to request path " + uriInfo.getPath())).type("text/plain").build();
            }
            ByteArrayInputStream bis = new ByteArrayInputStream(attachment.getContent());
            if (width != null) {
                ResizeImageService resizeImgService = (ResizeImageService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(ResizeImageService.class);
                result = resizeImgService.resizeImageByWidth(attachmentId, bis, width);
            } else {
                result = bis;
            }
            return Response.ok((Object)result).header("Content-Disposition", (Object)("attachment; filename=" + attachment.getName())).cacheControl(this.cc).build();
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Can't get attachment name: %s of page %s", attachmentId, pageId), (Throwable)e);
            }
            return Response.status((int)500).cacheControl(this.cc).build();
        }
    }

    public Space createSpace(ObjectFactory objectFactory, URI baseUri, String wikiName, String spaceName, Page home) {
        Space space = objectFactory.createSpace();
        space.setId(String.format("%s:%s", wikiName, spaceName));
        space.setWiki(wikiName);
        space.setName(spaceName);
        if (home != null) {
            space.setHome("home");
            space.setXwikiRelativeUrl("home");
            space.setXwikiAbsoluteUrl("home");
        }
        String pagesUri = UriBuilder.fromUri((URI)baseUri).path("/wiki/{wikiName}/spaces/{spaceName}/pages").build(new Object[]{wikiName, spaceName}).toString();
        Link pagesLink = objectFactory.createLink();
        pagesLink.setHref(pagesUri);
        pagesLink.setRel("pages");
        space.getLinks().add(pagesLink);
        if (home != null) {
            String homeUri = UriBuilder.fromUri((URI)baseUri).path("/wiki/{wikiName}/spaces/{spaceName}/pages/{pageName}").build(new Object[]{wikiName, spaceName, home.getName()}).toString();
            Link homeLink = objectFactory.createLink();
            homeLink.setHref(homeUri);
            homeLink.setRel("home");
            space.getLinks().add(homeLink);
        }
        String searchUri = UriBuilder.fromUri((URI)baseUri).path("/wiki/{wikiName}/spaces/{spaceName}/search").build(new Object[]{wikiName, spaceName}).toString();
        Link searchLink = objectFactory.createLink();
        searchLink.setHref(searchUri);
        searchLink.setRel("search");
        space.getLinks().add(searchLink);
        return space;
    }

    public org.exoplatform.wiki.service.rest.model.Page createPage(ObjectFactory objectFactory, URI baseUri, URI self, Page doc) throws Exception {
        org.exoplatform.wiki.service.rest.model.Page page = objectFactory.createPage();
        this.fillPageSummary(page, objectFactory, baseUri, doc);
        page.setVersion("current");
        page.setMajorVersion(1);
        page.setMinorVersion(0);
        page.setLanguage(doc.getSyntax());
        page.setCreator(doc.getOwner());
        GregorianCalendar calendar = new GregorianCalendar();
        page.setCreated(calendar);
        page.setModifier(doc.getAuthor());
        calendar = new GregorianCalendar();
        calendar.setTime(doc.getUpdatedDate());
        page.setModified(calendar);
        page.setContent(doc.getContent());
        if (self != null) {
            Link pageLink = objectFactory.createLink();
            pageLink.setHref(self.toString());
            pageLink.setRel("self");
            page.getLinks().add(pageLink);
        }
        return page;
    }

    public PageSummary createPageSummary(ObjectFactory objectFactory, URI baseUri, Page page) throws IllegalArgumentException, UriBuilderException, Exception {
        Wiki wiki = this.wikiService.getWikiByTypeAndOwner(page.getWikiType(), page.getWikiOwner());
        PageSummary pageSummary = objectFactory.createPageSummary();
        this.fillPageSummary(pageSummary, objectFactory, baseUri, page);
        String wikiName = wiki.getType();
        String spaceName = wiki.getOwner();
        String pageUri = UriBuilder.fromUri((URI)baseUri).path("/wiki/{wikiName}/spaces/{spaceName}/pages/{pageName}").build(new Object[]{wikiName, spaceName, page.getName()}).toString();
        Link pageLink = objectFactory.createLink();
        pageLink.setHref(pageUri);
        pageLink.setRel("page");
        pageSummary.getLinks().add(pageLink);
        return pageSummary;
    }

    public Attachment createAttachment(ObjectFactory objectFactory, URI baseUri, org.exoplatform.wiki.mow.api.Attachment pageAttachment, Page page, String xwikiRelativeUrl, String xwikiAbsoluteUrl) throws Exception {
        Attachment attachment = objectFactory.createAttachment();
        this.fillAttachment(attachment, objectFactory, baseUri, pageAttachment, page, xwikiRelativeUrl, xwikiAbsoluteUrl);
        String attachmentUri = UriBuilder.fromUri((URI)baseUri).path("/wiki/{wikiName}/spaces/{spaceName}/pages/{pageName}/attachments/{attachmentName}").build(new Object[]{page.getWikiType(), page.getWikiOwner(), page.getName(), pageAttachment.getName()}).toString();
        Link attachmentLink = objectFactory.createLink();
        attachmentLink.setHref(attachmentUri);
        attachmentLink.setRel("attachmentData");
        attachment.getLinks().add(attachmentLink);
        return attachment;
    }

    private List<JsonNodeData> getJsonTree(WikiPageParams params, HashMap<String, Object> context) throws Exception {
        Wiki wiki = this.wikiService.getWikiByTypeAndOwner(params.getType(), params.getOwner());
        WikiTreeNode wikiNode = new WikiTreeNode(wiki);
        wikiNode.pushDescendants(context);
        return TreeUtils.tranformToJson(wikiNode, context);
    }

    private List<JsonNodeData> getJsonDescendants(WikiPageParams params, HashMap<String, Object> context) throws Exception {
        TreeNode treeNode = TreeUtils.getDescendants(params, context);
        return TreeUtils.tranformToJson(treeNode, context);
    }

    private void fillPageSummary(PageSummary pageSummary, ObjectFactory objectFactory, URI baseUri, Page page) throws IllegalArgumentException, UriBuilderException, Exception {
        List<org.exoplatform.wiki.mow.api.Attachment> attachments;
        Wiki wiki = this.wikiService.getWikiByTypeAndOwner(page.getWikiType(), page.getWikiOwner());
        pageSummary.setWiki(wiki.getType());
        pageSummary.setFullName(page.getTitle());
        pageSummary.setId(wiki.getType() + ":" + wiki.getOwner() + "." + page.getName());
        pageSummary.setSpace(wiki.getOwner());
        pageSummary.setName(page.getName());
        pageSummary.setTitle(HTMLSanitizer.sanitize((String)page.getTitle()));
        pageSummary.setTranslations(objectFactory.createTranslations());
        pageSummary.setSyntax(page.getSyntax());
        Page parent = this.wikiService.getParentPageOf(page);
        if (parent != null) {
            pageSummary.setParent(parent.getName());
            pageSummary.setParentId(parent.getName());
        } else {
            pageSummary.setParent("");
            pageSummary.setParentId("");
        }
        String spaceUri = UriBuilder.fromUri((URI)baseUri).path("/wiki/{wikiName}/spaces/{spaceName}").build(new Object[]{wiki.getType(), wiki.getOwner()}).toString();
        Link spaceLink = objectFactory.createLink();
        spaceLink.setHref(spaceUri);
        spaceLink.setRel("space");
        pageSummary.getLinks().add(spaceLink);
        if (parent != null) {
            String parentUri = UriBuilder.fromUri((URI)baseUri).path("/wiki/{wikiName}/spaces/{spaceName}/pages/{pageName}").build(new Object[]{wiki.getType(), wiki.getOwner(), parent.getName()}).toString();
            Link parentLink = objectFactory.createLink();
            parentLink.setHref(parentUri);
            parentLink.setRel("parent");
            pageSummary.getLinks().add(parentLink);
        }
        if (!this.wikiService.getChildrenPageOf(page).isEmpty()) {
            String pageChildrenUri = UriBuilder.fromUri((URI)baseUri).path("/wiki/{wikiName}/spaces/{spaceName}/pages/{pageName}/children").build(new Object[]{wiki.getType(), wiki.getOwner(), page.getName()}).toString();
            Link pageChildrenLink = objectFactory.createLink();
            pageChildrenLink.setHref(pageChildrenUri);
            pageChildrenLink.setRel("children");
            pageSummary.getLinks().add(pageChildrenLink);
        }
        if (!(attachments = this.wikiService.getAttachmentsOfPage(page)).isEmpty()) {
            String attachmentsUri = UriBuilder.fromUri((URI)baseUri).path("/wiki/{wikiName}/spaces/{spaceName}/pages/{pageName}/attachments").build(new Object[]{wiki.getType(), wiki.getOwner(), page.getName()}).toString();
            Link attachmentsLink = objectFactory.createLink();
            attachmentsLink.setHref(attachmentsUri);
            attachmentsLink.setRel("attachments");
            pageSummary.getLinks().add(attachmentsLink);
        }
    }

    private void fillAttachment(Attachment attachment, ObjectFactory objectFactory, URI baseUri, org.exoplatform.wiki.mow.api.Attachment pageAttachment, Page page, String xwikiRelativeUrl, String xwikiAbsoluteUrl) throws Exception {
        attachment.setId(String.format("%s@%s", page.getName(), pageAttachment.getName()));
        attachment.setName(pageAttachment.getName());
        attachment.setSize((int)pageAttachment.getWeightInBytes());
        attachment.setVersion("current");
        attachment.setPageId(page.getName());
        attachment.setPageVersion("current");
        attachment.setMimeType(pageAttachment.getMimeType());
        attachment.setAuthor(pageAttachment.getCreator());
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(pageAttachment.getCreatedDate().getTime());
        attachment.setDate(calendar);
        attachment.setXwikiRelativeUrl(xwikiRelativeUrl);
        attachment.setXwikiAbsoluteUrl(xwikiAbsoluteUrl);
        String pageUri = UriBuilder.fromUri((URI)baseUri).path("/wiki/{wikiName}/spaces/{spaceName}/pages/{pageName}").build(new Object[]{page.getWikiType(), page.getWikiOwner(), page.getName()}).toString();
        Link pageLink = objectFactory.createLink();
        pageLink.setHref(pageUri);
        pageLink.setRel("page");
        attachment.getLinks().add(pageLink);
    }

    @GET
    @Path(value="/spaces/accessibleSpaces/")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    public Response searchAccessibleSpaces(@QueryParam(value="keyword") String keyword) {
        try {
            List<SpaceBean> spaceBeans = this.wikiService.searchSpaces(keyword);
            return Response.ok(new BeanToJsons<SpaceBean>(spaceBeans), (String)"application/json").cacheControl(this.cc).build();
        }
        catch (Exception ex) {
            if (log.isWarnEnabled()) {
                log.warn((Object)"An exception happens when searchAccessibleSpaces", (Throwable)ex);
            }
            return Response.status((int)500).cacheControl(this.cc).build();
        }
    }

    @POST
    @Path(value="/saveDraft/")
    @RolesAllowed(value={"users"})
    public Response saveDraft(@QueryParam(value="wikiType") String wikiType, @QueryParam(value="wikiOwner") String wikiOwner, @QueryParam(value="pageId") String rawPageId, @QueryParam(value="pageRevision") String pageRevision, @QueryParam(value="lastDraftName") String lastDraftName, @QueryParam(value="isNewPage") boolean isNewPage, @QueryParam(value="clientTime") long clientTime, @FormParam(value="title") String title, @FormParam(value="content") String content, @FormParam(value="isMarkup") String isMarkup) {
        String pageId = null;
        try {
            if ("__anonim".equals(Utils.getCurrentUser())) {
                return Response.status((int)400).cacheControl(this.cc).build();
            }
            pageId = URLDecoder.decode(rawPageId, "utf-8");
            WikiPageParams param = new WikiPageParams(wikiType, wikiOwner, pageId);
            Page page = this.wikiService.getPageOfWikiByName(wikiType, wikiOwner, pageId);
            if (StringUtils.isEmpty((String)pageId) || page == null) {
                throw new IllegalArgumentException("Can not find the target page");
            }
            DraftPage draftPage = null;
            if (!isNewPage) {
                draftPage = this.wikiService.getDraftOfPage(page);
                if (draftPage != null && !draftPage.getName().equals(lastDraftName)) {
                    draftPage = null;
                }
            } else if (!StringUtils.isEmpty((String)lastDraftName)) {
                draftPage = this.wikiService.getDraft(lastDraftName);
            }
            if (draftPage == null) {
                DraftPage newDraftPage = new DraftPage();
                newDraftPage.setTitle(title);
                newDraftPage.setContent(content);
                draftPage = !isNewPage ? this.wikiService.createDraftForExistPage(newDraftPage, page, pageRevision, clientTime) : this.wikiService.createDraftForNewPage(newDraftPage, page, clientTime);
            } else {
                if ("".equals(title)) {
                    draftPage.setTitle(draftPage.getName());
                } else {
                    draftPage.setTitle(title);
                }
                draftPage.setContent(content);
                this.wikiService.updatePage(draftPage, null);
            }
            Utils.logEditPageTime(param, Utils.getCurrentUser(), System.currentTimeMillis(), draftPage.getName(), isNewPage);
            return Response.ok((Object)new DraftData(draftPage.getName()), (String)"application/json").cacheControl(this.cc).build();
        }
        catch (UnsupportedEncodingException uee) {
            log.warn((Object)"Cannot decode page name");
            return Response.status((int)500).cacheControl(this.cc).build();
        }
        catch (Exception ex) {
            if (StringUtils.isEmpty(pageId)) {
                pageId = rawPageId;
            }
            log.warn((Object)String.format("Failed to perform auto save wiki page %s:%s:%s", wikiType, wikiOwner, pageId), (Throwable)ex);
            return Response.status((int)500).cacheControl(this.cc).build();
        }
    }

    @GET
    @Path(value="/removeDraft/")
    @RolesAllowed(value={"users"})
    public Response removeDraft(@QueryParam(value="draftName") String draftName) {
        if (StringUtils.isEmpty((String)draftName)) {
            return Response.status((int)400).cacheControl(this.cc).build();
        }
        try {
            this.wikiService.removeDraft(draftName);
            return Response.ok().cacheControl(this.cc).build();
        }
        catch (Exception e) {
            return Response.status((int)500).cacheControl(this.cc).build();
        }
    }

    @GET
    @Path(value="/emoticons/{name}")
    public Response getEmotionIcon(@Context UriInfo uriInfo, @PathParam(value="name") String name) {
        try {
            EmotionIcon emotionIcon = this.wikiService.getEmotionIconByName(name);
            if (emotionIcon == null) {
                return Response.status((int)404).build();
            }
            ByteArrayInputStream emotionIconImage = new ByteArrayInputStream(emotionIcon.getImage());
            return Response.ok((Object)emotionIconImage).cacheControl(this.cc).build();
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Can't get emotion icon: %s", name), (Throwable)e);
            }
            return Response.status((int)500).cacheControl(this.cc).build();
        }
    }

    private void encodeWikiTree(List<JsonNodeData> responseData, Locale locale) throws Exception {
        ResourceBundle resourceBundle = this.resourceBundleService.getResourceBundle("locale.wiki.service.WikiService", locale);
        String untitledLabel = "";
        if (resourceBundle == null) {
            log.warn("Cannot find resource bundle '{}'", new Object[]{"locale.wiki.service.WikiService"});
        } else {
            untitledLabel = resourceBundle.getString("Page.Untitled");
        }
        for (JsonNodeData data : responseData) {
            if (StringUtils.isBlank((String)data.getName())) {
                data.setName(untitledLabel);
            }
            if (!CollectionUtils.isNotEmpty(data.children)) continue;
            this.encodeWikiTree(data.children, locale);
        }
    }
}

