/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.webui.extension;

import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.wiki.commons.Utils;
import org.exoplatform.wiki.mow.api.WikiPreferences;
import org.exoplatform.wiki.mow.api.WikiPreferencesSyntax;
import org.exoplatform.wiki.webui.UIWikiPortlet;
import org.exoplatform.wiki.webui.UIWikiSyntaxPreferences;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/wiki/webui/extension/UISyntaxSettingForm.gtmpl", events={@EventConfig(listeners={SaveActionListener.class})})
public class UISyntaxSettingForm
extends UIForm {
    private static final Log log = ExoLogger.getExoLogger(UISyntaxSettingForm.class);
    public static final String PREFERENCES_SYNTAX = "PreferencesSyntax";

    public UISyntaxSettingForm() throws Exception {
        this.addUIFormInput(new UIWikiSyntaxPreferences(PREFERENCES_SYNTAX));
    }

    public void updateData() {
        try {
            UIWikiSyntaxPreferences uiWikiSyntaxPreferences = (UIWikiSyntaxPreferences)this.getChildById(PREFERENCES_SYNTAX);
            if (uiWikiSyntaxPreferences != null) {
                uiWikiSyntaxPreferences.updateData();
            }
        }
        catch (Exception e) {
            log.warn((Object)"Can not update data for syntax setting form", (Throwable)e);
        }
    }

    public static class SaveActionListener
    extends EventListener<UISyntaxSettingForm> {
        public void execute(Event<UISyntaxSettingForm> event) throws Exception {
            UIWikiPortlet wikiPortlet = (UIWikiPortlet)((UISyntaxSettingForm)((Object)event.getSource())).getAncestorOfType(UIWikiPortlet.class);
            UIWikiSyntaxPreferences uiSyntaxPreferences = (UIWikiSyntaxPreferences)wikiPortlet.findComponentById(UISyntaxSettingForm.PREFERENCES_SYNTAX);
            UIFormCheckBoxInput allowCheckBox = (UIFormCheckBoxInput)uiSyntaxPreferences.getChildById("AllowChooseOthers");
            WikiPreferences preferences = Utils.getCurrentPreferences();
            WikiPreferencesSyntax preferencesSyntax = preferences.getWikiPreferencesSyntax();
            preferencesSyntax.setAllowMultipleSyntaxes(allowCheckBox.isChecked());
            event.getRequestContext().getUIApplication().addMessage(new ApplicationMessage("UISyntaxSettingForm.msg.Save-syntax-setting-success", null, 2));
        }
    }
}

