/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.webui;

import org.exoplatform.container.PortalContainer;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.lifecycle.Lifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.wiki.service.WikiPageParams;
import org.exoplatform.wiki.service.WikiService;
import org.exoplatform.wiki.tree.utils.TreeUtils;
import org.exoplatform.wiki.webui.UIWikiBreadCrumb;

@ComponentConfig(lifecycle=Lifecycle.class, template="app:/templates/wiki/webui/UIWikiLocationContainer.gtmpl", events={@EventConfig(listeners={ChangeNewLocationActionListener.class})})
public class UIWikiLocationContainer
extends UIContainer {
    public static final String CURRENT_LOCATION = "currentLocation";
    public static final String NEW_LOCATION = "newLocation";
    public static final String CHANGE_NEWLOCATION = "ChangeNewLocation";

    public UIWikiLocationContainer() throws Exception {
        ((UIWikiBreadCrumb)this.addChild(UIWikiBreadCrumb.class, null, CURRENT_LOCATION)).setLink(false).setShowWikiType(false);
        ((UIWikiBreadCrumb)this.addChild(UIWikiBreadCrumb.class, null, NEW_LOCATION)).setLink(false).setShowWikiType(false);
    }

    public static class ChangeNewLocationActionListener
    extends EventListener<UIWikiLocationContainer> {
        public void execute(Event<UIWikiLocationContainer> event) throws Exception {
            WikiService wikiService = (WikiService)PortalContainer.getComponent(WikiService.class);
            UIWikiLocationContainer container = (UIWikiLocationContainer)((Object)event.getSource());
            UIWikiBreadCrumb newlocation = (UIWikiBreadCrumb)container.getChildById(UIWikiLocationContainer.NEW_LOCATION);
            String value = event.getRequestContext().getRequestParameter("objectId");
            WikiPageParams params = TreeUtils.getPageParamsFromPath((String)value);
            newlocation.setBreadCumbs(wikiService.getBreadcumb(params.getType(), params.getOwner(), params.getPageName()));
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)newlocation);
        }
    }
}

