/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.webui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.ext.UIExtensionManager;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.input.UICheckBoxInput;
import org.exoplatform.wiki.commons.Utils;
import org.exoplatform.wiki.mow.api.PageVersion;
import org.exoplatform.wiki.service.WikiService;
import org.exoplatform.wiki.webui.WikiMode;
import org.exoplatform.wiki.webui.control.action.RestoreRevisionActionComponent;
import org.exoplatform.wiki.webui.control.action.ViewRevisionActionListener;
import org.exoplatform.wiki.webui.core.UIWikiForm;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/wiki/webui/UIWikiPageVersionsList.gtmpl", events={@EventConfig(listeners={ViewRevisionActionListener.class}), @EventConfig(listeners={CompareRevisionActionListener.class})})
public class UIWikiPageVersionsList
extends UIWikiForm {
    private List<PageVersion> versionsList;
    public static final String RESTORE_ACTION = "RestoreRevision";
    public static final String VIEW_REVISION = "ViewRevision";
    public static final String COMPARE_ACTION = "CompareRevision";
    public static final String EXTENSION_TYPE = "org.exoplatform.wiki.webui.UIWikiPageVersionsList";
    public static final String VERSION_NAME_PREFIX = "version";
    private WikiService wikiService = (WikiService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(WikiService.class);

    public UIWikiPageVersionsList() throws Exception {
        this.accept_Modes = Arrays.asList(WikiMode.SHOWHISTORY, WikiMode.VIEW);
    }

    @Override
    public void processRender(WebuiRequestContext context) throws Exception {
        this.versionsList = this.wikiService.getVersionsOfPage(Utils.getCurrentWikiPage());
        this.getChildren().clear();
        for (PageVersion version : this.versionsList) {
            this.addUIFormInput((UIFormInput)new UICheckBoxInput("version_" + version.getName(), "", Boolean.valueOf(false)));
        }
        this.addChild(RestoreRevisionActionComponent.class, null, null);
        super.processRender(context);
    }

    public List<PageVersion> getVersionsList() throws Exception {
        return this.versionsList;
    }

    protected void renderRestoreRevisionActions(String versionName) throws Exception {
        if (versionName == null || this.versionsList.isEmpty()) {
            return;
        }
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        ResourceBundle bundle = context.getApplicationResourceBundle();
        RestoreRevisionActionComponent component = (RestoreRevisionActionComponent)this.getChild(RestoreRevisionActionComponent.class);
        component.setVersionName(versionName);
        component.setCurrentVersion(versionName.equals(this.versionsList.get(0).getName()));
        component.setLabel(bundle.getString("UIWikiPageVersionsList.label.RestoreRevision"));
        component.setTooltip(bundle.getString("UIWikiPageVersionsList.title.RestoreVersion"));
        UIExtensionManager manager = (UIExtensionManager)this.getApplicationComponent(UIExtensionManager.class);
        if (manager.accept(EXTENSION_TYPE, RESTORE_ACTION, null)) {
            this.renderChild(RestoreRevisionActionComponent.class);
        }
    }

    public static class CompareRevisionActionListener
    extends org.exoplatform.wiki.webui.control.action.CompareRevisionActionListener {
        @Override
        public void execute(Event<UIComponent> event) throws Exception {
            UIWikiPageVersionsList uiForm = (UIWikiPageVersionsList)((Object)event.getSource());
            ArrayList<PageVersion> checkedVersions = new ArrayList<PageVersion>();
            WikiService wikiService = (WikiService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(WikiService.class);
            List versions = wikiService.getVersionsOfPage(Utils.getCurrentWikiPage());
            for (PageVersion version : versions) {
                UICheckBoxInput uiCheckBox = uiForm.getUICheckBoxInput("version_" + version.getName());
                if (!uiCheckBox.isChecked()) continue;
                checkedVersions.add(version);
            }
            if (checkedVersions.size() != 2) {
                event.getRequestContext().getUIApplication().addMessage(new ApplicationMessage("UIWikiPageVersionsList.msg.checkGroup-required", null, 1));
                return;
            }
            this.setVersionToCompare(versions);
            String fromVersionName = ((PageVersion)checkedVersions.get(0)).getName();
            String toVersionName = ((PageVersion)checkedVersions.get(1)).getName();
            for (int i = 0; i < versions.size(); ++i) {
                PageVersion version = (PageVersion)versions.get(i);
                if (version.getName().equals(fromVersionName)) {
                    this.setFrom(i);
                }
                if (!version.getName().equals(toVersionName)) continue;
                this.setTo(i);
            }
            super.execute(event);
        }
    }
}

