/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.webui;

import java.util.Arrays;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.lifecycle.Lifecycle;
import org.exoplatform.wiki.commons.Utils;
import org.exoplatform.wiki.mow.api.Page;
import org.exoplatform.wiki.mow.api.PageVersion;
import org.exoplatform.wiki.service.WikiService;
import org.exoplatform.wiki.webui.UIWikiContentDisplay;
import org.exoplatform.wiki.webui.UIWikiPageControlArea;
import org.exoplatform.wiki.webui.UIWikiPortlet;
import org.exoplatform.wiki.webui.UIWikiVersionSelect;
import org.exoplatform.wiki.webui.WikiMode;
import org.exoplatform.wiki.webui.core.UIWikiContainer;

@ComponentConfig(lifecycle=Lifecycle.class, template="app:/templates/wiki/webui/UIWikiPageContentArea.gtmpl")
public class UIWikiPageContentArea
extends UIWikiContainer {
    public static final String VIEW_DISPLAY = "UIViewContentDisplay";
    private WikiService wikiService = (WikiService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(WikiService.class);

    public UIWikiPageContentArea() throws Exception {
        this.accept_Modes = Arrays.asList(WikiMode.VIEW, WikiMode.VIEWREVISION);
        this.addChild(UIWikiPageControlArea.class, null, null);
        this.addChild(UIWikiVersionSelect.class, null, null);
        this.addChild(UIWikiContentDisplay.class, null, VIEW_DISPLAY);
    }

    @Override
    public void processRender(WebuiRequestContext context) throws Exception {
        this.renderVersion();
        super.processRender(context);
    }

    private void renderVersion() throws Exception {
        String currentVersionName = ((UIWikiVersionSelect)this.getChild(UIWikiVersionSelect.class)).getVersionName();
        UIWikiPortlet wikiPortlet = (UIWikiPortlet)this.getAncestorOfType(UIWikiPortlet.class);
        WikiMode currentMode = wikiPortlet.getWikiMode();
        UIWikiContentDisplay contentDisplay = (UIWikiContentDisplay)this.getChildById(VIEW_DISPLAY);
        Page wikipage = Utils.getCurrentWikiPage();
        try {
            PageVersion version;
            if (currentMode.equals((Object)WikiMode.VIEW)) {
                contentDisplay.setHtmlOutput(this.wikiService.getPageRenderedContent(wikipage));
            }
            if (currentMode.equals((Object)WikiMode.VIEWREVISION) && currentVersionName != null && (version = this.wikiService.getVersionOfPageByName(currentVersionName, wikipage)) != null) {
                contentDisplay.setHtmlOutput(this.wikiService.getPageRenderedContent((Page)version));
            }
        }
        catch (Exception e) {
            contentDisplay.setHtmlOutput("Bad syntax in content! Cannot generate HTML content!");
        }
    }
}

