/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.service.impl;

import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.application.RequestNavigationData;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.web.application.Application;
import org.exoplatform.web.application.ApplicationLifecycle;
import org.exoplatform.web.application.RequestFailure;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.wiki.service.WikiPageParams;
import org.exoplatform.wiki.service.WikiService;
import org.exoplatform.wiki.utils.Utils;

public class WikiSpaceAccessLifecycle
implements ApplicationLifecycle<WebuiRequestContext> {
    private static final String WIKI_PORTLET_NAME = "wiki";

    public void onInit(Application app) {
    }

    public void onStartRequest(Application app, WebuiRequestContext context) throws Exception {
        PortalRequestContext pcontext = (PortalRequestContext)context;
        String requestPath = pcontext.getControllerContext().getParameter(RequestNavigationData.REQUEST_PATH);
        if (pcontext.getSiteType().equals((Object)SiteType.GROUP) && pcontext.getSiteName().startsWith("/spaces") && requestPath != null && requestPath.length() > 0) {
            String currentUser = Utils.getCurrentUser();
            String[] params = requestPath.split("/");
            if (params.length > 1 && params[1].equals(WIKI_PORTLET_NAME)) {
                WikiService wikiService;
                String spaceId = params[0];
                String owner = "/spaces/" + spaceId;
                String pageId = "WikiHome";
                if (params.length > 2) {
                    pageId = params[2];
                }
                if (!(wikiService = (WikiService)PortalContainer.getComponent(WikiService.class)).isHiddenSpace(owner) && !wikiService.isSpaceMember(spaceId, currentUser)) {
                    WikiPageParams wikiPageParams = new WikiPageParams(PortalConfig.GROUP_TYPE, owner, pageId);
                    String permalink = Utils.getPermanlink(wikiPageParams);
                    WikiSpaceAccessLifecycle.redirect(permalink);
                }
            }
        }
    }

    private static void redirect(String url) throws Exception {
        PortalRequestContext portalRequestContext = Util.getPortalRequestContext();
        portalRequestContext.sendRedirect(url);
    }

    public void onFailRequest(Application app, WebuiRequestContext context, RequestFailure failureType) {
    }

    public void onEndRequest(Application app, WebuiRequestContext context) throws Exception {
    }

    public void onDestroy(Application app) {
    }
}

