/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.service.jcrext;

import java.util.List;
import javax.jcr.Node;
import org.apache.commons.chain.Context;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.services.command.action.Action;
import org.exoplatform.services.ext.action.InvocationContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.wiki.mow.api.Page;
import org.exoplatform.wiki.mow.core.api.MOWService;
import org.exoplatform.wiki.mow.core.api.wiki.PageImpl;
import org.exoplatform.wiki.service.WikiService;
import org.exoplatform.wiki.service.listener.PageWikiListener;
import org.exoplatform.wiki.utils.Utils;

public class WikiPageJcrListener
implements Action {
    private static final Log log = ExoLogger.getLogger(WikiPageJcrListener.class);

    public boolean execute(Context context) throws Exception {
        String pageId;
        String owner;
        String wikiType;
        Object currentItemObj = context.get((Object)InvocationContext.CURRENT_ITEM);
        ExoContainer container = (ExoContainer)context.get((Object)InvocationContext.EXO_CONTAINER);
        WikiService wikiService = (WikiService)container.getComponentInstanceOfType(WikiService.class);
        MOWService mowService = (MOWService)container.getComponentInstanceOfType(MOWService.class);
        Node pageNode = (Node)currentItemObj;
        Page page = (Page)mowService.getSession().findByNode(PageImpl.class, pageNode);
        if (pageNode.isNodeType("wiki:helppage") || pageNode.isNodeType("wiki:template")) {
            return false;
        }
        if (pageNode.getVersionHistory().getAllVersions().getSize() < 2L) {
            return false;
        }
        String pageJcrPath = pageNode.getPath();
        try {
            wikiType = Utils.getWikiType(pageJcrPath);
            owner = Utils.getSpaceIdByJcrPath(pageJcrPath);
            pageId = pageNode.getName();
        }
        catch (IllegalArgumentException ie) {
            if (log.isWarnEnabled()) {
                log.warn((Object)String.format("can not get wikiType and owner from [%s]", pageJcrPath), (Throwable)ie);
            }
            return false;
        }
        List<PageWikiListener> listeners = wikiService.getPageListeners();
        if (pageNode.getVersionHistory().getAllVersions().getSize() == 2L) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Executing listener [%s] on item [%s] for adding new page event!", this.toString(), pageNode.getPath()));
            }
            for (PageWikiListener l : listeners) {
                try {
                    l.postAddPage(wikiType, owner, pageId, page);
                }
                catch (Exception e) {
                    if (!log.isWarnEnabled()) continue;
                    log.warn((Object)String.format("executing listener [%s] on [%s] failed", ((Object)((Object)l)).toString(), pageNode.getPath()), (Throwable)e);
                }
            }
        } else {
            for (PageWikiListener l : listeners) {
                try {
                    l.postUpdatePage(wikiType, owner, pageId, page);
                }
                catch (Exception e) {
                    if (!log.isWarnEnabled()) continue;
                    log.warn((Object)String.format("executing listener [%s] on [%s] failed", ((Object)((Object)l)).toString(), pageNode.getPath()), (Throwable)e);
                }
            }
        }
        return false;
    }
}

