/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.service.search;

import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import org.chromattic.api.NoSuchNodeException;
import org.chromattic.api.UndeclaredRepositoryException;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.wiki.utils.Utils;

public class SearchData {
    public String text;
    public String title;
    public String content;
    public String wikiType;
    public String wikiOwner;
    public String pageId;
    public String jcrQueryPath;
    private long offset = 0L;
    protected String sort;
    protected String order;
    public int limit = Integer.MAX_VALUE;
    public static final String ALL_PATH = "%/";
    protected static String PORTAL_PATH = "/exo:applications/eXoWiki/wikis/%/";
    protected static String GROUP_PATH = "/Groups/%/ApplicationData/eXoWiki/";
    protected String USER_PATH = "/Users/%/ApplicationData/eXoWiki/";

    public SearchData(String text, String title, String content, String wikiType, String wikiOwner, String pageId) {
        this.text = text;
        this.title = title;
        this.content = content;
        this.wikiType = wikiType;
        this.wikiOwner = Utils.validateWikiOwner(wikiType, wikiOwner);
        this.pageId = pageId;
        if (PortalConfig.USER_TYPE.equals(wikiType)) {
            NodeHierarchyCreator nodeHierachyCreator = (NodeHierarchyCreator)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(NodeHierarchyCreator.class);
            try {
                if (wikiOwner != null && wikiOwner.length() > 0) {
                    Node userNode = nodeHierachyCreator.getUserApplicationNode(Utils.createSystemProvider(), wikiOwner);
                    this.USER_PATH = userNode.getPath() + "/" + "eXoWiki" + "/";
                }
            }
            catch (Exception e) {
                if (e instanceof PathNotFoundException) {
                    throw new NoSuchNodeException((Throwable)e);
                }
                throw new UndeclaredRepositoryException(e.getMessage());
            }
        }
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getWikiType() {
        return this.wikiType;
    }

    public void setWikiType(String wikiType) {
        this.wikiType = wikiType;
    }

    public String getWikiOwner() {
        return this.wikiOwner;
    }

    public void setWikiOwner(String wikiOwner) {
        this.wikiOwner = wikiOwner;
    }

    public String getPageId() {
        return this.pageId;
    }

    public void setPageId(String pageId) {
        this.pageId = pageId;
    }

    public String getJcrQueryPath() {
        return this.jcrQueryPath;
    }

    public void setJcrQueryPath(String jcrQueryPath) {
        this.jcrQueryPath = jcrQueryPath;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public String getStatementForSearchingTitle() {
        return null;
    }

    public long getOffset() {
        return this.offset;
    }

    public void setOffset(long offset) {
        this.offset = offset;
    }

    public String getSort() {
        return this.sort;
    }

    public void setSort(String sort) {
        this.sort = sort;
    }

    public String getOrder() {
        return this.order;
    }

    public void setOrder(String order) {
        this.order = order;
    }
}

