/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.tree;

import java.net.URLEncoder;
import java.util.HashMap;
import java.util.List;
import org.exoplatform.wiki.tree.TreeNode;
import org.exoplatform.wiki.tree.TreeNodeType;
import org.exoplatform.wiki.tree.utils.TreeUtils;

public class JsonNodeData {
    protected String name;
    protected String path;
    protected String currentPath;
    protected boolean hasChild;
    protected TreeNodeType nodeType;
    protected boolean isLastNode;
    protected boolean isSelectable;
    protected boolean isRetricted = false;
    protected boolean isExpanded = false;
    protected boolean isSelected = false;
    protected String excerpt = "";
    public static final String CURRENT_PATH = "currentPath";
    public List<JsonNodeData> children;

    public JsonNodeData(TreeNode treeNode, boolean isLastNode, boolean isSelectable, String currentPath, String excerpt, HashMap<String, Object> context) throws Exception {
        this.name = treeNode.getName();
        this.path = URLEncoder.encode(treeNode.getPath(), "utf-8");
        if (currentPath != null) {
            this.currentPath = URLEncoder.encode(currentPath, "utf-8");
        }
        this.hasChild = treeNode.isHasChild();
        this.nodeType = treeNode.getNodeType();
        this.isLastNode = isLastNode;
        this.isSelectable = isSelectable;
        this.excerpt = excerpt;
        this.children = TreeUtils.tranformToJson(treeNode, context);
        this.isSelected = treeNode.isSelected();
        this.isRetricted = treeNode.isRetricted;
        if (this.children.size() > 0) {
            this.isExpanded = true;
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public boolean isHasChild() {
        return this.hasChild;
    }

    public void setHasChild(boolean hasChild) {
        this.hasChild = hasChild;
    }

    public TreeNodeType getNodeType() {
        return this.nodeType;
    }

    public void setNodeType(TreeNodeType nodeType) {
        this.nodeType = nodeType;
    }

    public boolean isLastNode() {
        return this.isLastNode;
    }

    public void setLastNode(boolean isLastNode) {
        this.isLastNode = isLastNode;
    }

    public boolean isSelectable() {
        return this.isSelectable;
    }

    public void setSelectable(boolean isSelectable) {
        this.isSelectable = isSelectable;
    }

    public boolean isRetricted() {
        return this.isRetricted;
    }

    public void setRetricted(boolean isRetricted) {
        this.isRetricted = isRetricted;
    }

    public String getCurrentPath() {
        return this.currentPath;
    }

    public void setCurrentPath(String currentPath) {
        this.currentPath = currentPath;
    }

    public boolean isExpanded() {
        return this.isExpanded;
    }

    public void setExpanded(boolean isExpanded) {
        this.isExpanded = isExpanded;
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public void setSelected(boolean isSelected) {
        this.isSelected = isSelected;
    }

    public String getExcerpt() {
        return this.excerpt;
    }

    public void setExcerpt(String excerpt) {
        this.excerpt = excerpt;
    }

    public List<JsonNodeData> getChildren() {
        return this.children;
    }

    public void setChildren(List<JsonNodeData> children) {
        this.children = children;
    }
}

