/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.mow.core.api.wiki;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.exoplatform.services.jcr.access.AccessControlEntry;
import org.exoplatform.services.jcr.access.AccessControlList;
import org.exoplatform.services.jcr.access.PermissionType;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.wiki.mow.api.Permission;
import org.exoplatform.wiki.utils.Utils;

public class PermissionImpl
extends Permission {
    @Override
    public HashMap<String, String[]> getPermission(String jcrPath) throws Exception {
        ExtendedNode extendedNode = (ExtendedNode)this.getJCRNode(jcrPath);
        HashMap<String, String[]> perm = new HashMap<String, String[]>();
        AccessControlList acl = extendedNode.getACL();
        List aceList = acl.getPermissionEntries();
        int length = aceList.size();
        for (int i = 0; i < length; ++i) {
            AccessControlEntry ace = (AccessControlEntry)aceList.get(i);
            String[] nodeActions = perm.get(ace.getIdentity());
            ArrayList<Object> actions = null;
            actions = nodeActions != null ? new ArrayList<String>(Arrays.asList(nodeActions)) : new ArrayList<String>();
            actions.add(ace.getPermission());
            perm.put(ace.getIdentity(), actions.toArray(new String[actions.size()]));
        }
        return perm;
    }

    @Override
    public boolean hasPermission(org.exoplatform.wiki.service.PermissionType permissionType, String jcrPath) throws Exception {
        ConversationState conversationState = ConversationState.getCurrent();
        Identity user = null;
        user = conversationState != null ? conversationState.getIdentity() : new Identity(IdentityConstants.ANONIM);
        return this.hasPermission(permissionType, jcrPath, user);
    }

    @Override
    public boolean hasPermission(org.exoplatform.wiki.service.PermissionType permissionType, String jcrPath, Identity user) throws Exception {
        String[] permission = new String[]{};
        if (org.exoplatform.wiki.service.PermissionType.VIEWPAGE.equals((Object)permissionType) || org.exoplatform.wiki.service.PermissionType.VIEW_ATTACHMENT.equals((Object)permissionType)) {
            permission = new String[]{"read"};
        } else if (org.exoplatform.wiki.service.PermissionType.EDITPAGE.equals((Object)permissionType) || org.exoplatform.wiki.service.PermissionType.EDIT_ATTACHMENT.equals((Object)permissionType)) {
            permission = new String[]{"add_node", "remove", "set_property"};
        }
        ExtendedNode extendedNode = (ExtendedNode)this.getJCRNode(jcrPath);
        AccessControlList acl = extendedNode.getACL();
        return Utils.hasPermission(acl, permission, user);
    }

    @Override
    public void setPermission(HashMap<String, String[]> permissions, String jcrPath) throws Exception {
        this.getChromatticSession().save();
        ExtendedNode extendedNode = (ExtendedNode)this.getJCRNode(jcrPath);
        if (extendedNode.canAddMixin("exo:privilegeable")) {
            extendedNode.addMixin("exo:privilegeable");
        }
        if (permissions != null && permissions.size() > 0) {
            extendedNode.setPermissions(permissions);
        } else {
            extendedNode.clearACL();
            extendedNode.setPermission(IdentityConstants.ANY, PermissionType.ALL);
        }
    }
}

