/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.service.impl;

import org.chromattic.api.ChromatticSession;
import org.chromattic.api.event.LifeCycleListener;
import org.chromattic.api.event.StateChangeListener;
import org.chromattic.ext.ntdef.NTResource;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.wiki.chromattic.ext.ntdef.NTFrozenNode;
import org.exoplatform.wiki.chromattic.ext.ntdef.NTVersionHistory;
import org.exoplatform.wiki.mow.api.Wiki;
import org.exoplatform.wiki.mow.core.api.MOWService;
import org.exoplatform.wiki.mow.core.api.wiki.AttachmentImpl;
import org.exoplatform.wiki.mow.core.api.wiki.MigratingMixin;
import org.exoplatform.wiki.mow.core.api.wiki.PageImpl;
import org.exoplatform.wiki.mow.core.api.wiki.WatchedMixin;
import org.exoplatform.wiki.mow.core.api.wiki.WikiContainer;
import org.exoplatform.wiki.rendering.RenderingService;
import org.exoplatform.wiki.service.WikiService;
import org.exoplatform.wiki.utils.Utils;

public class Injector
implements LifeCycleListener,
StateChangeListener {
    private final MOWService mowService;
    private final WikiService wService;
    private final RenderingService renderingService;
    private static final Log log = ExoLogger.getLogger((String)"org.exoplatform.wiki.service.impl.Injector");

    public Injector(MOWService mowService, WikiService wService, RenderingService renderingService) {
        this.mowService = mowService;
        this.wService = wService;
        this.renderingService = renderingService;
    }

    public void added(String id, String path, String name, Object o) {
        if (o instanceof PageImpl) {
            ((PageImpl)o).setMOWService(this.mowService);
            ((PageImpl)o).setWikiService(this.wService);
            ((PageImpl)o).setComponentManager(this.renderingService.getComponentManager());
        }
        if (o instanceof WikiContainer) {
            ((WikiContainer)o).setwService(this.wService);
        }
        if (o instanceof NTFrozenNode) {
            ((NTFrozenNode)o).setMOWService(this.mowService);
        }
    }

    public void created(Object o) {
        if (o instanceof PageImpl) {
            ((PageImpl)o).setMOWService(this.mowService);
            ((PageImpl)o).setWikiService(this.wService);
            ((PageImpl)o).setComponentManager(this.renderingService.getComponentManager());
        }
        if (o instanceof WikiContainer) {
            ((WikiContainer)o).setwService(this.wService);
        }
        if (o instanceof NTFrozenNode) {
            ((NTFrozenNode)o).setMOWService(this.mowService);
        }
    }

    public void loaded(String id, String path, String name, Object o) {
        if (o instanceof PageImpl) {
            ((PageImpl)o).setMOWService(this.mowService);
            ((PageImpl)o).setWikiService(this.wService);
            ((PageImpl)o).setComponentManager(this.renderingService.getComponentManager());
        }
        if (o instanceof WikiContainer) {
            ((WikiContainer)o).setwService(this.wService);
        }
        if (o instanceof NTFrozenNode) {
            ((NTFrozenNode)o).setMOWService(this.mowService);
        }
    }

    public void removed(String id, String path, String name, Object o) {
        if (o instanceof PageImpl) {
            ((PageImpl)o).setMOWService(this.mowService);
            ((PageImpl)o).setWikiService(this.wService);
            ((PageImpl)o).setComponentManager(this.renderingService.getComponentManager());
        }
        if (o instanceof NTFrozenNode) {
            ((NTFrozenNode)o).setMOWService(this.mowService);
        }
    }

    public void propertyChanged(String id, Object o, String propertyName, Object propertyValue) {
        ChromatticSession session;
        String path;
        if (o instanceof NTResource && "jcr:data".equals(propertyName) && (path = (session = this.mowService.getSession()).getPath(o)).endsWith("content")) {
            if ((path = path.substring(0, path.lastIndexOf("/"))).startsWith("/")) {
                path = path.substring(1);
            }
            AttachmentImpl content = (AttachmentImpl)session.findByPath(AttachmentImpl.class, path);
            try {
                PageImpl page = content.getParentPage();
                WatchedMixin mixin = page.getWatchedMixin();
                MigratingMixin migrateMix = page.getMigratingMixin();
                if (mixin != null && migrateMix == null) {
                    NTVersionHistory history;
                    boolean isWatched = !mixin.getWatchers().isEmpty();
                    Wiki wiki = page.getWiki();
                    boolean isMinorEdit = page.isMinorEdit();
                    if (wiki != null && isWatched && !isMinorEdit && (history = page.getVersionableMixin().getVersionHistory()) != null && history.getChildren().size() > 1) {
                        Utils.sendMailOnChangeContent(content);
                    }
                }
            }
            catch (Exception e) {
                log.warn((Object)"Can not notify wiki page changes by email !", (Throwable)e);
            }
        }
    }
}

