/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.service.search;

import java.lang.reflect.InvocationTargetException;
import java.util.Calendar;
import org.exoplatform.container.ExoContainerContext;

public class SearchResult {
    protected String excerpt;
    protected String title;
    protected String path;
    protected String type;
    protected String pageName;
    protected String url;
    protected long jcrScore;
    protected Calendar updatedDate;
    protected Calendar createdDate;

    public SearchResult() {
    }

    public SearchResult(String excerpt, String title, String path, String type, Calendar updatedDate, Calendar createdDate) {
        this.excerpt = excerpt;
        this.title = title;
        this.path = path;
        this.type = type;
        this.updatedDate = updatedDate;
        this.createdDate = createdDate;
        this.evaluatePageName(path);
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    public void setExcerpt(String text) {
        this.excerpt = text;
    }

    public String getExcerpt() throws ClassNotFoundException, IllegalArgumentException, SecurityException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Class<?> sanitizeUtils = Class.forName("org.exoplatform.wcm.webui.Utils");
        Object sanitize = ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(sanitizeUtils);
        return (String)sanitizeUtils.getDeclaredMethod("sanitize", String.class).invoke(sanitize, this.excerpt);
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    private void evaluatePageName(String path) {
        if ("wiki:page".equals(this.type)) {
            this.setPageName(path.substring(path.lastIndexOf("/")));
        } else if ("wiki:attachment".equals(this.type) || "wiki:content".equals(this.type)) {
            String temp = path.substring(0, path.lastIndexOf("/"));
            this.setPageName(temp.substring(temp.lastIndexOf("/")));
        }
    }

    public void setPageName(String pageName) {
        this.pageName = pageName;
    }

    public String getPageName() {
        return this.pageName;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUrl() {
        return this.url;
    }

    public void setJcrScore(long jcrScore) {
        this.jcrScore = jcrScore;
    }

    public long getJcrScore() {
        return this.jcrScore;
    }

    public Calendar getUpdatedDate() {
        return this.updatedDate;
    }

    public void setUpdatedDate(Calendar updatedDate) {
        this.updatedDate = updatedDate;
    }

    public Calendar getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(Calendar createdDate) {
        this.createdDate = createdDate;
    }
}

