/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.service.impl;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.commons.collections.IteratorUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.chromattic.api.ChromatticSession;
import org.chromattic.api.query.QueryResult;
import org.exoplatform.commons.chromattic.ChromatticManager;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.ObjectPageList;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.container.component.ComponentRequestLifecycle;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.PropertiesParam;
import org.exoplatform.container.xml.ValuesParam;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.services.deployment.plugins.XMLDeploymentPlugin;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.access.AccessControlEntry;
import org.exoplatform.services.jcr.access.AccessControlList;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.wiki.mow.api.DraftPage;
import org.exoplatform.wiki.mow.api.Model;
import org.exoplatform.wiki.mow.api.Page;
import org.exoplatform.wiki.mow.api.Wiki;
import org.exoplatform.wiki.mow.api.WikiStore;
import org.exoplatform.wiki.mow.api.WikiType;
import org.exoplatform.wiki.mow.core.api.MOWService;
import org.exoplatform.wiki.mow.core.api.WikiStoreImpl;
import org.exoplatform.wiki.mow.core.api.wiki.AttachmentImpl;
import org.exoplatform.wiki.mow.core.api.wiki.DraftPageImpl;
import org.exoplatform.wiki.mow.core.api.wiki.HelpPage;
import org.exoplatform.wiki.mow.core.api.wiki.LinkEntry;
import org.exoplatform.wiki.mow.core.api.wiki.LinkRegistry;
import org.exoplatform.wiki.mow.core.api.wiki.MovedMixin;
import org.exoplatform.wiki.mow.core.api.wiki.PageImpl;
import org.exoplatform.wiki.mow.core.api.wiki.PortalWiki;
import org.exoplatform.wiki.mow.core.api.wiki.RemovedMixin;
import org.exoplatform.wiki.mow.core.api.wiki.RenamedMixin;
import org.exoplatform.wiki.mow.core.api.wiki.Template;
import org.exoplatform.wiki.mow.core.api.wiki.TemplateContainer;
import org.exoplatform.wiki.mow.core.api.wiki.Trash;
import org.exoplatform.wiki.mow.core.api.wiki.UserWiki;
import org.exoplatform.wiki.mow.core.api.wiki.WikiContainer;
import org.exoplatform.wiki.mow.core.api.wiki.WikiHome;
import org.exoplatform.wiki.mow.core.api.wiki.WikiImpl;
import org.exoplatform.wiki.rendering.cache.PageRenderingCacheService;
import org.exoplatform.wiki.rendering.util.Utils;
import org.exoplatform.wiki.resolver.TitleResolver;
import org.exoplatform.wiki.service.BreadcrumbData;
import org.exoplatform.wiki.service.IDType;
import org.exoplatform.wiki.service.MetaDataPage;
import org.exoplatform.wiki.service.Permission;
import org.exoplatform.wiki.service.PermissionEntry;
import org.exoplatform.wiki.service.PermissionType;
import org.exoplatform.wiki.service.WikiPageParams;
import org.exoplatform.wiki.service.WikiService;
import org.exoplatform.wiki.service.impl.JCRDataStorage;
import org.exoplatform.wiki.service.impl.SpaceBean;
import org.exoplatform.wiki.service.listener.PageWikiListener;
import org.exoplatform.wiki.service.search.SearchResult;
import org.exoplatform.wiki.service.search.TemplateSearchData;
import org.exoplatform.wiki.service.search.TemplateSearchResult;
import org.exoplatform.wiki.service.search.WikiSearchData;
import org.exoplatform.wiki.template.plugin.WikiTemplatePagePlugin;
import org.picocontainer.Startable;
import org.xwiki.rendering.syntax.Syntax;

public class WikiServiceImpl
implements WikiService,
Startable {
    private static final String UNTITLED_PREFIX = "Untitled_";
    private static final String PREFERENCES = "preferences";
    private static final String DEFAULT_SYNTAX = "defaultSyntax";
    private static final String DEFAULT_WIKI_NAME = "wiki";
    private static final int CIRCULAR_RENAME_FLAG = 1000;
    private static final long DEFAULT_SAVE_DRAFT_SEQUENCE_TIME = 30000L;
    private ConfigurationManager configManager;
    private JCRDataStorage jcrDataStorage;
    private List<ValuesParam> syntaxHelpParams;
    private PropertiesParam preferencesParams;
    private List<ComponentPlugin> plugins_ = new ArrayList<ComponentPlugin>();
    private List<WikiTemplatePagePlugin> templatePagePlugins_ = new ArrayList<WikiTemplatePagePlugin>();
    private static final Log log = ExoLogger.getLogger(WikiServiceImpl.class);
    private long autoSaveInterval;
    private long editPageLivingTime_;
    private String wikiWebappUri;

    public WikiServiceImpl(ConfigurationManager configManager, JCRDataStorage jcrDataStorage, InitParams initParams) {
        String autoSaveIntervalProperty = System.getProperty("wiki.autosave.interval");
        this.autoSaveInterval = autoSaveIntervalProperty == null || autoSaveIntervalProperty.isEmpty() ? 30000L : Long.parseLong(autoSaveIntervalProperty);
        this.configManager = configManager;
        this.jcrDataStorage = jcrDataStorage;
        if (initParams != null) {
            Iterator helps = initParams.getValuesParamIterator();
            this.syntaxHelpParams = helps != null ? IteratorUtils.toList((Iterator)initParams.getValuesParamIterator()) : new ArrayList<ValuesParam>();
            this.preferencesParams = initParams.getPropertiesParam(PREFERENCES);
        }
        this.wikiWebappUri = System.getProperty("wiki.permalink.appuri");
        if (StringUtils.isEmpty((String)this.wikiWebappUri)) {
            this.wikiWebappUri = DEFAULT_WIKI_NAME;
        }
        this.editPageLivingTime_ = Long.parseLong(initParams.getValueParam("wiki.editPage.livingTime").getValue());
    }

    @Override
    public void initDefaultTemplatePage(String path) {
        Model model = this.getModel();
        WikiStoreImpl wStore = (WikiStoreImpl)model.getWikiStore();
        ChromatticSession session = wStore.getSession();
        this.jcrDataStorage.initDefaultTemplatePage(session, this.configManager, path);
    }

    @Override
    public Page createPage(String wikiType, String wikiOwner, String title, String parentId) throws Exception {
        String pageId = TitleResolver.getId(title, false);
        if (this.isExisting(wikiType, wikiOwner, pageId)) {
            throw new Exception();
        }
        Model model = this.getModel();
        WikiImpl wiki = (WikiImpl)this.getWiki(wikiType, wikiOwner, model);
        PageImpl page = wiki.createWikiPage();
        PageImpl parentPage = null;
        parentPage = (PageImpl)this.getPageById(wikiType, wikiOwner, parentId);
        if (parentPage == null) {
            throw new IllegalArgumentException(String.format("[%s]:[%s]:[%s] is not [wikiType]:[wikiOwner]:[pageId] of an existed page!", wikiType, wikiOwner, parentId));
        }
        page.setName(pageId);
        parentPage.addWikiPage(page);
        ConversationState conversationState = ConversationState.getCurrent();
        String creator = null;
        if (conversationState != null && conversationState.getIdentity() != null) {
            creator = conversationState.getIdentity().getUserId();
        }
        page.setOwner(creator);
        this.setFullPermissionForOwner(page, creator);
        page.setTitle(title);
        page.getContent().setText("");
        page.makeVersionable();
        LinkRegistry linkRegistry = wiki.getLinkRegistry();
        String newEntryName = this.getLinkEntryName(wikiType, wikiOwner, pageId);
        String newEntryAlias = this.getLinkEntryAlias(wikiType, wikiOwner, pageId);
        LinkEntry newEntry = linkRegistry.getLinkEntries().get(newEntryName);
        if (newEntry == null) {
            newEntry = linkRegistry.createLinkEntry();
            linkRegistry.getLinkEntries().put(newEntryName, newEntry);
            newEntry.setAlias(newEntryAlias);
            newEntry.setTitle(title);
        }
        newEntry.setNewLink(newEntry);
        model.save();
        return page;
    }

    private void setFullPermissionForOwner(PageImpl page, String owner) throws Exception {
        ConversationState conversationState = ConversationState.getCurrent();
        if (conversationState != null) {
            HashMap<String, String[]> permissions = page.getPermission();
            permissions.put(conversationState.getIdentity().getUserId(), org.exoplatform.services.jcr.access.PermissionType.ALL);
            page.setPermission(permissions);
        }
    }

    @Override
    public boolean isExisting(String wikiType, String wikiOwner, String pageId) throws Exception {
        Model model = this.getModel();
        WikiStoreImpl wStore = (WikiStoreImpl)model.getWikiStore();
        String statement = new WikiSearchData(wikiType, wikiOwner, pageId).getPageConstraint();
        if (statement != null) {
            String wikiHomeId;
            WikiHome page;
            QueryResult result = wStore.getSession().createQueryBuilder(PageImpl.class).where(statement).get().objects();
            boolean isExisted = result.hasNext();
            if (!isExisted && (page = this.getWikiHome(wikiType, wikiOwner)) != null && (wikiHomeId = TitleResolver.getId(page.getTitle(), true)).equals(pageId)) {
                isExisted = true;
            }
            return isExisted;
        }
        return false;
    }

    @Override
    public boolean deletePage(String wikiType, String wikiOwner, String pageId) throws Exception {
        if ("WikiHome".equals(pageId) || pageId == null) {
            return false;
        }
        try {
            PageImpl page = (PageImpl)this.getPageById(wikiType, wikiOwner, pageId);
            this.invalidateUUIDCache(wikiType, wikiOwner, pageId);
            Model model = this.getModel();
            WikiStoreImpl wStore = (WikiStoreImpl)model.getWikiStore();
            ChromatticSession session = wStore.getSession();
            RemovedMixin mix = (RemovedMixin)session.create(RemovedMixin.class);
            session.setEmbedded((Object)page, RemovedMixin.class, (Object)mix);
            mix.setRemovedBy(org.exoplatform.wiki.utils.Utils.getCurrentUser());
            Calendar calendar = GregorianCalendar.getInstance();
            calendar.setTimeInMillis(new Date().getTime());
            mix.setRemovedDate(calendar.getTime());
            mix.setParentPath(page.getParentPage().getPath());
            WikiImpl wiki = (WikiImpl)this.getWiki(wikiType, wikiOwner, model);
            Trash trash = wiki.getTrash();
            if (trash.isHasPage(page.getName())) {
                PageImpl oldDeleted = trash.getPage(page.getName());
                String removedDate = oldDeleted.getRemovedMixin().getRemovedDate().toGMTString();
                String newName = page.getName() + "_" + removedDate.replaceAll(" ", "-").replaceAll(":", "-");
                trash.addChild(newName, oldDeleted);
            }
            trash.addRemovedWikiPage(page);
            LinkRegistry linkRegistry = wiki.getLinkRegistry();
            if (linkRegistry.getLinkEntries().get(this.getLinkEntryName(wikiType, wikiOwner, pageId)) != null) {
                linkRegistry.getLinkEntries().get(this.getLinkEntryName(wikiType, wikiOwner, pageId)).setNewLink(null);
            }
            LinkedList<PageImpl> queue = new LinkedList<PageImpl>();
            queue.add(page);
            PageImpl tempPage = null;
            while (!queue.isEmpty()) {
                tempPage = (PageImpl)queue.poll();
                this.postDeletePage(wikiType, wikiOwner, tempPage.getName(), tempPage);
                Iterator<PageImpl> iter = tempPage.getChildPages().values().iterator();
                while (iter.hasNext()) {
                    queue.add(iter.next());
                }
            }
            session.save();
        }
        catch (Exception e) {
            log.error((Object)("Can't delete page '" + pageId + "' "), (Throwable)e);
            return false;
        }
        return true;
    }

    private void invalidateUUIDCache(String wikiType, String wikiOwner, String pageId) throws Exception {
        PageImpl page = (PageImpl)this.getPageById(wikiType, wikiOwner, pageId);
        LinkedList<PageImpl> queue = new LinkedList<PageImpl>();
        queue.add(page);
        while (!queue.isEmpty()) {
            PageImpl currentPage = (PageImpl)queue.poll();
            ((PageRenderingCacheService)Utils.getService(PageRenderingCacheService.class)).invalidateUUIDCache(new WikiPageParams(wikiType, wikiOwner, currentPage.getName()));
            for (PageImpl child : currentPage.getChildPages().values()) {
                queue.add(child);
            }
        }
    }

    @Override
    public void deleteTemplatePage(String wikiType, String wikiOwner, String templateId) throws Exception {
        WikiPageParams params = new WikiPageParams(wikiType, wikiOwner, templateId);
        this.getTemplatePage(params, templateId).remove();
    }

    @Override
    public void deleteDraftNewPage(String newDraftPageId) throws Exception {
        RepositoryService repoService = (RepositoryService)PortalContainer.getInstance().getComponentInstanceOfType(RepositoryService.class);
        try {
            repoService.getCurrentRepository();
        }
        catch (Exception e) {
            log.info((Object)"Can not get current repository. Drap page will removed in next starting service");
            return;
        }
        Model model = this.getModel();
        WikiStoreImpl wStore = (WikiStoreImpl)model.getWikiStore();
        PageImpl draftNewPagesContainer = wStore.getDraftNewPagesContainer();
        PageImpl draftPage = (PageImpl)draftNewPagesContainer.getChild(newDraftPageId);
        if (draftPage != null) {
            draftPage.remove();
        }
    }

    @Override
    public boolean renamePage(String wikiType, String wikiOwner, String pageName, String newName, String newTitle) throws Exception {
        ArrayList<String> ids;
        if ("WikiHome".equals(pageName) || pageName == null) {
            return false;
        }
        PageImpl currentPage = (PageImpl)this.getPageById(wikiType, wikiOwner, pageName);
        PageImpl parentPage = currentPage.getParentPage();
        RenamedMixin mix = currentPage.getRenamedMixin();
        if (mix == null) {
            mix = (RenamedMixin)parentPage.getChromatticSession().create(RenamedMixin.class);
            currentPage.setRenamedMixin(mix);
            ids = new ArrayList();
            ids.add(pageName);
            mix.setOldPageIds(ids.toArray(new String[0]));
        }
        ids = new ArrayList<String>();
        for (String id : mix.getOldPageIds()) {
            ids.add(id);
        }
        mix.setOldPageIds(ids.toArray(new String[0]));
        currentPage.setName(newName);
        this.getModel().save();
        currentPage.setTitle(newTitle);
        this.getModel().save();
        WikiImpl wiki = (WikiImpl)parentPage.getWiki();
        LinkRegistry linkRegistry = wiki.getLinkRegistry();
        String newEntryName = this.getLinkEntryName(wikiType, wikiOwner, newName);
        String newEntryAlias = this.getLinkEntryAlias(wikiType, wikiOwner, newName);
        LinkEntry newEntry = linkRegistry.getLinkEntries().get(newEntryName);
        LinkEntry entry = linkRegistry.getLinkEntries().get(this.getLinkEntryName(wikiType, wikiOwner, pageName));
        if (newEntry == null) {
            newEntry = linkRegistry.createLinkEntry();
            linkRegistry.getLinkEntries().put(newEntryName, newEntry);
            newEntry.setAlias(newEntryAlias);
            newEntry.setNewLink(newEntry);
            newEntry.setTitle(newTitle);
            if (entry != null) {
                entry.setNewLink(newEntry);
            }
        } else if (entry == null) {
            newEntry.setNewLink(newEntry);
        } else {
            this.processCircularRename(entry, newEntry);
        }
        parentPage.getChromatticSession().save();
        ((PageRenderingCacheService)Utils.getService(PageRenderingCacheService.class)).invalidateCache(new WikiPageParams(wikiType, wikiOwner, pageName));
        ((PageRenderingCacheService)Utils.getService(PageRenderingCacheService.class)).invalidateUUIDCache(new WikiPageParams(wikiType, wikiOwner, pageName));
        return true;
    }

    @Override
    public boolean movePage(WikiPageParams currentLocationParams, WikiPageParams newLocationParams) throws Exception {
        try {
            PageImpl destPage = (PageImpl)this.getPageById(newLocationParams.getType(), newLocationParams.getOwner(), newLocationParams.getPageId());
            if (destPage == null || !destPage.hasPermission(PermissionType.EDITPAGE)) {
                return false;
            }
            Model model = this.getModel();
            WikiStoreImpl wStore = (WikiStoreImpl)model.getWikiStore();
            ChromatticSession session = wStore.getSession();
            PageImpl movePage = (PageImpl)this.getPageById(currentLocationParams.getType(), currentLocationParams.getOwner(), currentLocationParams.getPageId());
            WikiImpl sourceWiki = (WikiImpl)movePage.getWiki();
            MovedMixin mix = movePage.getMovedMixin();
            if (mix == null) {
                movePage.setMovedMixin((MovedMixin)session.create(MovedMixin.class));
                mix = movePage.getMovedMixin();
                mix.setTargetPage(movePage.getParentPage());
            }
            mix.setTargetPage(destPage);
            WikiImpl destWiki = (WikiImpl)destPage.getWiki();
            movePage.setParentPage(destPage);
            movePage.setMinorEdit(false);
            session.save();
            if (!newLocationParams.getType().equals(currentLocationParams.getType()) || PortalConfig.GROUP_TYPE.equals(currentLocationParams.getType()) && !currentLocationParams.getOwner().equals(newLocationParams.getOwner())) {
                LinkRegistry sourceLinkRegistry = sourceWiki.getLinkRegistry();
                LinkRegistry destLinkRegistry = destWiki.getLinkRegistry();
                String newEntryName = this.getLinkEntryName(newLocationParams.getType(), newLocationParams.getOwner(), currentLocationParams.getPageId());
                String newEntryAlias = this.getLinkEntryAlias(newLocationParams.getType(), newLocationParams.getOwner(), currentLocationParams.getPageId());
                LinkEntry newEntry = destLinkRegistry.getLinkEntries().get(newEntryName);
                LinkEntry entry = sourceLinkRegistry.getLinkEntries().get(this.getLinkEntryName(currentLocationParams.getType(), currentLocationParams.getOwner(), currentLocationParams.getPageId()));
                if (newEntry == null) {
                    newEntry = destLinkRegistry.createLinkEntry();
                    destLinkRegistry.getLinkEntries().put(newEntryName, newEntry);
                    newEntry.setAlias(newEntryAlias);
                    newEntry.setNewLink(newEntry);
                    newEntry.setTitle(destPage.getTitle());
                    if (entry != null) {
                        entry.setNewLink(newEntry);
                    }
                } else if (entry == null) {
                    newEntry.setNewLink(newEntry);
                } else {
                    this.processCircularRename(entry, newEntry);
                }
            }
            ((PageRenderingCacheService)Utils.getService(PageRenderingCacheService.class)).invalidateUUIDCache(currentLocationParams);
            this.postUpdatePage(newLocationParams.getType(), newLocationParams.getOwner(), movePage.getName(), movePage, "movePage");
            session.save();
        }
        catch (Exception e) {
            log.error((Object)("Can't move page '" + currentLocationParams.getPageId() + "' "), (Throwable)e);
            return false;
        }
        return true;
    }

    @Override
    public List<PermissionEntry> getWikiPermission(String wikiType, String wikiOwner) throws Exception {
        String id;
        List<String> permissions;
        ArrayList<PermissionEntry> permissionEntries = new ArrayList<PermissionEntry>();
        Model model = this.getModel();
        Wiki wiki = this.getWikiWithoutPermission(wikiType, wikiOwner, model);
        if (wiki == null) {
            return permissionEntries;
        }
        if (!wiki.getDefaultPermissionsInited()) {
            permissions = this.getWikiDefaultPermissions(wikiType, wikiOwner);
            wiki.setWikiPermissions(permissions);
            wiki.setDefaultPermissionsInited(true);
            HashMap<String, String[]> permMap = new HashMap<String, String[]>();
            for (String perm : permissions) {
                String[] actions = perm.substring(0, perm.indexOf(":")).split(",");
                perm = perm.substring(perm.indexOf(":") + 1);
                id = perm.substring(perm.indexOf(":") + 1);
                ArrayList<String> jcrActions = new ArrayList<String>();
                for (String action : actions) {
                    if (PermissionType.VIEWPAGE.toString().equals(action)) {
                        jcrActions.add("read");
                        continue;
                    }
                    if (!PermissionType.EDITPAGE.toString().equals(action)) continue;
                    jcrActions.add("add_node");
                    jcrActions.add("remove");
                    jcrActions.add("set_property");
                }
                permMap.put(id, jcrActions.toArray(new String[jcrActions.size()]));
            }
            this.updateAllPagesPermissions(wikiType, wikiOwner, permMap);
        }
        permissions = wiki.getWikiPermissions();
        for (String perm : permissions) {
            String[] actions = perm.substring(0, perm.indexOf(":")).split(",");
            perm = perm.substring(perm.indexOf(":") + 1);
            String idType = perm.substring(0, perm.indexOf(":"));
            id = perm.substring(perm.indexOf(":") + 1);
            PermissionEntry entry = new PermissionEntry();
            if (IDType.USER.toString().equals(idType)) {
                entry.setIdType(IDType.USER);
            } else if (IDType.GROUP.toString().equals(idType)) {
                entry.setIdType(IDType.GROUP);
            } else if (IDType.MEMBERSHIP.toString().equals(idType)) {
                entry.setIdType(IDType.MEMBERSHIP);
            }
            entry.setId(id);
            Permission[] perms = new Permission[4];
            perms[0] = new Permission();
            perms[0].setPermissionType(PermissionType.VIEWPAGE);
            perms[1] = new Permission();
            perms[1].setPermissionType(PermissionType.EDITPAGE);
            perms[2] = new Permission();
            perms[2].setPermissionType(PermissionType.ADMINPAGE);
            perms[3] = new Permission();
            perms[3].setPermissionType(PermissionType.ADMINSPACE);
            for (String action : actions) {
                if (PermissionType.VIEWPAGE.toString().equals(action)) {
                    perms[0].setAllowed(true);
                    continue;
                }
                if (PermissionType.EDITPAGE.toString().equals(action)) {
                    perms[1].setAllowed(true);
                    continue;
                }
                if (PermissionType.ADMINPAGE.toString().equals(action)) {
                    perms[2].setAllowed(true);
                    continue;
                }
                if (!PermissionType.ADMINSPACE.toString().equals(action)) continue;
                perms[3].setAllowed(true);
            }
            entry.setPermissions(perms);
            permissionEntries.add(entry);
        }
        return permissionEntries;
    }

    @Override
    public void setWikiPermission(String wikiType, String wikiOwner, List<PermissionEntry> permissionEntries) throws Exception {
        Model model = this.getModel();
        WikiImpl wiki = (WikiImpl)this.getWiki(wikiType, wikiOwner, model);
        ArrayList<String> permissions = new ArrayList<String>();
        HashMap<String, String[]> permMap = new HashMap<String, String[]>();
        for (PermissionEntry entry : permissionEntries) {
            StringBuilder actions = new StringBuilder();
            Permission[] pers = entry.getPermissions();
            ArrayList<String> permlist = new ArrayList<String>();
            for (int i = 0; i < pers.length; ++i) {
                Permission perm = pers[i];
                if (!perm.isAllowed()) continue;
                actions.append(perm.getPermissionType().toString());
                if (i < pers.length - 1) {
                    actions.append(",");
                }
                if (perm.getPermissionType().equals((Object)PermissionType.VIEWPAGE)) {
                    permlist.add("read");
                    continue;
                }
                if (!perm.getPermissionType().equals((Object)PermissionType.EDITPAGE)) continue;
                permlist.add("add_node");
                permlist.add("remove");
                permlist.add("set_property");
            }
            if (actions.toString().length() > 0) {
                actions.append(":").append((Object)entry.getIdType()).append(":").append(entry.getId());
                permissions.add(actions.toString());
            }
            if (permlist.size() <= 0) continue;
            permMap.put(entry.getId(), permlist.toArray(new String[permlist.size()]));
        }
        wiki.setWikiPermissions(permissions);
        this.updateAllPagesPermissions(wikiType, wikiOwner, permMap);
    }

    @Override
    public Page getPageById(String wikiType, String wikiOwner, String pageId) throws Exception {
        Page page = ((PageRenderingCacheService)Utils.getService(PageRenderingCacheService.class)).getPageByParams(new WikiPageParams(wikiType, wikiOwner, pageId));
        if (page != null && !page.hasPermission(PermissionType.VIEWPAGE)) {
            page = null;
        }
        return page;
    }

    @Override
    public Page getPageByIdJCRQuery(String wikiType, String wikiOwner, String pageId) throws Exception {
        Page page = this.getPageByRootPermission(wikiType, wikiOwner, pageId);
        if (page != null && page.hasPermission(PermissionType.VIEWPAGE)) {
            return page;
        }
        return null;
    }

    @Override
    public Page getPageByRootPermission(String wikiType, String wikiOwner, String pageId) throws Exception {
        PageImpl page = null;
        if ("WikiHome".equals(pageId) || pageId == null) {
            page = this.getWikiHome(wikiType, wikiOwner);
        } else {
            String wikiHomeId;
            Model model;
            WikiStoreImpl wStore;
            ChromatticSession session;
            String statement = new WikiSearchData(wikiType, wikiOwner, pageId).getPageConstraint();
            if (statement != null && (session = (wStore = (WikiStoreImpl)(model = this.getModel()).getWikiStore()).getSession()) != null && (page = this.searchPage(statement, session)) == null && (page = this.getWikiHome(wikiType, wikiOwner)) != null && !(wikiHomeId = TitleResolver.getId(page.getTitle(), true)).equals(pageId)) {
                page = null;
            }
        }
        this.checkToRemoveDomainInUrl(page);
        return page;
    }

    private void checkToRemoveDomainInUrl(PageImpl page) {
        if (page == null) {
            return;
        }
        String url = page.getURL();
        if (url != null) {
            try {
                URL oldURL = new URL(url);
                page.setURL(oldURL.getPath());
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
    }

    @Override
    public Page getRelatedPage(String wikiType, String wikiOwner, String pageId) throws Exception {
        int circularFlag;
        Model model = this.getModel();
        WikiImpl wiki = (WikiImpl)this.getWiki(wikiType, wikiOwner, model);
        LinkRegistry linkRegistry = wiki.getLinkRegistry();
        LinkEntry oldLinkEntry = linkRegistry.getLinkEntries().get(this.getLinkEntryName(wikiType, wikiOwner, pageId));
        LinkEntry newLinkEntry = null;
        if (oldLinkEntry != null) {
            newLinkEntry = oldLinkEntry.getNewLink();
        }
        for (circularFlag = 1000; newLinkEntry != null && !newLinkEntry.equals(oldLinkEntry) && circularFlag > 0; --circularFlag) {
            oldLinkEntry = newLinkEntry;
            newLinkEntry = oldLinkEntry.getNewLink();
        }
        if (newLinkEntry == null) {
            return null;
        }
        if (circularFlag == 0) {
            for (circularFlag = 1000; circularFlag > 0 && this.getPageWithLinkEntry(newLinkEntry) == null; --circularFlag) {
                newLinkEntry = newLinkEntry.getNewLink();
            }
            if (circularFlag > 0) {
                newLinkEntry.setNewLink(newLinkEntry);
            }
        }
        return this.getPageWithLinkEntry(newLinkEntry);
    }

    @Override
    public Page getExsitedOrNewDraftPageById(String wikiType, String wikiOwner, String pageId) throws Exception {
        String username = org.exoplatform.wiki.utils.Utils.getCurrentUser();
        Page existedPage = this.getPageByRootPermission(wikiType, wikiOwner, pageId);
        if (existedPage != null && (username == null || existedPage.hasPermission(PermissionType.EDITPAGE) || existedPage.hasPermission(PermissionType.VIEW_ATTACHMENT))) {
            return existedPage;
        }
        if (IdentityConstants.ANONIM.equals(username)) {
            Model model = this.getModel();
            WikiStore wStore = model.getWikiStore();
            PageImpl draftNewPagesContainer = wStore.getDraftNewPagesContainer();
            Page draftPage = draftNewPagesContainer.getChildPages().get(pageId);
            if (draftPage == null) {
                draftPage = wStore.createPage();
                draftPage.setName(pageId);
                draftNewPagesContainer.addPublicPage(draftPage);
            }
            return draftPage;
        }
        Model model = this.getModel();
        UserWiki userWiki = null;
        DraftPageImpl draftPage = null;
        if (username == null && pageId.indexOf("_A_A_") > -1) {
            String[] texts = pageId.split("_A_A_");
            username = texts[0];
            WikiStoreImpl wStore = (WikiStoreImpl)model.getWikiStore();
            WikiContainer userWikiContainer = wStore.getWikiContainer(WikiType.USER);
            userWiki = (UserWiki)userWikiContainer.getWiki(username, true);
            Collection<PageImpl> childPages = userWiki.getDraftPagesContainer().getChildrenByRootPermission().values();
            for (PageImpl pageImpl : childPages) {
                if (!pageImpl.getName().equals(pageId)) continue;
                return pageImpl;
            }
        } else {
            draftPage = (DraftPageImpl)this.getDraft(pageId);
            if (draftPage != null) {
                return draftPage;
            }
        }
        if (userWiki == null) {
            userWiki = (UserWiki)this.getWiki(PortalConfig.USER_TYPE, username, model);
        }
        PageImpl draftPagesContainer = userWiki.getDraftPagesContainer();
        draftPage = userWiki.createDraftPage();
        draftPage.setName(pageId);
        draftPagesContainer.addWikiPage(draftPage);
        draftPage.setNewPage(true);
        draftPage.setTargetPage(null);
        draftPage.setTargetRevision("1");
        HashMap<String, String[]> permissions = draftPage.getPermission();
        permissions.put(IdentityConstants.ANY, new String[]{"read"});
        draftPage.setPermission(permissions);
        return draftPage;
    }

    @Override
    public Page getPageByUUID(String uuid) throws Exception {
        if (uuid == null) {
            return null;
        }
        Model model = this.getModel();
        WikiStore wStore = model.getWikiStore();
        return this.jcrDataStorage.getWikiPageByUUID(wStore.getSession(), uuid);
    }

    @Override
    public Template getTemplatePage(WikiPageParams params, String templateId) throws Exception {
        return this.getTemplatesContainer(params).getTemplate(templateId);
    }

    @Override
    public Map<String, Template> getTemplates(WikiPageParams params) throws Exception {
        return this.getTemplatesContainer(params).getTemplates();
    }

    @Override
    public TemplateContainer getTemplatesContainer(WikiPageParams params) throws Exception {
        Model model = this.getModel();
        WikiImpl wiki = (WikiImpl)this.getWiki(params.getType(), params.getOwner(), model);
        return wiki.getPreferences().getTemplateContainer();
    }

    @Override
    public void modifyTemplate(WikiPageParams params, Template template, String newTitle, String newDescription, String newContent, String newSyntaxId) throws Exception {
        if (newTitle != null) {
            template = this.getTemplatesContainer(params).addPage(TitleResolver.getId(newTitle, false), template);
            template.setDescription(StringEscapeUtils.escapeHtml((String)newDescription));
            template.setTitle(newTitle);
            template.getContent().setText(newContent);
            template.setSyntax(newSyntaxId);
        }
    }

    @Override
    public PageList<SearchResult> search(WikiSearchData data) throws Exception {
        Model model = this.getModel();
        try {
            WikiStoreImpl wStore = (WikiStoreImpl)model.getWikiStore();
            ObjectPageList result = this.jcrDataStorage.search(wStore.getSession(), data);
            if (data.getTitle() != null && data.getWikiType() != null && data.getWikiOwner() != null && result.getPageSize() > 0) {
                WikiHome homePage = this.getWikiHome(data.getWikiType(), data.getWikiOwner());
                if (data.getTitle().equals("") || homePage != null && homePage.getTitle().contains(data.getTitle())) {
                    Calendar wikiHomeCreateDate = Calendar.getInstance();
                    wikiHomeCreateDate.setTime(homePage.getCreatedDate());
                    Calendar wikiHomeUpdateDate = Calendar.getInstance();
                    wikiHomeUpdateDate.setTime(homePage.getUpdatedDate());
                    SearchResult wikiHomeResult = new SearchResult(null, homePage.getTitle(), homePage.getPath(), "exo:wikihome".toString(), wikiHomeUpdateDate, wikiHomeCreateDate);
                    wikiHomeResult.setPageName(homePage.getName());
                    List tempSearchResult = result.getAll();
                    tempSearchResult.add(wikiHomeResult);
                    result = new ObjectPageList(tempSearchResult, result.getPageSize());
                }
            }
            return result;
        }
        catch (Exception e) {
            log.error((Object)"Can't search", (Throwable)e);
            return new ObjectPageList(new ArrayList(), 0);
        }
    }

    @Override
    public List<TemplateSearchResult> searchTemplate(TemplateSearchData data) throws Exception {
        Model model = this.getModel();
        try {
            WikiStoreImpl wStore = (WikiStoreImpl)model.getWikiStore();
            List<TemplateSearchResult> result = this.jcrDataStorage.searchTemplate(wStore.getSession(), data);
            return result;
        }
        catch (Exception e) {
            log.error((Object)"Can't search", (Throwable)e);
            return null;
        }
    }

    @Override
    public List<SearchResult> searchRenamedPage(String wikiType, String wikiOwner, String pageId) throws Exception {
        Model model = this.getModel();
        WikiStoreImpl wStore = (WikiStoreImpl)model.getWikiStore();
        WikiSearchData data = new WikiSearchData(wikiType, wikiOwner, pageId);
        return this.jcrDataStorage.searchRenamedPage(wStore.getSession(), data);
    }

    @Override
    public Object findByPath(String path, String objectNodeType) {
        String relPath = path;
        if (relPath.startsWith("/")) {
            relPath = relPath.substring(1);
        }
        try {
            Model model = this.getModel();
            WikiStoreImpl wStore = (WikiStoreImpl)model.getWikiStore();
            if ("wiki:page".equals(objectNodeType)) {
                return wStore.getSession().findByPath(PageImpl.class, relPath);
            }
            if ("wiki:attachment".equals(objectNodeType)) {
                return wStore.getSession().findByPath(AttachmentImpl.class, relPath);
            }
            if ("wiki:template".equals(objectNodeType)) {
                return wStore.getSession().findByPath(Template.class, relPath);
            }
        }
        catch (Exception e) {
            log.error((Object)"Can't find Object", (Throwable)e);
        }
        return null;
    }

    @Override
    public String getPageTitleOfAttachment(String path) throws Exception {
        try {
            String relPath = path;
            if (relPath.startsWith("/")) {
                relPath = relPath.substring(1);
            }
            String temp = relPath.substring(0, relPath.lastIndexOf("/"));
            relPath = temp.substring(0, temp.lastIndexOf("/"));
            Model model = this.getModel();
            WikiStoreImpl wStore = (WikiStoreImpl)model.getWikiStore();
            PageImpl page = (PageImpl)wStore.getSession().findByPath(PageImpl.class, relPath);
            return page.getTitle();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public InputStream getAttachmentAsStream(String path) throws Exception {
        Model model = this.getModel();
        try {
            WikiStoreImpl wStore = (WikiStoreImpl)model.getWikiStore();
            return this.jcrDataStorage.getAttachmentAsStream(path, wStore.getSession());
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public List<BreadcrumbData> getBreadcumb(String wikiType, String wikiOwner, String pageId) throws Exception {
        return this.getBreadcumb(null, wikiType, wikiOwner, pageId);
    }

    @Override
    public PageImpl getHelpSyntaxPage(String syntaxId) throws Exception {
        Model model = this.getModel();
        WikiStoreImpl wStore = (WikiStoreImpl)model.getWikiStore();
        if (wStore.getHelpPageByChromattic() == null || wStore.getHelpPagesContainer().getChildPages().size() == 0) {
            this.createHelpPages(wStore);
        }
        for (PageImpl syntaxPage : wStore.getHelpPagesContainer().getChildPages().values()) {
            if (!syntaxPage.getSyntax().equals(syntaxId)) continue;
            return syntaxPage;
        }
        return null;
    }

    @Override
    public Page getMetaDataPage(MetaDataPage metaPage) throws Exception {
        if (MetaDataPage.EMOTION_ICONS_PAGE.equals((Object)metaPage)) {
            Model model = this.getModel();
            WikiStoreImpl wStore = (WikiStoreImpl)model.getWikiStore();
            return wStore.getEmotionIconsPage();
        }
        return null;
    }

    @Override
    public String getDefaultWikiSyntaxId() {
        if (this.preferencesParams != null) {
            return this.preferencesParams.getProperty(DEFAULT_SYNTAX);
        }
        return Syntax.XWIKI_2_0.toIdString();
    }

    @Override
    public long getSaveDraftSequenceTime() {
        return this.autoSaveInterval;
    }

    @Override
    public long getEditPageLivingTime() {
        return this.editPageLivingTime_;
    }

    @Override
    public WikiPageParams getWikiPageParams(BreadcrumbData data) {
        if (data != null) {
            return new WikiPageParams(data.getWikiType(), data.getWikiOwner(), data.getId());
        }
        return null;
    }

    @Override
    public List<PageImpl> getDuplicatePages(PageImpl parentPage, Wiki targetWiki, List<PageImpl> resultList) throws Exception {
        if (resultList == null) {
            resultList = new ArrayList<PageImpl>();
        }
        if (resultList.size() > 6) {
            return resultList;
        }
        if (this.isExisting(targetWiki.getType(), targetWiki.getOwner(), parentPage.getName())) {
            resultList.add(parentPage);
        }
        for (PageImpl page : parentPage.getChildPages().values()) {
            this.getDuplicatePages(page, targetWiki, resultList);
        }
        return resultList;
    }

    private Model getModel() {
        MOWService mowService = (MOWService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(MOWService.class);
        return mowService.getModel();
    }

    private PageImpl searchPage(String statement, ChromatticSession session) throws Exception {
        QueryResult result;
        PageImpl wikiPage = null;
        if (statement != null && (result = session.createQueryBuilder(PageImpl.class).where(statement).get().objects()).hasNext()) {
            wikiPage = (PageImpl)result.next();
        }
        if (wikiPage != null) {
            String path = wikiPage.getPath();
            if (path.startsWith("/")) {
                path = path.substring(1, path.length());
            }
            wikiPage = (PageImpl)session.findByPath(PageImpl.class, path);
        }
        if (wikiPage != null) {
            // empty if block
        }
        return wikiPage;
    }

    @Override
    public Wiki getWiki(String wikiType, String owner) {
        return this.getWiki(wikiType, owner, this.getModel());
    }

    @Override
    public String getPortalOwner() {
        Model model = this.getModel();
        WikiStoreImpl wStore = (WikiStoreImpl)model.getWikiStore();
        ArrayList portalWikis = new ArrayList(wStore.getWikiContainer(WikiType.PORTAL).getAllWikis());
        if (portalWikis.size() > 0) {
            return ((Wiki)portalWikis.get(0)).getOwner();
        }
        return null;
    }

    private Wiki getWiki(String wikiType, String owner, Model model) {
        WikiImpl wiki;
        block7: {
            WikiStoreImpl wStore = (WikiStoreImpl)model.getWikiStore();
            wiki = null;
            try {
                if (PortalConfig.PORTAL_TYPE.equals(wikiType)) {
                    WikiContainer portalWikiContainer = wStore.getWikiContainer(WikiType.PORTAL);
                    wiki = (WikiImpl)portalWikiContainer.getWiki(owner, true);
                } else if (PortalConfig.GROUP_TYPE.equals(wikiType)) {
                    WikiContainer groupWikiContainer = wStore.getWikiContainer(WikiType.GROUP);
                    boolean hasPermission = this.hasAdminSpacePermission(wikiType, owner);
                    wiki = (WikiImpl)groupWikiContainer.getWiki(owner, hasPermission);
                } else if (PortalConfig.USER_TYPE.equals(wikiType)) {
                    boolean hasEditWiki = this.hasAdminSpacePermission(wikiType, owner);
                    WikiContainer userWikiContainer = wStore.getWikiContainer(WikiType.USER);
                    wiki = (WikiImpl)userWikiContainer.getWiki(owner, hasEditWiki);
                }
                model.save();
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block7;
                log.debug((Object)("[WikiService] Cannot get wiki " + wikiType + ":" + owner), (Throwable)e);
            }
        }
        return wiki;
    }

    private Wiki getWikiWithoutPermission(String wikiType, String owner, Model model) {
        Wiki wiki;
        block7: {
            WikiStore wStore = model.getWikiStore();
            wiki = null;
            try {
                if (PortalConfig.PORTAL_TYPE.equals(wikiType)) {
                    WikiContainer portalWikiContainer = wStore.getWikiContainer(WikiType.PORTAL);
                    wiki = (Wiki)portalWikiContainer.getWiki(owner, true);
                } else if (PortalConfig.GROUP_TYPE.equals(wikiType)) {
                    WikiContainer groupWikiContainer = wStore.getWikiContainer(WikiType.GROUP);
                    wiki = (Wiki)groupWikiContainer.getWiki(owner, true);
                } else if (PortalConfig.USER_TYPE.equals(wikiType)) {
                    WikiContainer userWikiContainer = wStore.getWikiContainer(WikiType.USER);
                    wiki = (Wiki)userWikiContainer.getWiki(owner, true);
                }
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block7;
                log.debug((Object)("[WikiService] Cannot get wiki " + wikiType + ":" + owner), (Throwable)e);
            }
        }
        return wiki;
    }

    private List<AccessControlEntry> getAccessControls(String wikiType, String wikiOwner) throws Exception {
        ArrayList<AccessControlEntry> aces;
        block5: {
            aces = new ArrayList<AccessControlEntry>();
            try {
                List<PermissionEntry> permissionEntries = this.getWikiPermission(wikiType, wikiOwner);
                for (PermissionEntry perm : permissionEntries) {
                    Permission[] permissions = perm.getPermissions();
                    ArrayList<String> actions = new ArrayList<String>();
                    for (Permission permission : permissions) {
                        if (!permission.isAllowed()) continue;
                        actions.add(permission.getPermissionType().toString());
                    }
                    for (String action : actions) {
                        aces.add(new AccessControlEntry(perm.getId(), action));
                    }
                }
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block5;
                log.debug((Object)"failed in method getAccessControls:", (Throwable)e);
            }
        }
        return aces;
    }

    @Override
    public boolean hasAdminSpacePermission(String wikiType, String owner) throws Exception {
        UserACL acl;
        ConversationState conversationState = ConversationState.getCurrent();
        Identity user = null;
        if (conversationState != null) {
            user = conversationState.getIdentity();
            ExoContainer container = ExoContainerContext.getCurrentContainer();
            acl = (UserACL)container.getComponentInstanceOfType(UserACL.class);
            if (acl != null && acl.getSuperUser().equals(user.getUserId())) {
                return true;
            }
        } else {
            user = new Identity(IdentityConstants.ANONIM);
        }
        List<AccessControlEntry> aces = this.getAccessControls(wikiType, owner);
        acl = new AccessControlList(owner, aces);
        String[] permission = new String[]{PermissionType.ADMINSPACE.toString()};
        return org.exoplatform.wiki.utils.Utils.hasPermission((AccessControlList)acl, permission, user);
    }

    @Override
    public boolean hasAdminPagePermission(String wikiType, String owner) throws Exception {
        UserACL acl;
        ConversationState conversationState = ConversationState.getCurrent();
        Identity user = null;
        if (conversationState != null) {
            user = conversationState.getIdentity();
            ExoContainer container = ExoContainerContext.getCurrentContainer();
            acl = (UserACL)container.getComponentInstanceOfType(UserACL.class);
            if (acl != null && acl.getSuperUser().equals(user.getUserId())) {
                return true;
            }
        } else {
            user = new Identity(IdentityConstants.ANONIM);
        }
        List<AccessControlEntry> aces = this.getAccessControls(wikiType, owner);
        acl = new AccessControlList(owner, aces);
        String[] permission = new String[]{PermissionType.ADMINPAGE.toString()};
        return org.exoplatform.wiki.utils.Utils.hasPermission((AccessControlList)acl, permission, user);
    }

    private WikiHome getWikiHome(String wikiType, String owner) throws Exception {
        Model model = this.getModel();
        WikiImpl wiki = (WikiImpl)this.getWiki(wikiType, owner, model);
        if (wiki != null) {
            WikiHome wikiHome = wiki.getWikiHome();
            return wikiHome;
        }
        return null;
    }

    private List<BreadcrumbData> getBreadcumb(List<BreadcrumbData> list, String wikiType, String wikiOwner, String pageId) throws Exception {
        if (list == null) {
            list = new ArrayList<BreadcrumbData>(5);
        }
        if (pageId == null) {
            return list;
        }
        PageImpl page = (PageImpl)this.getPageById(wikiType, wikiOwner, pageId);
        if (page == null) {
            return list;
        }
        list.add(0, new BreadcrumbData(page.getName(), page.getPath(), page.getTitle(), wikiType, wikiOwner));
        PageImpl parentPage = page.getParentPage();
        if (parentPage != null) {
            this.getBreadcumb(list, wikiType, wikiOwner, parentPage.getName());
        }
        return list;
    }

    private synchronized void createHelpPages(WikiStoreImpl wStore) throws Exception {
        HelpPage helpPage = wStore.getHelpPagesContainer();
        if (helpPage.getChildPages().size() == 0) {
            for (ValuesParam syntaxhelpParam : this.syntaxHelpParams) {
                try {
                    String syntaxName = syntaxhelpParam.getName();
                    ArrayList syntaxValues = syntaxhelpParam.getValues();
                    String shortFile = (String)syntaxValues.get(0);
                    String fullFile = (String)syntaxValues.get(1);
                    HelpPage syntaxPage = this.addSyntaxPage(wStore, helpPage, syntaxName, shortFile, " Short help Page");
                    this.addSyntaxPage(wStore, syntaxPage, syntaxName, fullFile, " Full help Page");
                    wStore.getSession().save();
                }
                catch (Exception e) {
                    log.error((Object)"Can not create Help page", (Throwable)e);
                }
            }
        }
    }

    @Override
    public Template createTemplatePage(String title, WikiPageParams params) throws Exception {
        Model model = this.getModel();
        TemplateContainer templContainer = this.getTemplatesContainer(params);
        ConversationState conversationState = ConversationState.getCurrent();
        try {
            Template template = templContainer.createTemplatePage();
            String pageId = TitleResolver.getId(title, false);
            template.setName(pageId);
            templContainer.addPage(template.getName(), template);
            String creator = null;
            if (conversationState != null && conversationState.getIdentity() != null) {
                creator = conversationState.getIdentity().getUserId();
            }
            template.setOwner(creator);
            template.setTitle(title);
            template.getContent().setText("");
            model.save();
            return template;
        }
        catch (Exception e) {
            log.error((Object)"Can not create Template page", (Throwable)e);
            return null;
        }
    }

    private HelpPage addSyntaxPage(WikiStoreImpl wStore, PageImpl parentPage, String name, String path, String type) throws Exception {
        String tempLine;
        StringBuffer stringContent = new StringBuffer();
        InputStream inputContent = null;
        BufferedReader bufferReader = null;
        inputContent = this.configManager.getInputStream(path);
        bufferReader = new BufferedReader(new InputStreamReader(inputContent));
        while ((tempLine = bufferReader.readLine()) != null) {
            stringContent.append(tempLine + "\n");
        }
        HelpPage syntaxPage = wStore.createHelpPage();
        String realName = name.replace("/", "");
        syntaxPage.setName(realName + type);
        parentPage.addPublicPage(syntaxPage);
        AttachmentImpl content = syntaxPage.getContent();
        syntaxPage.setTitle(realName + type);
        content.setText(stringContent.toString());
        syntaxPage.setSyntax(name);
        syntaxPage.setNonePermission();
        inputContent.close();
        bufferReader.close();
        return syntaxPage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addEmotionIcons() {
        SessionProvider sessionProvider = SessionProvider.createSystemProvider();
        try {
            Model model = this.getModel();
            WikiStoreImpl wStore = (WikiStoreImpl)model.getWikiStore();
            if (wStore.getEmotionIconsPage() == null) {
                model.save();
                XMLDeploymentPlugin emotionIconsPlugin = this.getEmotionIconsPlugin();
                if (emotionIconsPlugin != null) {
                    emotionIconsPlugin.deploy(sessionProvider);
                }
            }
        }
        catch (Exception e) {
            log.warn((Object)"Can not init emotion icons...");
        }
        finally {
            sessionProvider.close();
        }
    }

    private XMLDeploymentPlugin getEmotionIconsPlugin() {
        for (ComponentPlugin c : this.plugins_) {
            if (!(c instanceof XMLDeploymentPlugin)) continue;
            return (XMLDeploymentPlugin)c;
        }
        return null;
    }

    private String getLinkEntryName(String wikiType, String wikiOwner, String pageId) {
        if (PortalConfig.GROUP_TYPE.equals(wikiType)) {
            wikiOwner = wikiOwner.replace("/", "-");
        }
        return wikiType + "@" + wikiOwner + "@" + pageId;
    }

    private String getLinkEntryAlias(String wikiType, String wikiOwner, String pageId) {
        return wikiType + "@" + wikiOwner + "@" + pageId;
    }

    private void processCircularRename(LinkEntry entry, LinkEntry newEntry) {
        int circularFlag;
        boolean isCircular = true;
        LinkEntry checkEntry = newEntry;
        for (circularFlag = 1000; !checkEntry.equals(entry) && circularFlag > 0; --circularFlag) {
            if ((checkEntry = checkEntry.getNewLink()) != null && (!checkEntry.equals(checkEntry.getNewLink()) || checkEntry.equals(entry))) continue;
            isCircular = false;
            break;
        }
        if (!isCircular || circularFlag == 0) {
            entry.setNewLink(newEntry);
        } else {
            LinkEntry nextEntry = newEntry.getNewLink();
            while (!nextEntry.equals(newEntry)) {
                LinkEntry deletedEntry = nextEntry;
                if (!(nextEntry = nextEntry.getNewLink()).equals(deletedEntry)) {
                    deletedEntry.remove();
                    continue;
                }
                deletedEntry.remove();
                break;
            }
        }
        newEntry.setNewLink(newEntry);
    }

    private Page getPageWithLinkEntry(LinkEntry entry) throws Exception {
        String linkEntryAlias = entry.getAlias();
        String[] splits = linkEntryAlias.split("@");
        String wikiType = splits[0];
        String wikiOwner = splits[1];
        String pageId = linkEntryAlias.substring((wikiType + "@" + wikiOwner + "@").length());
        return this.getPageById(wikiType, wikiOwner, pageId);
    }

    private void updateAllPagesPermissions(String wikiType, String wikiOwner, HashMap<String, String[]> permMap) throws Exception {
        WikiHome page = this.getWikiHome(wikiType, wikiOwner);
        LinkedList<PageImpl> queue = new LinkedList<PageImpl>();
        queue.add(page);
        while (queue.peek() != null) {
            PageImpl p = (PageImpl)queue.poll();
            if (!p.getOverridePermission()) {
                p.setPermission(permMap);
            }
            Iterator<PageImpl> iter = p.getChildPages().values().iterator();
            while (iter.hasNext()) {
                queue.add(iter.next());
            }
        }
    }

    @Override
    public List<String> getWikiDefaultPermissions(String wikiType, String wikiOwner) throws Exception {
        String ownerClause;
        String view = "" + (Object)((Object)PermissionType.VIEWPAGE);
        String viewEdit = (Object)((Object)PermissionType.VIEWPAGE) + "," + (Object)((Object)PermissionType.EDITPAGE);
        String all = (Object)((Object)PermissionType.VIEWPAGE) + "," + (Object)((Object)PermissionType.EDITPAGE) + "," + (Object)((Object)PermissionType.ADMINPAGE) + "," + (Object)((Object)PermissionType.ADMINSPACE);
        ArrayList<String> permissions = new ArrayList<String>();
        for (Map.Entry<String, IDType> entry : org.exoplatform.wiki.utils.Utils.getACLForAdmins().entrySet()) {
            permissions.add(all + ":" + (Object)((Object)entry.getValue()) + ":" + entry.getKey());
        }
        if (PortalConfig.PORTAL_TYPE.equals(wikiType)) {
            UserPortalConfigService service = (UserPortalConfigService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(UserPortalConfigService.class);
            PortalConfig portalConfig = service.getUserPortalConfig(wikiOwner, null).getPortalConfig();
            String portalEditClause = all + ":" + (Object)((Object)IDType.MEMBERSHIP) + ":" + portalConfig.getEditPermission();
            if (!permissions.contains(portalEditClause)) {
                permissions.add(portalEditClause);
            }
            permissions.add(view + ":" + (Object)((Object)IDType.USER) + ":any");
        } else if (PortalConfig.GROUP_TYPE.equals(wikiType)) {
            String ownerClause2;
            UserACL userACL = (UserACL)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(UserACL.class);
            String makableMTClause = all + ":" + (Object)((Object)IDType.MEMBERSHIP) + ":" + userACL.getMakableMT() + ":" + wikiOwner;
            if (!permissions.contains(makableMTClause)) {
                permissions.add(makableMTClause);
            }
            if (!permissions.contains(ownerClause2 = viewEdit + ":" + (Object)((Object)IDType.MEMBERSHIP) + ":*:" + wikiOwner)) {
                permissions.add(ownerClause2);
            }
        } else if (PortalConfig.USER_TYPE.equals(wikiType) && !permissions.contains(ownerClause = all + ":" + (Object)((Object)IDType.USER) + ":" + wikiOwner)) {
            permissions.add(ownerClause);
        }
        return permissions;
    }

    @Override
    public void addComponentPlugin(ComponentPlugin plugin) {
        if (plugin != null) {
            this.plugins_.add(plugin);
        }
    }

    @Override
    public void addWikiTemplatePagePlugin(WikiTemplatePagePlugin plugin) {
        if (plugin != null) {
            this.templatePagePlugins_.add(plugin);
        }
    }

    @Override
    public List<PageWikiListener> getPageListeners() {
        ArrayList<PageWikiListener> pageListeners = new ArrayList<PageWikiListener>();
        for (ComponentPlugin c : this.plugins_) {
            if (!(c instanceof PageWikiListener)) continue;
            pageListeners.add((PageWikiListener)c);
        }
        return pageListeners;
    }

    public void setTemplatePagePlugin() {
        for (WikiTemplatePagePlugin plugin : this.templatePagePlugins_) {
            this.jcrDataStorage.setTemplatePagePlugin(plugin);
        }
    }

    @Override
    public UserWiki getOrCreateUserWiki(String username) {
        Model model = this.getModel();
        return (UserWiki)this.getWiki(PortalConfig.USER_TYPE, username, model);
    }

    @Override
    public List<SpaceBean> searchSpaces(String keyword) throws Exception {
        ArrayList<SpaceBean> spaceBeans = new ArrayList<SpaceBean>();
        String currentUser = org.exoplatform.wiki.utils.Utils.getCurrentUser();
        try {
            Class<?> spaceServiceClass = Class.forName("org.exoplatform.social.core.space.spi.SpaceService");
            Object spaceService = ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(spaceServiceClass);
            Class<?> spaceClass = Class.forName("org.exoplatform.social.core.space.model.Space");
            ListAccess spaces = null;
            if (StringUtils.isEmpty((String)keyword)) {
                keyword = "*";
            }
            keyword = keyword.trim();
            Class<?> spaceFilterClass = Class.forName("org.exoplatform.social.core.space.SpaceFilter");
            Object spaceFilter = spaceFilterClass.getConstructor(String.class).newInstance(keyword);
            spaceFilterClass.getDeclaredMethod("setRemoteId", String.class).invoke(spaceFilter, currentUser);
            spaceFilterClass.getDeclaredMethod("setAppId", String.class).invoke(spaceFilter, "Wiki");
            spaces = (ListAccess)spaceServiceClass.getDeclaredMethod("getAccessibleSpacesByFilter", String.class, spaceFilterClass).invoke(spaceService, currentUser, spaceFilter);
            for (Object space : spaces.load(0, spaces.getSize())) {
                String groupId = String.valueOf(spaceClass.getMethod("getGroupId", new Class[0]).invoke(space, new Object[0]));
                String spaceName = String.valueOf(spaceClass.getMethod("getDisplayName", new Class[0]).invoke(space, new Object[0]));
                String avatarUrl = String.valueOf(spaceClass.getMethod("getAvatarUrl", new Class[0]).invoke(space, new Object[0]));
                if (StringUtils.isEmpty((String)avatarUrl) || "null".equalsIgnoreCase(avatarUrl)) {
                    avatarUrl = this.getDefaultSpaceAvatarUrl();
                }
                spaceBeans.add(new SpaceBean(groupId, spaceName, PortalConfig.GROUP_TYPE, avatarUrl));
            }
        }
        catch (ClassNotFoundException e) {
            Collection<Wiki> wikis = org.exoplatform.wiki.utils.Utils.getWikisByType(WikiType.GROUP);
            if (keyword != null) {
                keyword = keyword.trim();
            }
            for (Wiki wiki : wikis) {
                if (!wiki.getName().contains(keyword)) continue;
                spaceBeans.add(new SpaceBean(wiki.getOwner(), wiki.getName(), PortalConfig.GROUP_TYPE, ""));
            }
        }
        return spaceBeans;
    }

    private String getDefaultSpaceAvatarUrl() {
        try {
            Class<?> linkProviderClass = Class.forName("org.exoplatform.social.core.service.LinkProvider");
            return linkProviderClass.getDeclaredField("SPACE_DEFAULT_AVATAR_URL").get(null).toString();
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public boolean addRelatedPage(WikiPageParams orginaryPageParams, WikiPageParams relatedPageParams) throws Exception {
        PageImpl related;
        PageImpl orginary = (PageImpl)this.getPageById(orginaryPageParams.getType(), orginaryPageParams.getOwner(), orginaryPageParams.getPageId());
        return orginary.addRelatedPage(related = (PageImpl)this.getPageById(relatedPageParams.getType(), relatedPageParams.getOwner(), relatedPageParams.getPageId())) != null;
    }

    @Override
    public List<Page> getRelatedPage(WikiPageParams pageParams) throws Exception {
        PageImpl page = (PageImpl)this.getPageById(pageParams.getType(), pageParams.getOwner(), pageParams.getPageId());
        List<PageImpl> pages = page.getRelatedPages();
        return new ArrayList<Page>(pages);
    }

    @Override
    public boolean removeRelatedPage(WikiPageParams orginaryPageParams, WikiPageParams relatedPageParams) throws Exception {
        PageImpl related;
        PageImpl orginary = (PageImpl)this.getPageById(orginaryPageParams.getType(), orginaryPageParams.getOwner(), orginaryPageParams.getPageId());
        return orginary.removeRelatedPage(related = (PageImpl)this.getPageById(relatedPageParams.getType(), relatedPageParams.getOwner(), relatedPageParams.getPageId())) != null;
    }

    @Override
    public String getWikiWebappUri() {
        return this.wikiWebappUri;
    }

    @Override
    public boolean isSpaceMember(String spaceId, String userId) {
        try {
            Class<?> spaceServiceClass = Class.forName("org.exoplatform.social.core.space.spi.SpaceService");
            Object spaceService = ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(spaceServiceClass);
            Class<?> spaceClass = Class.forName("org.exoplatform.social.core.space.model.Space");
            Object space = spaceServiceClass.getDeclaredMethod("getSpaceByPrettyName", String.class).invoke(spaceService, spaceId);
            Boolean bool = Boolean.valueOf(String.valueOf(spaceServiceClass.getDeclaredMethod("isMember", spaceClass, String.class).invoke(spaceService, space, userId)));
            return bool;
        }
        catch (Exception e) {
            log.debug((Object)"Can not check if user is space member", (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean isHiddenSpace(String groupId) throws Exception {
        try {
            Class<?> spaceServiceClass = Class.forName("org.exoplatform.social.core.space.spi.SpaceService");
            Object spaceService = ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(spaceServiceClass);
            Class<?> spaceClass = Class.forName("org.exoplatform.social.core.space.model.Space");
            Object space = spaceServiceClass.getDeclaredMethod("getSpaceByGroupId", String.class).invoke(spaceService, groupId);
            String visibility = String.valueOf(spaceClass.getDeclaredMethod("getVisibility", new Class[0]).invoke(space, new Object[0]));
            String hiddenValue = String.valueOf(spaceClass.getDeclaredField("HIDDEN").get(space));
            return hiddenValue.equals(visibility);
        }
        catch (ClassNotFoundException e) {
            return true;
        }
    }

    @Override
    public DraftPage createDraftForNewPage(WikiPageParams parentPageParam, long clientTime) throws Exception {
        String draftSuffix = new SimpleDateFormat("yyyyMMddHHmmss").format(new Date(clientTime));
        Page parentPage = this.getPageById(parentPageParam.getType(), parentPageParam.getOwner(), parentPageParam.getPageId());
        String draftName = UNTITLED_PREFIX + draftSuffix;
        Model model = this.getModel();
        UserWiki userWiki = (UserWiki)this.getWiki(PortalConfig.USER_TYPE, org.exoplatform.wiki.utils.Utils.getCurrentUser(), model);
        PageImpl draftPagesContainer = userWiki.getDraftPagesContainer();
        DraftPageImpl draftPage = userWiki.createDraftPage();
        draftPage.setName(draftName);
        draftPagesContainer.addWikiPage(draftPage);
        draftPage.setNewPage(true);
        draftPage.setTargetPage(parentPage.getJCRPageNode().getUUID());
        draftPage.setTargetRevision("1");
        return draftPage;
    }

    @Override
    public DraftPage createDraftForExistPage(WikiPageParams param, String revision, long clientTime) throws Exception {
        String draftSuffix = new SimpleDateFormat("yyyyMMddHHmmss").format(new Date(clientTime));
        Page targetPage = this.getPageById(param.getType(), param.getOwner(), param.getPageId());
        String draftName = targetPage.getName() + "_" + draftSuffix;
        Model model = this.getModel();
        UserWiki userWiki = (UserWiki)this.getWiki(PortalConfig.USER_TYPE, org.exoplatform.wiki.utils.Utils.getCurrentUser(), model);
        PageImpl draftPagesContainer = userWiki.getDraftPagesContainer();
        DraftPageImpl draftPage = userWiki.createDraftPage();
        draftPage.setName(draftName);
        draftPagesContainer.addWikiPage(draftPage);
        draftPage.setNewPage(false);
        draftPage.setTargetPage(targetPage.getJCRPageNode().getUUID());
        if (StringUtils.isEmpty((String)revision)) {
            draftPage.setTargetRevision(org.exoplatform.wiki.utils.Utils.getLastRevisionOfPage(targetPage).getName());
        } else {
            draftPage.setTargetRevision(revision);
        }
        return draftPage;
    }

    @Override
    public DraftPage getDraft(WikiPageParams param) throws Exception {
        if (param.getPageId() == null || param.getOwner() == null || param.getType() == null) {
            return null;
        }
        Page targetPage = this.getPageById(param.getType(), param.getOwner(), param.getPageId());
        if (param.getPageId() == null || targetPage == null) {
            return null;
        }
        return this.getDraftOfWikiPage(targetPage);
    }

    @Override
    public DraftPage getLastestDraft() throws Exception {
        if (IdentityConstants.ANONIM.equals(org.exoplatform.wiki.utils.Utils.getCurrentUser())) {
            return null;
        }
        Collection<PageImpl> childPages = this.getDraftContainerOfCurrentUser().getChildPages().values();
        PageImpl lastestDraft = null;
        for (PageImpl draft : childPages) {
            DraftPageImpl draftPage = (DraftPageImpl)draft;
            if (lastestDraft != null && lastestDraft.getUpdatedDate().getTime() >= draftPage.getUpdatedDate().getTime()) continue;
            lastestDraft = draftPage;
        }
        return lastestDraft;
    }

    @Override
    public DraftPage getDraft(String draftName) throws Exception {
        if (draftName == null) {
            return null;
        }
        String currentUser = org.exoplatform.wiki.utils.Utils.getCurrentUser();
        if (currentUser == null || IdentityConstants.ANONIM.equals(currentUser)) {
            return null;
        }
        List<DraftPage> drafts = this.getDrafts(org.exoplatform.wiki.utils.Utils.getCurrentUser());
        for (DraftPage draftPage : drafts) {
            if (!draftPage.getName().equals(draftName)) continue;
            return draftPage;
        }
        return null;
    }

    @Override
    public void removeDraft(WikiPageParams param) throws Exception {
        DraftPageImpl draftPage = (DraftPageImpl)this.getDraft(param);
        if (draftPage != null) {
            draftPage.remove();
        }
    }

    @Override
    public void removeDraft(String draftName) throws Exception {
        DraftPage draftPage = this.getDraft(draftName);
        if (draftPage != null) {
            draftPage.remove();
        }
    }

    @Override
    public List<DraftPage> getDrafts(String username) throws Exception {
        ArrayList<DraftPage> draftPages = new ArrayList<DraftPage>();
        if (!IdentityConstants.ANONIM.equals(org.exoplatform.wiki.utils.Utils.getCurrentUser())) {
            Collection<PageImpl> childPages = this.getDraftContainerOfCurrentUser().getChildPages().values();
            for (PageImpl pageImpl : childPages) {
                draftPages.add((DraftPageImpl)pageImpl);
            }
        }
        return draftPages;
    }

    @Override
    public Page getWikiPageByUUID(String uuid) throws Exception {
        Model model = this.getModel();
        WikiStore wStore = model.getWikiStore();
        return this.jcrDataStorage.getWikiPageByUUID(wStore.getSession(), uuid);
    }

    @Override
    public void postUpdatePage(String wikiType, String wikiOwner, String pageId, Page page, String wikiUpdateType) throws Exception {
        List<PageWikiListener> listeners = this.getPageListeners();
        for (PageWikiListener l : listeners) {
            try {
                l.postUpdatePage(wikiType, wikiOwner, pageId, page, wikiUpdateType);
            }
            catch (Exception e) {
                if (!log.isWarnEnabled()) continue;
                PageImpl pageImpl = (PageImpl)page;
                log.warn((Object)String.format("executing listener [%s] on [%s] failed", ((Object)((Object)l)).toString(), pageImpl.getPath()), (Throwable)e);
            }
        }
    }

    @Override
    public void postAddPage(String wikiType, String wikiOwner, String pageId, Page page) throws Exception {
        List<PageWikiListener> listeners = this.getPageListeners();
        for (PageWikiListener l : listeners) {
            try {
                l.postAddPage(wikiType, wikiOwner, pageId, page);
            }
            catch (Exception e) {
                if (!log.isWarnEnabled()) continue;
                PageImpl pageImpl = (PageImpl)page;
                log.warn((Object)String.format("executing listener [%s] on [%s] failed", ((Object)((Object)l)).toString(), pageImpl.getPath()), (Throwable)e);
            }
        }
    }

    @Override
    public void postDeletePage(String wikiType, String wikiOwner, String pageId, Page page) throws Exception {
        List<PageWikiListener> listeners = this.getPageListeners();
        for (PageWikiListener l : listeners) {
            try {
                l.postDeletePage(wikiType, wikiOwner, pageId, page);
            }
            catch (Exception e) {
                if (!log.isWarnEnabled()) continue;
                PageImpl pageImpl = (PageImpl)page;
                log.warn((Object)String.format("executing listener [%s] on [%s] failed", ((Object)((Object)l)).toString(), pageImpl.getPath()), (Throwable)e);
            }
        }
    }

    @Override
    public String getSpaceNameByGroupId(String groupId) throws Exception {
        try {
            Class<?> spaceServiceClass = Class.forName("org.exoplatform.social.core.space.spi.SpaceService");
            Object spaceService = ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(spaceServiceClass);
            Class<?> spaceClass = Class.forName("org.exoplatform.social.core.space.model.Space");
            Object space = spaceServiceClass.getDeclaredMethod("getSpaceByGroupId", String.class).invoke(spaceService, groupId);
            return String.valueOf(spaceClass.getDeclaredMethod("getDisplayName", new Class[0]).invoke(space, new Object[0]));
        }
        catch (ClassNotFoundException e) {
            return groupId.substring(groupId.lastIndexOf(47) + 1);
        }
    }

    private DraftPage getDraftOfWikiPage(Page targetPage) throws Exception {
        if (targetPage == null) {
            return null;
        }
        if (IdentityConstants.ANONIM.equals(org.exoplatform.wiki.utils.Utils.getCurrentUser())) {
            return null;
        }
        Collection<PageImpl> childPages = this.getDraftContainerOfCurrentUser().getChildPages().values();
        PageImpl lastestDraft = null;
        for (PageImpl draft : childPages) {
            DraftPageImpl draftPage = (DraftPageImpl)draft;
            if (draftPage.getTargetPage() == null || draftPage.isNewPage() || !draftPage.getTargetPage().equals(targetPage.getJCRPageNode().getUUID()) || lastestDraft != null && lastestDraft.getUpdatedDate().getTime() >= draftPage.getUpdatedDate().getTime()) continue;
            lastestDraft = draftPage;
        }
        return lastestDraft;
    }

    private PageImpl getDraftContainerOfCurrentUser() {
        Model model = this.getModel();
        UserWiki userWiki = (UserWiki)this.getWiki(PortalConfig.USER_TYPE, org.exoplatform.wiki.utils.Utils.getCurrentUser(), model);
        return userWiki.getDraftPagesContainer();
    }

    private void removeHelpPages() {
        try {
            Model model = this.getModel();
            WikiStoreImpl wikiStore = (WikiStoreImpl)model.getWikiStore();
            HelpPage helpPages = wikiStore.getHelpPagesContainer();
            helpPages.remove();
        }
        catch (Exception e) {
            log.warn((Object)"Can not remove help pages ...");
        }
    }

    @Override
    public Wiki getWikiById(String wikiId) {
        WikiService wikiService = (WikiService)PortalContainer.getComponent(WikiService.class);
        Wiki wiki = null;
        if (wikiId.startsWith("/spaces/")) {
            wiki = wikiService.getWiki(PortalConfig.GROUP_TYPE, wikiId);
        } else if (wikiId.startsWith("/user/")) {
            wikiId = wikiId.substring(wikiId.lastIndexOf(47) + 1);
            wiki = wikiService.getWiki(PortalConfig.USER_TYPE, wikiId);
        } else if (wikiId.startsWith("/" + org.exoplatform.wiki.utils.Utils.getPortalName())) {
            wikiId = wikiId.substring(wikiId.lastIndexOf(47) + 1);
            wiki = wikiService.getWiki(PortalConfig.PORTAL_TYPE, wikiId);
        }
        return wiki;
    }

    @Override
    public String getWikiNameById(String wikiId) throws Exception {
        Wiki wiki = this.getWikiById(wikiId);
        if (wiki instanceof PortalWiki) {
            String displayName = wiki.getName();
            int slashIndex = displayName.lastIndexOf(47);
            if (slashIndex > -1) {
                displayName = displayName.substring(slashIndex + 1);
            }
            return displayName;
        }
        if (wiki instanceof UserWiki) {
            String currentUser = org.exoplatform.wiki.utils.Utils.getCurrentUser();
            if (wiki.getOwner().equals(currentUser)) {
                WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
                ResourceBundle res = context.getApplicationResourceBundle();
                String mySpaceLabel = res.getString("UISpaceSwitcher.title.my-space");
                return mySpaceLabel;
            }
            return wiki.getOwner();
        }
        WikiService wikiService = (WikiService)PortalContainer.getComponent(WikiService.class);
        return wikiService.getSpaceNameByGroupId(wiki.getOwner());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        try {
            ChromatticManager chromatticManager = (ChromatticManager)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(ChromatticManager.class);
            RequestLifeCycle.begin((ComponentRequestLifecycle)chromatticManager);
            try {
                this.setTemplatePagePlugin();
            }
            catch (Exception e) {
                log.warn((Object)"Can not init page templates ...");
            }
            this.addEmotionIcons();
            this.removeHelpPages();
            try {
                this.getWikiHome(PortalConfig.GROUP_TYPE, "sandbox");
            }
            catch (Exception e) {
                log.warn((Object)"Can not init sandbox wiki ...");
            }
        }
        catch (Exception e) {
            log.warn((Object)"Can not start WikiService ...", (Throwable)e);
        }
        finally {
            RequestLifeCycle.end();
        }
    }

    public void stop() {
    }
}

