/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.service.jcrext;

import java.util.Arrays;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.Property;
import org.apache.commons.chain.Context;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.command.action.Action;
import org.exoplatform.services.ext.action.InvocationContext;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.wiki.mow.api.Wiki;
import org.exoplatform.wiki.mow.core.api.wiki.PageImpl;
import org.exoplatform.wiki.rendering.cache.PageRenderingCacheService;
import org.exoplatform.wiki.service.WikiPageParams;
import org.exoplatform.wiki.utils.Utils;

public class UpdateWikiPageAction
implements Action {
    List<String> unSupportChangePageInfo = Arrays.asList("watcher");

    public boolean execute(Context context) throws Exception {
        Node wikiPageNode;
        Object item = context.get((Object)"currentItem");
        Object eventObj = context.get((Object)InvocationContext.EVENT);
        int eventCode = Integer.parseInt(eventObj.toString());
        Node node = wikiPageNode = item instanceof Property ? ((Property)item).getParent() : (Node)item;
        if (wikiPageNode.isNodeType("wiki:attachment")) {
            PageRenderingCacheService pRenderingCacheService = (PageRenderingCacheService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(PageRenderingCacheService.class);
            PageImpl parentPage = (PageImpl)Utils.getObject(wikiPageNode.getParent().getPath(), "wiki:page");
            Wiki wiki = parentPage.getWiki();
            if (wiki != null) {
                pRenderingCacheService.invalidateAttachmentCache(new WikiPageParams(wiki.getType(), wiki.getOwner(), parentPage.getName()));
            }
        }
        if (wikiPageNode.isNodeType("wiki:content") || wikiPageNode.isNodeType("wiki:attachment")) {
            wikiPageNode = wikiPageNode.getParent();
        }
        if (!wikiPageNode.isNodeType("wiki:page")) {
            throw new Exception("Incoming node is not wiki:page nodetype but " + wikiPageNode.getPrimaryNodeType().getName());
        }
        ConversationState conversationState = ConversationState.getCurrent();
        String userName = null;
        if (conversationState != null && conversationState.getIdentity() != null) {
            userName = conversationState.getIdentity().getUserId();
        }
        Calendar calendar = GregorianCalendar.getInstance();
        if (eventCode == 1 && item instanceof Node && ((Node)item).isNodeType("wiki:page")) {
            wikiPageNode.setProperty("createdDate", calendar);
            wikiPageNode.setProperty("updatedDate", calendar);
            wikiPageNode.setProperty("author", userName);
        }
        if (item instanceof Property && ((Property)item).getParent().isNodeType("wiki:page") && !this.unSupportChangePageInfo.contains(((Property)item).getName())) {
            wikiPageNode.setProperty("updatedDate", calendar);
            wikiPageNode.setProperty("author", userName);
        }
        return false;
    }
}

