/*
 * Copyright (C) 2003-2009 eXo Platform SAS.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Affero General Public License
 * as published by the Free Software Foundation; either version 3
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see<http://www.gnu.org/licenses/>.
 */
package org.exoplatform.wiki.mow.core.api.content;

import java.util.List;

import org.chromattic.api.annotations.Id;
import org.chromattic.api.annotations.OneToMany;
import org.chromattic.api.annotations.PrimaryType;
import org.chromattic.api.annotations.Property;
import org.exoplatform.wiki.mow.api.WikiNodeType;
import org.exoplatform.wiki.mow.api.content.ContentItem;

/**
 * @version $Revision$
 */
@PrimaryType(name = WikiNodeType.WIKI_CONTENT_ITEM)
public abstract class AbstractContentItem implements ContentItem {

  @OneToMany
  public abstract List<AbstractContentItem> getChildren();

  @Id
  public abstract String getId();

  @Property(name = WikiNodeType.Definition.TEXT)
  public abstract String getText();
}
