/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.mow.core.api.wiki;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.jcr.LoginException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.version.Version;
import javax.jcr.version.VersionIterator;
import org.chromattic.api.ChromatticSession;
import org.chromattic.api.DuplicateNameException;
import org.chromattic.api.RelationshipType;
import org.chromattic.api.annotations.Create;
import org.chromattic.api.annotations.DefaultValue;
import org.chromattic.api.annotations.Destroy;
import org.chromattic.api.annotations.ManyToOne;
import org.chromattic.api.annotations.MappedBy;
import org.chromattic.api.annotations.Name;
import org.chromattic.api.annotations.OneToMany;
import org.chromattic.api.annotations.OneToOne;
import org.chromattic.api.annotations.Owner;
import org.chromattic.api.annotations.Path;
import org.chromattic.api.annotations.PrimaryType;
import org.chromattic.api.annotations.Property;
import org.chromattic.api.annotations.WorkspaceName;
import org.chromattic.ext.ntdef.NTFolder;
import org.chromattic.ext.ntdef.Resource;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.access.PermissionType;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.wiki.WikiException;
import org.exoplatform.wiki.chromattic.ext.ntdef.NTVersion;
import org.exoplatform.wiki.chromattic.ext.ntdef.UncachedMixin;
import org.exoplatform.wiki.chromattic.ext.ntdef.VersionableMixin;
import org.exoplatform.wiki.mow.core.api.MOWService;
import org.exoplatform.wiki.mow.core.api.wiki.ActivityInfoMixin;
import org.exoplatform.wiki.mow.core.api.wiki.AttachmentImpl;
import org.exoplatform.wiki.mow.core.api.wiki.GroupWiki;
import org.exoplatform.wiki.mow.core.api.wiki.MigratingMixin;
import org.exoplatform.wiki.mow.core.api.wiki.MovedMixin;
import org.exoplatform.wiki.mow.core.api.wiki.PageDescriptionMixin;
import org.exoplatform.wiki.mow.core.api.wiki.PermissionImpl;
import org.exoplatform.wiki.mow.core.api.wiki.PortalWiki;
import org.exoplatform.wiki.mow.core.api.wiki.RemovedMixin;
import org.exoplatform.wiki.mow.core.api.wiki.RenamedMixin;
import org.exoplatform.wiki.mow.core.api.wiki.Trash;
import org.exoplatform.wiki.mow.core.api.wiki.UpdateAttachmentMixin;
import org.exoplatform.wiki.mow.core.api.wiki.UserWiki;
import org.exoplatform.wiki.mow.core.api.wiki.WatchedMixin;
import org.exoplatform.wiki.mow.core.api.wiki.WikiHome;
import org.exoplatform.wiki.mow.core.api.wiki.WikiImpl;
import org.exoplatform.wiki.rendering.converter.ConfluenceToXWiki2Transformer;
import org.exoplatform.wiki.rendering.util.Utils;
import org.exoplatform.wiki.resolver.TitleResolver;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.rendering.syntax.Syntax;

@PrimaryType(name="wiki:page")
public abstract class PageImpl
extends NTFolder {
    private static final Log LOG = ExoLogger.getLogger((String)PageImpl.class.getName());
    private MOWService mowService;
    private PermissionImpl permission = new PermissionImpl();
    private ComponentManager componentManager;
    private List<PageImpl> relatedPages = null;
    private boolean isMinorEdit = false;

    public String getID() throws RepositoryException {
        return this.getJCRPageNode().getUUID();
    }

    public void setMOWService(MOWService mowService) {
        this.mowService = mowService;
        this.permission.setMOWService(mowService);
    }

    public MOWService getMOWService() {
        return this.mowService;
    }

    public ChromatticSession getChromatticSession() {
        return this.mowService.getSession();
    }

    public Session getJCRSession() {
        return this.getChromatticSession().getJCRSession();
    }

    public void setComponentManager(ComponentManager componentManager) {
        this.componentManager = componentManager;
    }

    public Node getJCRPageNode() throws RepositoryException {
        return (Node)this.getChromatticSession().getJCRSession().getItem(this.getPath());
    }

    @Name
    public abstract String getName();

    public abstract void setName(String var1);

    @Path
    public abstract String getPath();

    @WorkspaceName
    public abstract String getWorkspace();

    @OneToOne
    @Owner
    @MappedBy(value="content")
    protected abstract AttachmentImpl getContentByChromattic();

    protected abstract void setContentByChromattic(AttachmentImpl var1);

    @Create
    protected abstract AttachmentImpl createContent();

    public AttachmentImpl getContent() {
        AttachmentImpl content = this.getContentByChromattic();
        if (content == null) {
            content = this.createContent();
            this.setContentByChromattic(content);
            content.setText("");
        } else {
            String syntax = this.getSyntax();
            if (Syntax.CONFLUENCE_1_0.toIdString().equals(syntax)) {
                content.setText(ConfluenceToXWiki2Transformer.transformContent((String)content.getText(), (ComponentManager)this.componentManager));
                this.setSyntax(Syntax.XWIKI_2_0.toIdString());
                this.setContentByChromattic(content);
            }
        }
        return content;
    }

    @Property(name="title")
    public abstract String getTitleByChromattic();

    public abstract void setTitleByChromattic(String var1);

    public String getTitle() {
        String title = this.getTitleByChromattic();
        return title != null ? title : this.getName();
    }

    public void setTitle(String title) {
        this.setTitleByChromattic(title);
    }

    @Property(name="syntax")
    public abstract String getSyntax();

    public abstract void setSyntax(String var1);

    @Property(name="comment")
    @DefaultValue(value={""})
    public abstract String getComment();

    public abstract void setComment(String var1);

    @Property(name="owner")
    public abstract String getOwner();

    public abstract void setOwner(String var1);

    @Property(name="author")
    public abstract String getAuthor();

    public abstract void setAuthor(String var1);

    @Property(name="createdDate")
    public abstract Date getCreatedDate();

    public abstract void setCreatedDate(Date var1);

    @Property(name="updatedDate")
    public abstract Date getUpdatedDate();

    public abstract void setUpdatedDate(Date var1);

    @Property(name="url")
    public abstract String getURL();

    public abstract void setURL(String var1);

    @OneToOne(type=RelationshipType.EMBEDDED)
    @Owner
    public abstract ActivityInfoMixin getActivityInfoMixin();

    public abstract void setActivityInfoMixin(ActivityInfoMixin var1);

    @OneToOne(type=RelationshipType.EMBEDDED)
    @Owner
    public abstract MovedMixin getMovedMixin();

    public abstract void setMovedMixin(MovedMixin var1);

    @OneToOne(type=RelationshipType.EMBEDDED)
    @Owner
    public abstract RemovedMixin getRemovedMixin();

    public abstract void setRemovedMixin(RemovedMixin var1);

    @OneToOne(type=RelationshipType.EMBEDDED)
    @Owner
    public abstract RenamedMixin getRenamedMixin();

    public abstract void setRenamedMixin(RenamedMixin var1);

    @OneToOne(type=RelationshipType.EMBEDDED)
    @Owner
    public abstract UncachedMixin getUncachedMixin();

    public abstract void setUncachedMixin(UncachedMixin var1);

    @OneToOne(type=RelationshipType.EMBEDDED)
    @Owner
    public abstract WatchedMixin getWatchedMixin();

    public abstract void setWatchedMixin(WatchedMixin var1);

    @Create
    protected abstract WatchedMixin createWatchedMixin();

    @OneToOne(type=RelationshipType.EMBEDDED)
    @Owner
    public abstract MigratingMixin getMigratingMixin();

    public abstract void setMigratingMixin(MigratingMixin var1);

    @Create
    protected abstract MigratingMixin createMigratingMixin();

    public void makeWatched() {
        WatchedMixin watchedMixin = this.getWatchedMixin();
        if (watchedMixin == null) {
            watchedMixin = this.createWatchedMixin();
            this.setWatchedMixin(watchedMixin);
        }
    }

    public VersionableMixin getVersionableMixin() {
        block2: {
            try {
                this.migrateLegacyData();
            }
            catch (Exception e) {
                if (!LOG.isWarnEnabled()) break block2;
                LOG.warn("Can not migrate legacy version data", new Object[]{e.getMessage()});
            }
        }
        return this.getContent().getVersionableMixin();
    }

    public void makeVersionable() {
        this.getContent().makeVersionable();
    }

    public NTVersion checkin() throws RepositoryException {
        PageDescriptionMixin description = this.getContent().getPageDescriptionMixin();
        description.setAuthor(ConversationState.getCurrent().getIdentity().getUserId());
        description.setUpdatedDate(GregorianCalendar.getInstance().getTime());
        description.setComment(this.getComment());
        NTVersion ret = this.getContent().checkin();
        return ret;
    }

    public void checkout() throws RepositoryException {
        this.getContent().checkout();
    }

    public void restore(String versionName, boolean removeExisting) throws WikiException {
        this.getContent().restore(versionName, removeExisting);
    }

    @Create
    public abstract AttachmentImpl createAttachment();

    public AttachmentImpl createAttachment(String fileName, Resource contentResource) throws WikiException {
        if (fileName == null) {
            throw new NullPointerException();
        }
        for (AttachmentImpl att : this.getAttachments()) {
            if (!att.getName().equals(fileName)) continue;
            att.remove();
        }
        AttachmentImpl file = this.createAttachment();
        file.setName(TitleResolver.getId(fileName, false));
        this.addAttachment(file);
        if (fileName.lastIndexOf(".") > 0) {
            file.setTitle(fileName.substring(0, fileName.lastIndexOf(".")));
            file.setFileType(fileName.substring(fileName.lastIndexOf(".")));
        } else {
            file.setTitle(fileName);
        }
        if (contentResource != null) {
            file.setContentResource(contentResource);
        }
        this.getChromatticSession().save();
        this.setFullPermissionForOwner(file);
        return file;
    }

    private void setFullPermissionForOwner(AttachmentImpl file) throws WikiException {
        ConversationState conversationState = ConversationState.getCurrent();
        if (conversationState != null) {
            HashMap<String, String[]> permissions = file.getPermission();
            permissions.put(conversationState.getIdentity().getUserId(), PermissionType.ALL);
            file.setPermission(permissions);
        }
    }

    @OneToMany
    public abstract Collection<AttachmentImpl> getAttachmentsByChromattic();

    public Collection<AttachmentImpl> getAttachments() {
        return this.getAttachmentsByChromattic();
    }

    public Collection<AttachmentImpl> getAttachmentsExcludeContent() throws RepositoryException {
        ArrayList<AttachmentImpl> atts = new ArrayList<AttachmentImpl>();
        String path = this.getPath();
        StringBuilder statement = new StringBuilder("SELECT * FROM ");
        statement.append("wiki:attachment").append(" WHERE jcr:path LIKE '").append(path).append("/%' AND NOT jcr:path LIKE '").append(path).append("/%/%'");
        NodeIterator iter = this.getChromatticSession().getJCRSession().getWorkspace().getQueryManager().createQuery(statement.toString(), "sql").execute().getNodes();
        while (iter.hasNext()) {
            Node node = iter.nextNode();
            AttachmentImpl att = (AttachmentImpl)this.getChromatticSession().findByNode(AttachmentImpl.class, node);
            if (!att.hasPermission(org.exoplatform.wiki.mow.api.PermissionType.VIEW_ATTACHMENT) && !att.hasPermission(org.exoplatform.wiki.mow.api.PermissionType.EDIT_ATTACHMENT) || "content".equals(att.getName())) continue;
            atts.add(att);
        }
        Collections.sort(atts);
        return atts;
    }

    public Collection<AttachmentImpl> getAttachmentsExcludeContentByRootPermisison() {
        Collection<AttachmentImpl> attachments = this.getAttachmentsByChromattic();
        ArrayList<AttachmentImpl> atts = new ArrayList<AttachmentImpl>(attachments.size());
        for (AttachmentImpl attachment : attachments) {
            if ("content".equals(attachment.getName())) continue;
            atts.add(attachment);
        }
        Collections.sort(atts);
        return atts;
    }

    public AttachmentImpl getAttachment(String attachmentId) {
        for (AttachmentImpl attachment : this.getAttachments()) {
            if (!attachment.getName().equals(attachmentId) || !attachment.hasPermission(org.exoplatform.wiki.mow.api.PermissionType.VIEW_ATTACHMENT) && !attachment.hasPermission(org.exoplatform.wiki.mow.api.PermissionType.EDIT_ATTACHMENT)) continue;
            return attachment;
        }
        return null;
    }

    public AttachmentImpl getAttachmentByRootPermisison(String attachmentId) throws Exception {
        for (AttachmentImpl attachment : this.getAttachments()) {
            if (!attachment.getName().equals(attachmentId)) continue;
            return attachment;
        }
        return null;
    }

    public void addAttachment(AttachmentImpl attachment) throws DuplicateNameException {
        this.getAttachments().add(attachment);
    }

    public void removeAttachment(String attachmentId) {
        AttachmentImpl attachment = this.getAttachment(attachmentId);
        if (attachment != null) {
            attachment.remove();
        }
    }

    @ManyToOne
    public abstract PageImpl getParentPage();

    public abstract void setParentPage(PageImpl var1);

    @ManyToOne
    public abstract Trash getTrash();

    public abstract void setTrash(Trash var1);

    @OneToMany
    protected abstract Map<String, PageImpl> getChildrenContainer();

    public Map<String, PageImpl> getChildPages() {
        TreeMap<String, PageImpl> result = new TreeMap<String, PageImpl>(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareTo(o2);
            }
        });
        ArrayList<PageImpl> pages = new ArrayList<PageImpl>(this.getChildrenContainer().values());
        for (int i = 0; i < pages.size(); ++i) {
            PageImpl page = (PageImpl)((Object)pages.get(i));
            if (page == null || !page.hasPermission(org.exoplatform.wiki.mow.api.PermissionType.VIEWPAGE)) continue;
            result.put(page.getName(), page);
        }
        return result;
    }

    public Map<String, PageImpl> getChildrenByRootPermission() {
        TreeMap<String, PageImpl> result = new TreeMap<String, PageImpl>(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareTo(o2);
            }
        });
        ArrayList<PageImpl> pages = new ArrayList<PageImpl>(this.getChildrenContainer().values());
        for (int i = 0; i < pages.size(); ++i) {
            PageImpl page = (PageImpl)((Object)pages.get(i));
            if (page == null) continue;
            result.put(page.getTitle(), page);
        }
        return result;
    }

    @Property(name="isOverridePermission")
    public abstract boolean getOverridePermission();

    public abstract void setOverridePermission(boolean var1);

    public boolean hasPermission(org.exoplatform.wiki.mow.api.PermissionType permissionType) {
        return this.permission.hasPermission(permissionType, this.getPath());
    }

    public boolean hasPermission(org.exoplatform.wiki.mow.api.PermissionType permissionType, Identity user) {
        return this.permission.hasPermission(permissionType, this.getPath(), user);
    }

    public HashMap<String, String[]> getPermission() throws WikiException {
        return this.permission.getPermission(this.getPath());
    }

    public void setPermission(HashMap<String, String[]> permissions) throws WikiException {
        this.permission.setPermission(permissions, this.getPath());
    }

    public void setNonePermission() throws WikiException {
        this.setPermission(null);
    }

    public String getActivityId() {
        String activityId = null;
        ActivityInfoMixin activityInfoMixin = this.getActivityInfoMixin();
        if (activityInfoMixin != null) {
            activityId = activityInfoMixin.getActivityId();
        }
        return activityId;
    }

    public void setActivityId(String activityId) {
        ActivityInfoMixin activityInfoMixin = this.getActivityInfoMixin();
        if (activityInfoMixin == null) {
            ChromatticSession session = this.mowService.getSession();
            this.setActivityInfoMixin((ActivityInfoMixin)session.create(ActivityInfoMixin.class));
            ActivityInfoMixin mixin = this.getActivityInfoMixin();
            mixin.setActivityId(activityId);
        } else if (!activityId.equals(activityInfoMixin.getActivityId())) {
            ActivityInfoMixin mixin = this.getActivityInfoMixin();
            mixin.setActivityId(activityId);
        }
    }

    protected void addPage(String pageName, PageImpl page) {
        Map<String, PageImpl> children = this.getChildrenContainer();
        if (children.containsKey(pageName)) {
            throw new IllegalStateException("Page with name " + pageName + " already exists");
        }
        children.put(pageName, page);
    }

    public void addWikiPage(PageImpl page) {
        this.addPage(page.getName(), page);
    }

    public void addPublicPage(PageImpl page) throws WikiException {
        this.addWikiPage(page);
        page.setNonePermission();
    }

    public PageImpl getWikiPage(String pageId) throws Exception {
        if ("WikiHome".equalsIgnoreCase(pageId)) {
            return this;
        }
        for (PageImpl page : this.getChildPages().values()) {
            if (!pageId.equals(page.getName())) continue;
            return page;
        }
        return null;
    }

    public WikiImpl getWiki() {
        WikiHome wikiHome = this.getWikiHome();
        if (wikiHome != null) {
            PortalWiki portalWiki = wikiHome.getPortalWiki();
            GroupWiki groupWiki = wikiHome.getGroupWiki();
            UserWiki userWiki = wikiHome.getUserWiki();
            if (portalWiki != null) {
                return portalWiki;
            }
            if (groupWiki != null) {
                return groupWiki;
            }
            return userWiki;
        }
        return null;
    }

    public WikiHome getWikiHome() {
        PageImpl parent;
        if (this instanceof WikiHome) {
            parent = this;
        } else {
            for (parent = this.getParentPage(); parent != null && !(parent instanceof WikiHome); parent = parent.getParentPage()) {
            }
        }
        return (WikiHome)parent;
    }

    public boolean isMinorEdit() {
        return this.isMinorEdit;
    }

    public void setMinorEdit(boolean isMinorEdit) {
        this.isMinorEdit = isMinorEdit;
    }

    @Destroy
    public abstract void remove();

    public synchronized String addRelatedPage(PageImpl page) throws RepositoryException {
        Map<String, Value> referredUUIDs = this.getReferredUUIDs();
        Session jcrSession = this.getJCRSession();
        Node myJcrNode = (Node)jcrSession.getItem(this.getPath());
        Node referredJcrNode = (Node)jcrSession.getItem(page.getPath());
        String referedUUID = referredJcrNode.getUUID();
        if (referredUUIDs.containsKey(referedUUID)) {
            return null;
        }
        Value value2Add = jcrSession.getValueFactory().createValue(referredJcrNode);
        referredUUIDs.put(referedUUID, value2Add);
        myJcrNode.setProperty("exo:relation", referredUUIDs.values().toArray(new Value[referredUUIDs.size()]));
        myJcrNode.save();
        if (this.relatedPages != null) {
            this.relatedPages.add(page);
        }
        return referedUUID;
    }

    public List<PageImpl> getRelatedPages() throws RepositoryException {
        if (this.relatedPages == null) {
            this.relatedPages = new ArrayList<PageImpl>();
            Iterator<Map.Entry<String, Value>> refferedIter = this.getReferredUUIDs().entrySet().iterator();
            ChromatticSession chSession = this.getChromatticSession();
            while (refferedIter.hasNext()) {
                Map.Entry<String, Value> entry = refferedIter.next();
                PageImpl page = (PageImpl)((Object)chSession.findById(PageImpl.class, entry.getValue().getString()));
                if (page == null || !page.hasPermission(org.exoplatform.wiki.mow.api.PermissionType.VIEWPAGE)) continue;
                this.relatedPages.add(page);
            }
        }
        return new ArrayList<PageImpl>(this.relatedPages);
    }

    public synchronized String removeRelatedPage(PageImpl page) throws RepositoryException {
        Map<String, Value> referedUUIDs = this.getReferredUUIDs();
        Session jcrSession = this.getJCRSession();
        Node referredJcrNode = (Node)jcrSession.getItem(page.getPath());
        Node myJcrNode = (Node)jcrSession.getItem(this.getPath());
        String referredUUID = referredJcrNode.getUUID();
        if (!referedUUIDs.containsKey(referredUUID)) {
            return null;
        }
        referedUUIDs.remove(referredUUID);
        myJcrNode.setProperty("exo:relation", referedUUIDs.values().toArray(new Value[referedUUIDs.size()]));
        myJcrNode.save();
        if (this.relatedPages != null) {
            this.relatedPages.remove((Object)page);
        }
        return referredUUID;
    }

    public Map<String, Value> getReferredUUIDs() throws RepositoryException {
        Value[] values;
        Session jcrSession = this.getJCRSession();
        Node myJcrNode = (Node)jcrSession.getItem(this.getPath());
        HashMap<String, Value> referedUUIDs = new HashMap<String, Value>();
        if (myJcrNode.hasProperty("exo:relation") && (values = myJcrNode.getProperty("exo:relation").getValues()) != null && values.length > 0) {
            for (Value value : values) {
                referedUUIDs.put(value.getString(), value);
            }
        }
        return referedUUIDs;
    }

    public synchronized void removeAllRelatedPages() throws Exception {
        Session jcrSession = this.getJCRSession();
        Node myJcrNode = (Node)jcrSession.getItem(this.getPath());
        myJcrNode.setProperty("exo:relation", (Value[])null);
        myJcrNode.save();
        if (this.relatedPages != null) {
            this.relatedPages.clear();
        }
    }

    public void migrateLegacyData() throws RepositoryException {
        if (this.getJCRPageNode().isNodeType("mix:versionable") && this.getContent().getVersionableMixinByChromattic() == null) {
            Node pageNode = this.getJCRPageNode();
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("Migrating history for wiki page: " + pageNode.getPath()));
            }
            ArrayList<VersionData> versions = new ArrayList<VersionData>();
            VersionIterator iter = pageNode.getVersionHistory().getAllVersions();
            while (iter.hasNext()) {
                Version v = iter.nextVersion();
                if (!v.hasNode("jcr:frozenNode")) continue;
                String name = v.getName();
                Node frozenNode = v.getNode("jcr:frozenNode");
                String author = frozenNode.hasProperty("author") ? frozenNode.getProperty("author").getString() : "";
                Calendar calendar = frozenNode.hasProperty("updatedDate") ? frozenNode.getProperty("updatedDate").getDate() : GregorianCalendar.getInstance();
                String content = frozenNode.getNode("content").getNode("jcr:content").getProperty("jcr:data").getString();
                String comment = frozenNode.hasProperty("comment") ? frozenNode.getProperty("comment").getString() : "";
                versions.add(new VersionData(name, author, calendar, content, comment));
            }
            Collections.sort(versions);
            MigratingMixin migrateMix = this.createMigratingMixin();
            this.setMigratingMixin(migrateMix);
            this.makeVersionable();
            AttachmentImpl content = this.getContent();
            String currentContent = content.getText();
            for (int i = 0; i < versions.size(); ++i) {
                if (i % 10 == 0 && LOG.isInfoEnabled()) {
                    LOG.info((Object)("Creating new version: " + i));
                }
                PageDescriptionMixin description = content.getPageDescriptionMixin();
                description.setAuthor(((VersionData)versions.get(i)).getAuthor());
                description.setUpdatedDate(((VersionData)versions.get(i)).getCalendar().getTime());
                content.setText(((VersionData)versions.get(i)).getContent());
                description.setComment(((VersionData)versions.get(i)).getComment());
                content.checkin();
                content.checkout();
            }
            content.setText(currentContent);
            this.getChromatticSession().setEmbedded((Object)this, MigratingMixin.class, null);
            pageNode.save();
            this.removeMixVersionable(pageNode);
        }
    }

    @OneToOne(type=RelationshipType.EMBEDDED)
    @Owner
    public abstract UpdateAttachmentMixin getUpdateAttachmentMixin();

    public abstract void setUpdateAttachmentMixin(UpdateAttachmentMixin var1);

    @Create
    public abstract UpdateAttachmentMixin createUpdateAttachmentMixin();

    public void migrateAttachmentPermission() throws WikiException {
        boolean isGroupWiki = PortalConfig.GROUP_TYPE.equals(this.getWiki().getType());
        UpdateAttachmentMixin updateAttachment = this.getUpdateAttachmentMixin();
        if (updateAttachment == null) {
            Collection<AttachmentImpl> attachments = this.getAttachmentsExcludeContentByRootPermisison();
            HashSet<String> permissionKeys = new HashSet<String>(this.getPermission().keySet());
            for (AttachmentImpl attachment : attachments) {
                HashMap<String, String[]> permissions = attachment.getPermission();
                Iterator<Map.Entry<String, String[]>> permissionIterator = permissions.entrySet().iterator();
                while (permissionIterator.hasNext()) {
                    Map.Entry<String, String[]> attachmentPermissionEntry = permissionIterator.next();
                    String attachmentPermissionKey = attachmentPermissionEntry.getKey();
                    if (permissionKeys.contains(attachmentPermissionKey)) {
                        permissionKeys.remove(attachmentPermissionKey);
                        continue;
                    }
                    permissionIterator.remove();
                }
                for (String permissionEntry : permissionKeys) {
                    if (isGroupWiki && permissionEntry.contains(this.getWiki().getOwner())) {
                        permissions.put(permissionEntry, PermissionType.ALL);
                        continue;
                    }
                    permissions.put(permissionEntry, new String[]{"read"});
                }
                attachment.setPermission(permissions);
            }
            updateAttachment = this.createUpdateAttachmentMixin();
            this.setUpdateAttachmentMixin(updateAttachment);
        }
    }

    private void removeMixVersionable(Node node) {
        new Thread(new RemoveMixVersionable(node)).start();
    }

    public class VersionData
    implements Comparable<VersionData> {
        private String name;
        private String author;
        private Calendar calendar;
        private String content;
        private String comment;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getAuthor() {
            return this.author;
        }

        public void setAuthor(String author) {
            this.author = author;
        }

        public Calendar getCalendar() {
            return this.calendar;
        }

        public void setCalendar(Calendar calendar) {
            this.calendar = calendar;
        }

        public String getContent() {
            return this.content;
        }

        public void setContent(String content) {
            this.content = content;
        }

        public String getComment() {
            return this.comment;
        }

        public void setComment(String comment) {
            this.comment = comment;
        }

        public VersionData(String name, String author, Calendar calendar, String content, String comment) {
            this.name = name;
            this.author = author;
            this.calendar = calendar;
            this.content = content;
            this.comment = comment;
        }

        @Override
        public int compareTo(VersionData arg0) {
            return this.name.length() != arg0.name.length() ? new Integer(this.name.length()).compareTo(arg0.name.length()) : this.name.compareTo(arg0.name);
        }
    }

    public class RemoveMixVersionable
    implements Runnable {
        private String ws;
        private String nodePath;

        public RemoveMixVersionable(Node node) {
            try {
                this.ws = node.getSession().getWorkspace().getName();
                this.nodePath = node.getPath();
            }
            catch (RepositoryException e) {
                this.ws = "";
                this.nodePath = "";
            }
        }

        @Override
        public void run() {
            SessionProvider provider;
            block8: {
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("Removing mix:versionable from " + this.ws + ": " + this.nodePath));
                }
                provider = SessionProvider.createSystemProvider();
                try {
                    Session session = provider.getSession(this.ws, ((RepositoryService)Utils.getService(RepositoryService.class)).getCurrentRepository());
                    Node node = (Node)session.getItem(this.nodePath);
                    node.removeMixin("mix:versionable");
                    node.save();
                    if (LOG.isInfoEnabled()) {
                        LOG.info((Object)("mix:versionable was removed from " + this.ws + ": " + this.nodePath));
                    }
                }
                catch (LoginException e) {
                    if (LOG.isWarnEnabled()) {
                        LOG.warn((Object)("mix:versionable cannot be removed from " + this.ws + ": " + this.nodePath));
                    }
                }
                catch (NoSuchWorkspaceException e) {
                    if (LOG.isWarnEnabled()) {
                        LOG.warn((Object)("mix:versionable cannot be removed from " + this.ws + ": " + this.nodePath));
                    }
                }
                catch (RepositoryException e) {
                    if (!LOG.isWarnEnabled()) break block8;
                    LOG.warn((Object)("mix:versionable cannot be removed from " + this.ws + ": " + this.nodePath));
                }
            }
            provider.close();
        }
    }
}

