/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.tree;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.wiki.mow.api.Page;
import org.exoplatform.wiki.mow.api.PermissionType;
import org.exoplatform.wiki.mow.api.Wiki;
import org.exoplatform.wiki.service.WikiPageParams;
import org.exoplatform.wiki.service.WikiService;
import org.exoplatform.wiki.tree.PageTreeNode;
import org.exoplatform.wiki.tree.TreeNode;
import org.exoplatform.wiki.tree.TreeNodeType;
import org.exoplatform.wiki.tree.utils.TreeUtils;
import org.exoplatform.wiki.utils.Utils;

public class WikiHomeTreeNode
extends TreeNode {
    private static final Log log = ExoLogger.getLogger(WikiHomeTreeNode.class);
    private Page wikiHome;
    private WikiService wikiService = (WikiService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(WikiService.class);

    public WikiHomeTreeNode(Page wikiHome) throws Exception {
        super(wikiHome.getTitle(), TreeNodeType.WIKIHOME);
        this.wikiHome = wikiHome;
        this.path = this.buildPath();
        this.hasChild = !this.wikiService.getChildrenPageOf(wikiHome).isEmpty();
    }

    @Override
    protected void addChildren(HashMap<String, Object> context) throws Exception {
        List<Page> pages = this.wikiService.getChildrenPageOf(this.wikiHome);
        Iterator childPageIterator = pages.iterator();
        int size = this.getNumberOfChildren(context, pages.size());
        Page currentPage = (Page)context.get("selectedPage");
        for (int count = 0; childPageIterator.hasNext() && count < size; ++count) {
            Page childPage = (Page)childPageIterator.next();
            if (!this.wikiService.hasPermissionOnPage(childPage, PermissionType.VIEWPAGE, ConversationState.getCurrent().getIdentity()) && (currentPage == null || !Utils.isDescendantPage(currentPage, childPage))) continue;
            PageTreeNode child = new PageTreeNode(childPage);
            this.children.add(child);
        }
        super.addChildren(context);
    }

    public Page getWikiHome() {
        return this.wikiHome;
    }

    public PageTreeNode getChildByName(String name) throws Exception {
        for (TreeNode child : this.children) {
            if (!child.getName().equals(name)) continue;
            return (PageTreeNode)child;
        }
        return null;
    }

    public PageTreeNode findDescendantNodeByName(List<TreeNode> listPageTreeNode, String name) throws Exception {
        for (TreeNode pageTreeNode : listPageTreeNode) {
            if (pageTreeNode.getName().equals(name)) {
                return (PageTreeNode)pageTreeNode;
            }
            List<TreeNode> listChildPageTreeNode = pageTreeNode.getChildren();
            if (listChildPageTreeNode.size() <= 0) continue;
            return this.findDescendantNodeByName(listChildPageTreeNode, name);
        }
        return null;
    }

    @Override
    public String buildPath() {
        try {
            Wiki wiki = this.wikiService.getWikiByTypeAndOwner(this.wikiHome.getWikiType(), this.wikiHome.getWikiOwner());
            WikiPageParams params = new WikiPageParams(wiki.getType(), wiki.getOwner(), "WikiHome");
            return TreeUtils.getPathFromPageParams(params);
        }
        catch (Exception e) {
            log.error((Object)("Cannot build path of wiki page " + this.wikiHome.getWikiType() + ":" + this.wikiHome.getWikiOwner() + ":" + this.wikiHome.getName() + " - Cause : " + e.getMessage()), (Throwable)e);
            return null;
        }
    }
}

