/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.service.impl;

import org.chromattic.api.ChromatticSession;
import org.chromattic.api.event.EventListener;
import org.exoplatform.commons.chromattic.ChromatticLifeCycle;
import org.exoplatform.commons.chromattic.SessionContext;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.wiki.service.impl.Injector;

public class WikiChromatticLifeCycle
extends ChromatticLifeCycle {
    public static final String WIKI_LIFECYCLE_NAME = "wiki";
    private static final ThreadLocal<ChromatticSession> session = new ThreadLocal();

    public WikiChromatticLifeCycle(InitParams params) {
        super(params);
    }

    public ChromatticSession getSession() {
        if (this.invalidSession()) {
            this.reCreateSession();
        }
        return session.get();
    }

    private boolean invalidSession() {
        boolean invalid;
        boolean bl = invalid = session.get() == null;
        if (invalid) {
            return invalid;
        }
        return !session.get().getJCRSession().isLive() || session.get().isClosed();
    }

    private void reCreateSession() {
        try {
            this.onOpenSession(this.openContext());
        }
        catch (IllegalStateException e) {
            this.closeContext(false);
            if (this.getManager().getSynchronization() != null) {
                this.getManager().endRequest(false);
            }
            this.getManager().startRequest(ExoContainerContext.getCurrentContainer());
            session.set(this.getChromattic().openSession());
        }
    }

    protected void onOpenSession(SessionContext context) {
        session.set(context.getSession());
        context.getSession().addEventListener((EventListener)new Injector());
        super.onOpenSession(context);
    }

    protected void onCloseSession(SessionContext context) {
        super.onCloseSession(context);
        if (session.get() != null) {
            session.get().close();
        }
        session.remove();
    }
}

