/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.service.related;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.wiki.mow.api.Page;
import org.exoplatform.wiki.service.WikiPageParams;
import org.exoplatform.wiki.service.related.JsonRelatedData;
import org.exoplatform.wiki.tree.utils.TreeUtils;
import org.exoplatform.wiki.utils.Utils;

public final class RelatedUtil {
    private RelatedUtil() {
    }

    public static List<JsonRelatedData> pageToJson(List<Page> pages) {
        ArrayList<JsonRelatedData> jsonObjs = new ArrayList<JsonRelatedData>();
        for (Page page : pages) {
            String name = page.getName();
            String title = page.getTitle();
            String path = TreeUtils.getPathFromPageParams(Utils.getWikiPageParams(page));
            JsonRelatedData dataObj = new JsonRelatedData(name, title, path);
            jsonObjs.add(dataObj);
        }
        return jsonObjs;
    }

    public static String getPath(WikiPageParams params) {
        StringBuilder sb = new StringBuilder();
        if (params.getType() != null) {
            sb.append(params.getType());
        }
        if (params.getOwner() != null) {
            sb.append("/").append(Utils.validateWikiOwner(params.getType(), params.getOwner()));
        }
        if (params.getPageName() != null) {
            sb.append("/").append(params.getPageName());
        }
        return sb.toString();
    }

    public static WikiPageParams getPageParams(String path) throws Exception {
        return TreeUtils.getPageParamsFromPath(path);
    }
}

