/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.webui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.Lifecycle;
import org.exoplatform.wiki.commons.Utils;
import org.exoplatform.wiki.mow.core.api.wiki.PageImpl;
import org.exoplatform.wiki.service.WikiPageParams;
import org.exoplatform.wiki.service.WikiService;
import org.exoplatform.wiki.service.search.SearchResult;
import org.exoplatform.wiki.webui.UIWikiDeletePageConfirm;
import org.exoplatform.wiki.webui.WikiMode;
import org.exoplatform.wiki.webui.core.UIWikiComponent;

@ComponentConfig(lifecycle=Lifecycle.class, template="app:/templates/wiki/webui/UIWikiDeletePageConfirm.gtmpl", events={@EventConfig(listeners={OKActionListener.class}), @EventConfig(listeners={CancelActionListener.class})})
public class UIWikiDeletePageConfirm
extends UIWikiComponent {
    private WikiService wservice;
    private String pageID;
    private String owner;

    public UIWikiDeletePageConfirm() throws Exception {
        this.accept_Modes = Arrays.asList(WikiMode.DELETEPAGE);
        this.wservice = (WikiService)PortalContainer.getComponent(WikiService.class);
    }

    protected List<SearchResult> getRelativePages() {
        try {
            WikiPageParams params = Utils.getCurrentWikiPageParams();
            return this.wservice.searchRenamedPage(params.getType(), params.getOwner(), params.getPageId());
        }
        catch (Exception e) {
            return new ArrayList<SearchResult>();
        }
    }

    protected PageImpl getCurrentPage() {
        try {
            WikiPageParams params = Utils.getCurrentWikiPageParams();
            this.pageID = params.getPageId();
            this.owner = params.getOwner();
            return (PageImpl)this.wservice.getPageById(params.getType(), params.getOwner(), params.getPageId());
        }
        catch (Exception e) {
            return null;
        }
    }

    protected String getCurrentPageId() {
        return this.pageID;
    }

    protected String getWiki() {
        return this.owner;
    }

    protected String getHomeURL() {
        return Util.getPortalRequestContext().getPortalURI() + "wiki";
    }
}

