/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.webui;

import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.ext.UIExtensionManager;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.input.UICheckBoxInput;
import org.exoplatform.wiki.chromattic.ext.ntdef.NTVersion;
import org.exoplatform.wiki.commons.Utils;
import org.exoplatform.wiki.webui.UIWikiPageVersionsList;
import org.exoplatform.wiki.webui.WikiMode;
import org.exoplatform.wiki.webui.control.action.RestoreRevisionActionComponent;
import org.exoplatform.wiki.webui.control.action.ViewRevisionActionListener;
import org.exoplatform.wiki.webui.core.UIWikiForm;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/wiki/webui/UIWikiPageVersionsList.gtmpl", events={@EventConfig(listeners={ViewRevisionActionListener.class}), @EventConfig(listeners={CompareRevisionActionListener.class})})
public class UIWikiPageVersionsList
extends UIWikiForm {
    private List<NTVersion> versionsList;
    public static final String RESTORE_ACTION = "RestoreRevision";
    public static final String VIEW_REVISION = "ViewRevision";
    public static final String COMPARE_ACTION = "CompareRevision";
    public static final String EXTENSION_TYPE = "org.exoplatform.wiki.webui.UIWikiPageVersionsList";
    public static final String VERSION_NAME_PREFIX = "version";

    public UIWikiPageVersionsList() throws Exception {
        this.accept_Modes = Arrays.asList(WikiMode.SHOWHISTORY, WikiMode.VIEW);
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        this.versionsList = Utils.getCurrentPageRevisions();
        this.getChildren().clear();
        for (NTVersion version : this.versionsList) {
            this.addUIFormInput((UIFormInput)new UICheckBoxInput("version_" + version.getName(), "", Boolean.valueOf(false)));
        }
        this.addChild(RestoreRevisionActionComponent.class, null, null);
        super.processRender(context);
    }

    public List<NTVersion> getVersionsList() throws Exception {
        return this.versionsList;
    }

    protected void renderRestoreRevisionActions(String versionName) throws Exception {
        if (versionName == null || this.versionsList.isEmpty()) {
            return;
        }
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        ResourceBundle bundle = context.getApplicationResourceBundle();
        RestoreRevisionActionComponent component = (RestoreRevisionActionComponent)this.getChild(RestoreRevisionActionComponent.class);
        component.setVersionName(versionName);
        component.setCurrentVersion(versionName.equals(((NTVersion)this.versionsList.get(0)).getName()));
        component.setLabel(bundle.getString("UIWikiPageVersionsList.label.RestoreRevision"));
        component.setTooltip(bundle.getString("UIWikiPageVersionsList.title.RestoreRevision"));
        UIExtensionManager manager = (UIExtensionManager)this.getApplicationComponent(UIExtensionManager.class);
        if (manager.accept(EXTENSION_TYPE, RESTORE_ACTION, null)) {
            this.renderChild(RestoreRevisionActionComponent.class);
        }
    }

    static /* synthetic */ List access$000(UIWikiPageVersionsList x0) {
        return x0.versionsList;
    }
}

