/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.webui;

import org.exoplatform.container.PortalContainer;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.commons.UISpacesSwitcher;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.lifecycle.Lifecycle;
import org.exoplatform.wiki.commons.Utils;
import org.exoplatform.wiki.service.WikiPageParams;
import org.exoplatform.wiki.service.WikiService;
import org.exoplatform.wiki.webui.UIWikiApplicationControlArea;
import org.exoplatform.wiki.webui.UIWikiBreadCrumb;
import org.exoplatform.wiki.webui.UIWikiPortlet;
import org.exoplatform.wiki.webui.UIWikiSearchBox;
import org.exoplatform.wiki.webui.control.UIWikiToolBar;

@ComponentConfig(lifecycle=Lifecycle.class, template="app:/templates/wiki/webui/UIWikiApplicationControlArea.gtmpl")
public class UIWikiApplicationControlArea
extends UIContainer {
    public UIWikiApplicationControlArea() throws Exception {
        this.addChild(UIWikiSearchBox.class, null, null);
        this.addChild(UIWikiToolBar.class, null, null);
        UIWikiBreadCrumb uiWikiBreadCrumb = (UIWikiBreadCrumb)this.addChild(UIWikiBreadCrumb.class, null, null);
        uiWikiBreadCrumb.setAllowChooseSpace(true);
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        UIWikiBreadCrumb wikiBreadCrumb = (UIWikiBreadCrumb)this.findFirstComponentOfType(UIWikiBreadCrumb.class);
        WikiService wikiService = (WikiService)PortalContainer.getComponent(WikiService.class);
        String currentActionLabel = this.getCurrentActionLabel();
        WikiPageParams params = Utils.getCurrentWikiPageParams();
        wikiBreadCrumb.setBreadCumbs(wikiService.getBreadcumb(params.getType(), params.getOwner(), params.getPageId()));
        UISpacesSwitcher uiWikiSpaceSwitcher = (UISpacesSwitcher)wikiBreadCrumb.getChildById("UISpaceSwitcher_BreadCrumb");
        uiWikiSpaceSwitcher.setCurrentSpaceName(Utils.upperFirstCharacter((String)Utils.getCurrentSpaceName()));
        wikiBreadCrumb.setActionLabel(currentActionLabel);
        super.processRender(context);
    }

    private String getCurrentActionLabel() {
        UIWikiPortlet wikiPortlet = (UIWikiPortlet)this.getAncestorOfType(UIWikiPortlet.class);
        switch (1.$SwitchMap$org$exoplatform$wiki$webui$WikiMode[wikiPortlet.getWikiMode().ordinal()]) {
            case 1: {
                return "UIWikiPortlet.label.Edit-Page";
            }
            case 2: {
                return "UIWikiPortlet.label.Add-Page";
            }
            case 3: {
                return "UIWikiPortlet.label.Advanced-Search";
            }
            case 4: {
                return "UIWikiPortlet.label.Show-History";
            }
            case 5: {
                return "UIWikiPortlet.label.View-Revision";
            }
            case 6: {
                return "UIWikiPortlet.label.Delete-Confirm";
            }
            case 7: {
                return "UIWikiPortlet.label.Edit-Template";
            }
            case 8: {
                return "UIWikiPortlet.label.Add-Template";
            }
            case 9: {
                return "UIWikiPortlet.label.Compare-Revision";
            }
            case 10: {
                return "UIWikiPortlet.label.Setting";
            }
        }
        return "";
    }
}

