/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.webui.core;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.wiki.webui.UIWikiAdvanceSearchForm;
import org.exoplatform.wiki.webui.UIWikiPortlet;
import org.exoplatform.wiki.webui.core.UIAdvancePageIterator;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/wiki/webui/UIAdvancePageIterator.gtmpl", events={@EventConfig(listeners={GoPageActionListener.class}), @EventConfig(listeners={GoNumberPageActionListener.class})})
public class UIAdvancePageIterator
extends UIForm {
    public static String PREVIOUS = "previous".intern();
    public static String NEXT = "next".intern();
    public static String FIRST = "first".intern();
    public static String LAST = "last".intern();
    public static String GOPAGE = "GoPage".intern();
    public static String GOTOPPAGE = "goPageTop".intern();
    private int beginPageRange = 0;
    private int endPageRange = 0;
    private int currentPage;

    public UIAdvancePageIterator() {
        this.addUIFormInput((UIFormInput)new UIFormStringInput(GOTOPPAGE, null));
        this.setSubmitAction("return false;");
    }

    public List<String> getDisplayedRange() throws Exception {
        UIWikiPortlet wikiPortlet = (UIWikiPortlet)this.getAncestorOfType(UIWikiPortlet.class);
        UIWikiAdvanceSearchForm advanceSearchForm = (UIWikiAdvanceSearchForm)wikiPortlet.findFirstComponentOfType(UIWikiAdvanceSearchForm.class);
        int maxPage = advanceSearchForm.getPageAvailable();
        long page = this.currentPage;
        if (page <= 3L) {
            this.beginPageRange = 1;
            this.endPageRange = maxPage <= 7 ? maxPage : 7;
        } else if ((long)maxPage > page + 3L) {
            this.endPageRange = (int)(page + 3L);
            this.beginPageRange = (int)(page - 3L);
        } else {
            this.endPageRange = maxPage;
            this.beginPageRange = maxPage > 7 ? maxPage - 6 : 1;
        }
        ArrayList<String> temp = new ArrayList<String>();
        for (int i = this.beginPageRange; i <= this.endPageRange; ++i) {
            temp.add(String.valueOf(i));
        }
        return temp;
    }

    public void setCurrentPage(int currentPage) {
        this.currentPage = currentPage;
    }

    public int getMaxPage() {
        UIWikiPortlet wikiPortlet = (UIWikiPortlet)this.getAncestorOfType(UIWikiPortlet.class);
        UIWikiAdvanceSearchForm advanceSearchForm = (UIWikiAdvanceSearchForm)wikiPortlet.findFirstComponentOfType(UIWikiAdvanceSearchForm.class);
        return advanceSearchForm.getPageAvailable();
    }

    static /* synthetic */ int access$000(UIAdvancePageIterator x0) {
        return x0.currentPage;
    }
}

