/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.webui;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.UIPopupContainer;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.wiki.commons.Utils;
import org.exoplatform.wiki.mow.core.api.wiki.PageImpl;
import org.exoplatform.wiki.service.WikiPageParams;
import org.exoplatform.wiki.service.WikiService;
import org.exoplatform.wiki.service.search.SearchResult;
import org.exoplatform.wiki.webui.UIWikiDeletePageConfirm;
import org.exoplatform.wiki.webui.UIWikiPortlet;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/wiki/webui/UIWikiDeletePageConfirm.gtmpl", events={@EventConfig(listeners={OKActionListener.class}), @EventConfig(listeners={CancelActionListener.class})})
public class UIWikiDeletePageConfirm
extends UIForm
implements UIPopupComponent {
    public static final String OK_ACTION = "OK";
    public static final String CANCEL_ACTION = "Cancel";
    private WikiService wservice = (WikiService)PortalContainer.getComponent(WikiService.class);
    private String pageID;
    private String owner;

    protected List<SearchResult> getRelativePages() {
        try {
            WikiPageParams params = Utils.getCurrentWikiPageParams();
            return this.wservice.searchRenamedPage(params.getType(), params.getOwner(), params.getPageId());
        }
        catch (Exception e) {
            return new ArrayList<SearchResult>();
        }
    }

    protected PageImpl getCurrentPage() {
        try {
            WikiPageParams params = Utils.getCurrentWikiPageParams();
            this.pageID = params.getPageId();
            this.owner = params.getOwner();
            return (PageImpl)this.wservice.getPageById(params.getType(), params.getOwner(), params.getPageId());
        }
        catch (Exception e) {
            return null;
        }
    }

    protected String getCurrentPageId() {
        return this.pageID;
    }

    protected String getWiki() {
        return this.owner;
    }

    protected String getHomeURL() {
        return Util.getPortalRequestContext().getPortalURI() + "wiki";
    }

    protected void cancelPopup(Event<UIWikiDeletePageConfirm> event) throws Exception {
        UIWikiPortlet wikiPortlet = (UIWikiPortlet)this.getAncestorOfType(UIWikiPortlet.class);
        UIPopupContainer popupContainer = wikiPortlet.getPopupContainer(UIWikiPortlet.PopupLevel.L1);
        popupContainer.cancelPopupAction();
        event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)popupContainer);
    }

    public void activate() {
    }

    public void deActivate() {
    }
}

